/*
 * Decompiled with CFR 0.152.
 */
package de.markusbordihn.easynpc.configui.client.screen.configuration.preset;

import de.markusbordihn.easynpc.client.screen.components.Checkbox;
import de.markusbordihn.easynpc.client.screen.components.ExportButton;
import de.markusbordihn.easynpc.client.screen.components.FileBrowserButton;
import de.markusbordihn.easynpc.client.screen.components.SpinButton;
import de.markusbordihn.easynpc.client.screen.components.Text;
import de.markusbordihn.easynpc.client.screen.components.TextField;
import de.markusbordihn.easynpc.configui.client.screen.configuration.preset.ExportPresetConfigurationScreen;
import de.markusbordihn.easynpc.configui.menu.configuration.ConfigurationMenu;
import de.markusbordihn.easynpc.configui.network.NetworkMessageHandlerManager;
import de.markusbordihn.easynpc.data.preset.PresetExportFormat;
import de.markusbordihn.easynpc.data.preset.PresetMetadata;
import de.markusbordihn.easynpc.data.skin.SkinModel;
import de.markusbordihn.easynpc.io.CustomPresetDataFiles;
import de.markusbordihn.easynpc.network.components.TextComponent;
import java.io.File;
import java.util.Collections;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Objects;
import java.util.Set;
import java.util.UUID;
import net.minecraft.class_156;
import net.minecraft.class_1661;
import net.minecraft.class_2561;
import net.minecraft.class_327;
import net.minecraft.class_332;
import net.minecraft.class_342;
import net.minecraft.class_364;
import net.minecraft.class_410;
import net.minecraft.class_4185;
import net.minecraft.class_437;
import net.minecraft.class_5244;
import net.minecraft.class_5348;
import net.minecraft.class_5481;

public class ExportCustomPresetConfigurationScreen<T extends ConfigurationMenu>
extends ExportPresetConfigurationScreen<T> {
    private static final Set<String> PRESET_CATEGORIES = new LinkedHashSet<String>(List.of("General", "Villager", "Guard", "Trader", "Quest", "Custom"));
    private static boolean lastSnbtFormatPreference = false;
    protected class_4185 exportPresetButton;
    protected class_4185 openCustomExportPresetFolder;
    protected int numberOfTextLines = 1;
    private File customPresetFile;
    private String customPresetFileName = "";
    private class_342 nameBox;
    private SpinButton<String> categorySpinButton;
    private class_342 versionBox;
    private class_342 descriptionBox;
    private class_342 authorBox;
    private Checkbox snbtCheckbox;
    private List<class_5481> textComponents = Collections.emptyList();

    public ExportCustomPresetConfigurationScreen(T menu, class_1661 inventory, class_2561 component) {
        super(menu, inventory, component);
    }

    @Override
    public void method_25426() {
        super.method_25426();
        this.customExportPresetButton.field_22763 = false;
        this.customPresetFile = CustomPresetDataFiles.getPresetFile((SkinModel)this.getSkinModel(), (UUID)this.getEasyNPCUUID());
        this.customPresetFileName = PresetExportFormat.removePresetExtension((String)this.customPresetFile.getName());
        this.textComponents = this.field_22793.method_1728((class_5348)TextComponent.getTranslatedConfigText((String)"export_preset_text", (String)this.customPresetFile.getParentFile().getPath()), this.imageWidth - 30);
        this.numberOfTextLines = this.textComponents.size();
        this.nameBox = new TextField(this.field_22793, this.contentLeftPos + 5, this.bottomPos - 140, 300);
        this.nameBox.method_1880(64);
        this.nameBox.method_1852(this.customPresetFileName);
        this.method_37063((class_364)this.nameBox);
        int metaDataYOffset = this.nameBox.method_46427() + 35;
        String defaultCategory = "General";
        String defaultAuthor = this.field_22787 != null && this.field_22787.field_1724 != null ? this.field_22787.field_1724.method_5477().getString() : "Unknown";
        this.categorySpinButton = new SpinButton(this.contentLeftPos + 5, metaDataYOffset, 130, 16, PRESET_CATEGORIES, (Object)defaultCategory, null);
        this.method_37063((class_364)this.categorySpinButton);
        this.versionBox = new TextField(this.field_22793, this.contentLeftPos + 230, metaDataYOffset, 75);
        this.versionBox.method_1880(12);
        this.versionBox.method_1852("1.0.0");
        this.method_37063((class_364)this.versionBox);
        this.descriptionBox = new TextField(this.field_22793, this.contentLeftPos + 5, metaDataYOffset + 35, 180);
        this.descriptionBox.method_1880(128);
        this.descriptionBox.method_1852("");
        this.method_37063((class_364)this.descriptionBox);
        this.authorBox = new TextField(this.field_22793, this.contentLeftPos + 200, metaDataYOffset + 35, 105);
        this.authorBox.method_1880(16);
        this.authorBox.method_1852(defaultAuthor);
        this.method_37063((class_364)this.authorBox);
        this.exportPresetButton = (class_4185)this.method_37063((class_364)new ExportButton(this.contentLeftPos + 5, this.bottomPos - 45, 140, 20, "export_preset", button -> {
            if (this.snbtCheckbox.selected()) {
                this.showSnbtWarning();
            } else {
                this.exportPreset();
            }
        }));
        this.snbtCheckbox = new Checkbox(this.exportPresetButton.method_46426(), this.exportPresetButton.method_46427() + 20, "export_preset.use_snbt_format", lastSnbtFormatPreference, checkbox -> {
            lastSnbtFormatPreference = checkbox.selected();
        });
        this.method_37063((class_364)this.snbtCheckbox);
        this.openCustomExportPresetFolder = (class_4185)this.method_37063((class_364)new FileBrowserButton(this.exportPresetButton.method_46426() + this.exportPresetButton.method_25368() + 20, this.exportPresetButton.method_46427(), 140, 20, "open_export_folder", button -> class_156.method_668().method_672(this.customPresetFile.getParentFile())));
    }

    private void showSnbtWarning() {
        if (this.field_22787 != null) {
            this.field_22787.method_1507((class_437)new class_410(confirmed -> {
                if (confirmed) {
                    this.exportPreset();
                }
                this.field_22787.method_1507((class_437)this);
            }, (class_2561)TextComponent.getTranslatedConfigText((String)"export_preset.snbt_warning_title"), (class_2561)TextComponent.getTranslatedConfigText((String)"export_preset.snbt_warning_message"), (class_2561)TextComponent.getTranslatedConfigText((String)"export_preset.snbt_confirm"), class_5244.field_24335));
        }
    }

    private void exportPreset() {
        String displayName = this.nameBox.method_1882();
        NetworkMessageHandlerManager.getServerHandler().exportPreset(this.getEasyNPCUUID(), displayName, this.snbtCheckbox.selected() ? PresetExportFormat.SNBT : PresetExportFormat.NBT, PresetMetadata.createDefault((String)displayName, (String)this.authorBox.method_1882()).withCategory((String)this.categorySpinButton.get()).withVersion(this.versionBox.method_1882()).withDescription(this.descriptionBox.method_1882()));
    }

    public void updateTick() {
        super.updateTick();
        this.exportPresetButton.field_22763 = this.nameBox != null && !this.nameBox.method_1882().isEmpty();
    }

    public void method_25394(class_332 guiGraphics, int x, int y, float partialTicks) {
        super.method_25394(guiGraphics, x, y, partialTicks);
        if (!this.textComponents.isEmpty()) {
            for (int line = 0; line < this.numberOfTextLines; ++line) {
                class_5481 formattedCharSequence = this.textComponents.get(line);
                Objects.requireNonNull(this.field_22793);
                Text.drawString((class_332)guiGraphics, (class_327)this.field_22793, (class_5481)formattedCharSequence, (int)(this.leftPos + 15), (int)(this.topPos + 25 + line * (9 + 2)));
            }
        }
        if (this.categorySpinButton != null) {
            Text.drawString((class_332)guiGraphics, (class_327)this.field_22793, (class_2561)class_2561.method_43470((String)"Category:"), (int)this.categorySpinButton.method_46426(), (int)(this.categorySpinButton.method_46427() - 10));
        }
        if (this.versionBox != null) {
            Text.drawString((class_332)guiGraphics, (class_327)this.field_22793, (class_2561)class_2561.method_43470((String)"Version:"), (int)this.versionBox.method_46426(), (int)(this.versionBox.method_46427() - 10));
        }
        if (this.authorBox != null) {
            Text.drawString((class_332)guiGraphics, (class_327)this.field_22793, (class_2561)class_2561.method_43470((String)"Author:"), (int)this.authorBox.method_46426(), (int)(this.authorBox.method_46427() - 10));
        }
        if (this.descriptionBox != null) {
            Text.drawString((class_332)guiGraphics, (class_327)this.field_22793, (class_2561)class_2561.method_43470((String)"Description:"), (int)this.descriptionBox.method_46426(), (int)(this.descriptionBox.method_46427() - 10));
        }
    }
}

