/*
 * Decompiled with CFR 0.152.
 */
package de.markusbordihn.easynpc.configui.client.screen.configuration.rotation;

import de.markusbordihn.easynpc.client.screen.components.Checkbox;
import de.markusbordihn.easynpc.client.screen.components.RangeSliderButton;
import de.markusbordihn.easynpc.client.screen.components.SliderButton;
import de.markusbordihn.easynpc.client.screen.components.Text;
import de.markusbordihn.easynpc.client.screen.components.TextButton;
import de.markusbordihn.easynpc.configui.client.screen.configuration.rotation.RotationConfigurationScreen;
import de.markusbordihn.easynpc.configui.menu.configuration.ConfigurationMenu;
import de.markusbordihn.easynpc.configui.network.NetworkMessageHandlerManager;
import de.markusbordihn.easynpc.data.model.ModelPartType;
import de.markusbordihn.easynpc.data.rotation.CustomRotation;
import de.markusbordihn.easynpc.entity.easynpc.data.ModelDataCapable;
import de.markusbordihn.easynpc.network.components.TextComponent;
import net.minecraft.class_1661;
import net.minecraft.class_2561;
import net.minecraft.class_327;
import net.minecraft.class_332;
import net.minecraft.class_364;

public class DefaultRotationConfigurationScreen<T extends ConfigurationMenu>
extends RotationConfigurationScreen<T> {
    protected Checkbox rootRotationCheckbox;

    public DefaultRotationConfigurationScreen(T menu, class_1661 inventory, class_2561 component) {
        super(menu, inventory, component);
        this.showCloseButton = true;
        this.renderBackground = false;
    }

    private void sendRotationUpdate(float x, float y, float z) {
        NetworkMessageHandlerManager.getServerHandler().modelRotationChange(this.getEasyNPCUUID(), ModelPartType.ROOT, new CustomRotation(x, y, z));
    }

    @Override
    public void method_25426() {
        super.method_25426();
        this.defaultRotationButton.field_22763 = false;
        ModelDataCapable modelData = this.getEasyNPC().getEasyNPCModelData();
        CustomRotation rootRotation = modelData.getModelPartRotation(ModelPartType.ROOT);
        int sliderWidth = 80;
        int sliderHeight = 16;
        int sliderLeftPosition = this.contentLeftPos + 10;
        int sliderTopPosition = this.contentTopPos;
        RangeSliderButton sliderButtonX = (RangeSliderButton)this.method_37063((class_364)new RangeSliderButton(sliderLeftPosition, sliderTopPosition, sliderWidth, sliderHeight, Math.toDegrees(rootRotation.x()), 0.0, SliderButton.Type.DEGREE, false, slider -> {
            CustomRotation current = modelData.getModelPartRotation(ModelPartType.ROOT);
            this.sendRotationUpdate((float)Math.toRadians(slider.getTargetValue()), current.y(), current.z());
        }));
        RangeSliderButton sliderButtonY = (RangeSliderButton)this.method_37063((class_364)new RangeSliderButton(sliderButtonX.method_46426() + sliderButtonX.method_25368(), sliderTopPosition, sliderWidth, sliderHeight, (double)rootRotation.y(), 0.0, SliderButton.Type.DEGREE, false, slider -> {
            CustomRotation current = modelData.getModelPartRotation(ModelPartType.ROOT);
            this.sendRotationUpdate(current.x(), slider.getTargetValue(), current.z());
        }));
        RangeSliderButton sliderButtonZ = (RangeSliderButton)this.method_37063((class_364)new RangeSliderButton(sliderButtonY.method_46426() + sliderButtonY.method_25368(), sliderTopPosition, sliderWidth, sliderHeight, Math.toDegrees(rootRotation.z()), 0.0, SliderButton.Type.DEGREE, false, slider -> {
            CustomRotation current = modelData.getModelPartRotation(ModelPartType.ROOT);
            this.sendRotationUpdate(current.x(), current.y(), (float)Math.toRadians(slider.getTargetValue()));
        }));
        this.method_37063((class_364)new TextButton(this.contentLeftPos, sliderTopPosition, 10, RangeSliderButton.EDIT_TEXT, button -> {
            if (button.method_25369() == RangeSliderButton.EDIT_TEXT) {
                sliderButtonX.showTextField();
                sliderButtonY.showTextField();
                sliderButtonZ.showTextField();
                button.method_25355(RangeSliderButton.DONE_TEXT);
            } else {
                sliderButtonX.showSliderButton();
                sliderButtonY.showSliderButton();
                sliderButtonZ.showSliderButton();
                button.method_25355(RangeSliderButton.EDIT_TEXT);
            }
        }));
        int resetButtonLeftPosition = sliderButtonZ.method_46426() + sliderButtonZ.method_25368();
        this.method_37063((class_364)new TextButton(resetButtonLeftPosition, sliderTopPosition, 10, (class_2561)TextComponent.getText((String)"\u21ba"), button -> {
            sliderButtonX.reset();
            sliderButtonY.reset();
            sliderButtonZ.reset();
            this.sendRotationUpdate(0.0f, 0.0f, 0.0f);
        }));
        this.rootRotationCheckbox = (Checkbox)this.method_37063((class_364)new Checkbox(resetButtonLeftPosition + 15, sliderTopPosition + 1, "lock_rotation", modelData.getModelPartRotation(ModelPartType.ROOT).locked(), checkbox -> NetworkMessageHandlerManager.getServerHandler().modelRotationChange(this.getEasyNPCUUID(), ModelPartType.ROOT, modelData.getModelPartRotation(ModelPartType.ROOT).withLocked(checkbox.selected()))));
    }

    public void updateTick() {
        super.updateTick();
        ModelDataCapable modelData = this.getEasyNPC().getEasyNPCModelData();
        if (modelData != null) {
            CustomRotation rootRotation = modelData.getModelPartRotation(ModelPartType.ROOT);
            this.rootRotationCheckbox.setSelected(rootRotation.locked());
        }
    }

    public void method_25394(class_332 guiGraphics, int x, int y, float partialTicks) {
        super.method_25394(guiGraphics, x, y, partialTicks);
        int labelYPosition = this.contentTopPos + 19;
        Text.drawString((class_332)guiGraphics, (class_327)this.field_22793, (String)"X", (int)(this.contentLeftPos + 45), (int)labelYPosition);
        Text.drawString((class_332)guiGraphics, (class_327)this.field_22793, (String)"Y", (int)(this.contentLeftPos + 125), (int)labelYPosition);
        Text.drawString((class_332)guiGraphics, (class_327)this.field_22793, (String)"Z", (int)(this.contentLeftPos + 210), (int)labelYPosition);
    }
}

