/*
 * Decompiled with CFR 0.152.
 */
package de.markusbordihn.easynpc.configui.client.screen.configuration.trading;

import de.markusbordihn.easynpc.client.screen.components.Graphics;
import de.markusbordihn.easynpc.client.screen.components.PositiveNumberField;
import de.markusbordihn.easynpc.client.screen.components.Text;
import de.markusbordihn.easynpc.client.screen.components.TextButton;
import de.markusbordihn.easynpc.client.screen.components.TextField;
import de.markusbordihn.easynpc.configui.Constants;
import de.markusbordihn.easynpc.configui.client.screen.configuration.trading.TradingConfigurationContainerScreen;
import de.markusbordihn.easynpc.configui.menu.configuration.ConfigurationMenu;
import de.markusbordihn.easynpc.configui.network.NetworkMessageHandlerManager;
import de.markusbordihn.easynpc.data.configuration.ConfigurationType;
import de.markusbordihn.easynpc.data.trading.TradingDataSet;
import de.markusbordihn.easynpc.entity.easynpc.data.TradingDataCapable;
import de.markusbordihn.easynpc.utils.ValueUtils;
import java.util.HashMap;
import java.util.Objects;
import net.minecraft.class_1661;
import net.minecraft.class_1799;
import net.minecraft.class_1914;
import net.minecraft.class_1916;
import net.minecraft.class_1935;
import net.minecraft.class_2561;
import net.minecraft.class_2960;
import net.minecraft.class_327;
import net.minecraft.class_332;
import net.minecraft.class_342;
import net.minecraft.class_364;
import net.minecraft.class_4185;
import net.minecraft.class_9306;

public class AdvancedTradingConfigurationContainerScreen<T extends ConfigurationMenu>
extends TradingConfigurationContainerScreen<T> {
    protected static final int NAVIGATION_TICKER = 20;
    protected static final int TRADING_OFFERS_TICKER = 20;
    protected final HashMap<Integer, class_342> maxUsesEditBoxes = new HashMap();
    protected final HashMap<Integer, class_342> rewardExpEditBoxes = new HashMap();
    protected final HashMap<Integer, class_342> priceMultiplierEditBoxes = new HashMap();
    protected final HashMap<Integer, class_342> demandEditBoxes = new HashMap();
    protected class_4185 previousPageButton;
    protected class_4185 nextPageButton;
    protected class_342 resetsEveryMinEditBox;
    private int navigationTicker = 20;
    private int tradingOffersTicker = 20;

    public AdvancedTradingConfigurationContainerScreen(T menu, class_1661 inventory, class_2561 component) {
        super(menu, inventory, component);
    }

    private void onResetsEveryMinEditBoxChanged(String text) {
        if (ValueUtils.isNumericValue((String)text) && !text.isEmpty()) {
            NetworkMessageHandlerManager.getServerHandler().setAdvancedTradingResetsEveryMin(this.getEasyNPCUUID(), Integer.parseInt(text));
        }
    }

    private void onMaxUsesEditBoxChanged(int offerIndex, String value, String formerValue) {
        if (!Objects.equals(value, formerValue) && offerIndex >= 0 && ValueUtils.isPositiveNumericValueOrZero((String)value) && !value.isEmpty()) {
            NetworkMessageHandlerManager.getServerHandler().setAdvancedTradingMaxUses(this.getEasyNPCUUID(), offerIndex, Integer.parseInt(value));
        }
    }

    private void onRewardExpEditBoxChanged(int offerIndex, String value, String formerValue) {
        if (!Objects.equals(value, formerValue) && offerIndex >= 0 && ValueUtils.isNumericValue((String)value) && !value.isEmpty()) {
            NetworkMessageHandlerManager.getServerHandler().setAdvancedTradingRewardExp(this.getEasyNPCUUID(), offerIndex, Integer.parseInt(value));
        }
    }

    private void onPriceMultiplierEditBoxChanged(int offerIndex, String value, String formerValue) {
        if (!Objects.equals(value, formerValue) && offerIndex >= 0 && ValueUtils.isFloatValue((String)value) && !value.isEmpty()) {
            NetworkMessageHandlerManager.getServerHandler().setAdvancedTradingPriceMultiplier(this.getEasyNPCUUID(), offerIndex, Float.parseFloat(value));
        }
    }

    private void onDemandEditBoxChanged(int offerIndex, String value, String formerValue) {
        if (!Objects.equals(value, formerValue) && offerIndex >= 0 && ValueUtils.isNumericValue((String)value) && !value.isEmpty()) {
            NetworkMessageHandlerManager.getServerHandler().setAdvancedTradingDemand(this.getEasyNPCUUID(), offerIndex, Integer.parseInt(value));
        }
    }

    @Override
    public void method_25426() {
        super.method_25426();
        this.advancedTradesButton.field_22763 = false;
        TradingDataCapable tradingData = this.getEasyNPC().getEasyNPCTradingData();
        TradingDataSet tradingDataSet = tradingData.getTradingDataSet();
        this.resetsEveryMinEditBox = new TextField(this.field_22793, this.contentLeftPos + 250, this.contentTopPos + 172, 32);
        this.resetsEveryMinEditBox.method_1880(3);
        this.resetsEveryMinEditBox.method_1852("" + tradingDataSet.getResetsEveryMin());
        this.resetsEveryMinEditBox.method_1863(this::onResetsEveryMinEditBoxChanged);
        this.resetsEveryMinEditBox.method_1890(ValueUtils::isNumericValue);
        this.method_37063((class_364)this.resetsEveryMinEditBox);
        int editBoxPositionX = this.contentLeftPos + 140;
        int editBoxPositionY = this.field_2800 + 40;
        class_1916 merchantOffers = tradingData.getTradingOffers();
        for (int tradingOffer = 0; tradingOffer < 5; ++tradingOffer) {
            int tradingOfferIndex = ((ConfigurationMenu)this.menu).getPageIndex() * 5 + tradingOffer;
            class_1914 merchantOffer = merchantOffers.size() > tradingOfferIndex ? (class_1914)merchantOffers.get(tradingOfferIndex) : this.getEmptyMerchangeOffer();
            boolean hasValidOffer = (!merchantOffer.method_8246().method_7960() || !merchantOffer.method_8247().method_7960()) && !merchantOffer.method_8250().method_7960();
            log.info("Trading Offer {} : {}", (Object)tradingOfferIndex, (Object)merchantOffer);
            PositiveNumberField maxUsesEditBox = new PositiveNumberField(this.field_22793, editBoxPositionX, editBoxPositionY, 32);
            maxUsesEditBox.method_1880(4);
            maxUsesEditBox.method_1852((String)(merchantOffer.method_8248() > 0 ? "" + merchantOffer.method_8248() : "16"));
            maxUsesEditBox.method_1863(text -> this.onMaxUsesEditBoxChanged(tradingOfferIndex, (String)text, "" + merchantOffer.method_8248()));
            maxUsesEditBox.method_1888(hasValidOffer);
            this.maxUsesEditBoxes.put(tradingOfferIndex, (class_342)maxUsesEditBox);
            this.method_37063((class_364)maxUsesEditBox);
            TextField rewardExpEditBox = new TextField(this.field_22793, editBoxPositionX + 45, editBoxPositionY, 26);
            rewardExpEditBox.method_1880(3);
            rewardExpEditBox.method_1852((String)(merchantOffer.method_19279() >= 0 ? "" + merchantOffer.method_19279() : "0"));
            rewardExpEditBox.method_1863(text -> this.onRewardExpEditBoxChanged(tradingOfferIndex, (String)text, "" + merchantOffer.method_19279()));
            rewardExpEditBox.method_1890(ValueUtils::isNumericValue);
            rewardExpEditBox.method_1888(hasValidOffer);
            this.rewardExpEditBoxes.put(tradingOfferIndex, (class_342)rewardExpEditBox);
            this.method_37063((class_364)rewardExpEditBox);
            TextField priceMultiplierEditBox = new TextField(this.field_22793, editBoxPositionX + 85, editBoxPositionY, 32);
            priceMultiplierEditBox.method_1880(4);
            priceMultiplierEditBox.method_1852((String)(merchantOffer.method_19278() >= 0.0f ? "" + merchantOffer.method_19278() : "0"));
            priceMultiplierEditBox.method_1863(text -> this.onPriceMultiplierEditBoxChanged(tradingOfferIndex, (String)text, "" + merchantOffer.method_19278()));
            priceMultiplierEditBox.method_1890(ValueUtils::isFloatValue);
            priceMultiplierEditBox.method_1888(hasValidOffer);
            this.priceMultiplierEditBoxes.put(tradingOfferIndex, (class_342)priceMultiplierEditBox);
            this.method_37063((class_364)priceMultiplierEditBox);
            TextField demandEditBox = new TextField(this.field_22793, editBoxPositionX + 135, editBoxPositionY, 20);
            demandEditBox.method_1880(2);
            demandEditBox.method_1852((String)(merchantOffer.method_21725() >= 0 ? "" + merchantOffer.method_21725() : "0"));
            demandEditBox.method_1863(text -> this.onDemandEditBoxChanged(tradingOfferIndex, (String)text, "" + merchantOffer.method_21725()));
            demandEditBox.method_1890(ValueUtils::isNumericValue);
            demandEditBox.method_1888(hasValidOffer);
            this.demandEditBoxes.put(tradingOfferIndex, (class_342)demandEditBox);
            this.method_37063((class_364)demandEditBox);
            editBoxPositionY += 19;
        }
        this.previousPageButton = (class_4185)this.method_37063((class_364)new TextButton(this.contentLeftPos, this.contentTopPos + 115, 70, "previous_page", onPress -> NetworkMessageHandlerManager.getServerHandler().openConfiguration(this.getEasyNPCUUID(), ConfigurationType.ADVANCED_TRADING, ((ConfigurationMenu)this.menu).getPageIndex() - 1)));
        this.nextPageButton = (class_4185)this.method_37063((class_364)new TextButton(this.contentLeftPos + 235, this.contentTopPos + 115, 70, "next_page", onPress -> NetworkMessageHandlerManager.getServerHandler().openConfiguration(this.getEasyNPCUUID(), ConfigurationType.ADVANCED_TRADING, ((ConfigurationMenu)this.menu).getPageIndex() + 1)));
    }

    public void method_37432() {
        super.method_37432();
        if (this.navigationTicker++ > 20) {
            if (this.previousPageButton != null) {
                boolean bl = this.previousPageButton.field_22763 = ((ConfigurationMenu)this.menu).getPageIndex() > 0;
            }
            if (this.nextPageButton != null) {
                this.nextPageButton.field_22763 = ((ConfigurationMenu)this.menu).getPageIndex() < this.getMaxPages() - 1;
            }
            this.navigationTicker = 0;
        }
        if (this.tradingOffersTicker++ > 20) {
            for (int tradingOffer = 0; tradingOffer < 5; ++tradingOffer) {
                class_342 demandEditBox;
                class_342 priceMultiplierEditBox;
                class_342 rewardExpEditBox;
                int tradingOfferIndex = ((ConfigurationMenu)this.menu).getPageIndex() * 5 + tradingOffer;
                boolean hasValidOffer = this.isValidOffer(tradingOfferIndex);
                class_342 maxUsesEditBox = this.maxUsesEditBoxes.get(tradingOfferIndex);
                if (maxUsesEditBox != null) {
                    maxUsesEditBox.method_1888(hasValidOffer);
                }
                if ((rewardExpEditBox = this.rewardExpEditBoxes.get(tradingOfferIndex)) != null) {
                    rewardExpEditBox.method_1888(hasValidOffer);
                }
                if ((priceMultiplierEditBox = this.priceMultiplierEditBoxes.get(tradingOfferIndex)) != null) {
                    priceMultiplierEditBox.method_1888(hasValidOffer);
                }
                if ((demandEditBox = this.demandEditBoxes.get(tradingOfferIndex)) == null) continue;
                demandEditBox.method_1888(hasValidOffer);
            }
            this.tradingOffersTicker = 0;
        }
    }

    private boolean isValidOffer(int tradingOfferIndex) {
        TradingDataCapable tradingData = this.getEasyNPC().getEasyNPCTradingData();
        class_1916 merchantOffers = tradingData.getTradingOffers();
        class_1914 merchantOffer = merchantOffers.size() > tradingOfferIndex ? (class_1914)merchantOffers.get(tradingOfferIndex) : this.getEmptyMerchangeOffer();
        return (!merchantOffer.method_8246().method_7960() || !merchantOffer.method_8247().method_7960()) && !merchantOffer.method_8250().method_7960();
    }

    @Override
    public void method_25394(class_332 guiGraphics, int x, int y, float partialTicks) {
        super.method_25394(guiGraphics, x, y, partialTicks);
        this.method_2380(guiGraphics, x, y);
    }

    @Override
    protected void method_2389(class_332 guiGraphics, float partialTicks, int mouseX, int mouseY) {
        super.method_2389(guiGraphics, partialTicks, mouseX, mouseY);
        int legendTopPositionY = this.contentTopPos + 2;
        Text.drawString((class_332)guiGraphics, (class_327)this.field_22793, (String)"Cost A", (int)(this.field_2776 + 18), (int)legendTopPositionY, (int)0xA04040);
        Text.drawString((class_332)guiGraphics, (class_327)this.field_22793, (String)"Cost B", (int)(this.field_2776 + 60), (int)legendTopPositionY, (int)0x40A040);
        Text.drawString((class_332)guiGraphics, (class_327)this.field_22793, (String)"Result", (int)(this.field_2776 + 102), (int)legendTopPositionY, (int)0x4040A0);
        Text.drawString((class_332)guiGraphics, (class_327)this.field_22793, (String)"Max Uses", (int)(this.field_2776 + 140), (int)legendTopPositionY, (int)16448);
        Text.drawString((class_332)guiGraphics, (class_327)this.field_22793, (String)"XP", (int)(this.field_2776 + 198), (int)legendTopPositionY, (int)0x400040);
        Text.drawString((class_332)guiGraphics, (class_327)this.field_22793, (String)"Multiplier", (int)(this.field_2776 + 225), (int)legendTopPositionY, (int)0x404040);
        Text.drawString((class_332)guiGraphics, (class_327)this.field_22793, (String)"Demand", (int)(this.field_2776 + 275), (int)legendTopPositionY, (int)0x404000);
        int slotPositionX = this.field_2776 + 30 - 1;
        int slotPositionY = this.field_2800 + 40 - 1;
        for (int tradingOffer = 0; tradingOffer < 5; ++tradingOffer) {
            int tradingOfferIndex = ((ConfigurationMenu)this.menu).getPageIndex() * 5 + tradingOffer;
            Text.drawString((class_332)guiGraphics, (class_327)this.field_22793, (String)((tradingOfferIndex < 9 ? " " : "") + (tradingOfferIndex + 1) + "."), (int)(slotPositionX - 15), (int)(slotPositionY + 5), (int)0x404040);
            int itemASlotTopPosition = slotPositionY;
            Graphics.blit((class_332)guiGraphics, (class_2960)Constants.TEXTURE_INVENTORY, (int)slotPositionX, (int)itemASlotTopPosition, (int)7, (int)7, (int)18, (int)18);
            Text.drawString((class_332)guiGraphics, (class_327)this.field_22793, (String)"+", (int)(slotPositionX + 18 + 6), (int)(itemASlotTopPosition + 5), (int)0x404040);
            int itemBSlotLeftPosition = slotPositionX + 18 + 18;
            int itemBSlotTopPosition = slotPositionY;
            Graphics.blit((class_332)guiGraphics, (class_2960)Constants.TEXTURE_INVENTORY, (int)itemBSlotLeftPosition, (int)itemBSlotTopPosition, (int)7, (int)7, (int)18, (int)18);
            Text.drawString((class_332)guiGraphics, (class_327)this.field_22793, (String)"=", (int)(itemBSlotLeftPosition + 18 + 12), (int)(itemBSlotTopPosition + 5), (int)0x404040);
            Graphics.blit((class_332)guiGraphics, (class_2960)Constants.TEXTURE_INVENTORY, (int)(slotPositionX + 82), (int)slotPositionY, (int)7, (int)7, (int)18, (int)18);
            slotPositionY += 19;
        }
        Graphics.blit((class_332)guiGraphics, (class_2960)Constants.TEXTURE_INVENTORY, (int)(this.contentLeftPos + 72), (int)(this.contentTopPos + 135), (int)7, (int)83, (int)162, (int)54);
        Graphics.blit((class_332)guiGraphics, (class_2960)Constants.TEXTURE_INVENTORY, (int)(this.contentLeftPos + 72), (int)(this.contentTopPos + 191), (int)7, (int)141, (int)162, (int)18);
        Text.drawConfigString((class_332)guiGraphics, (class_327)this.field_22793, (String)"trading.minutes_for_trade_reset", (int)(this.contentLeftPos + 236), (int)(this.contentTopPos + 160), (int)0x404040);
    }

    public int getMaxPages() {
        return 5;
    }

    private class_1914 getEmptyMerchangeOffer() {
        return new class_1914(new class_9306((class_1935)class_1799.field_8037.method_7909(), 0), class_1799.field_8037, 0, 0, 0.0f);
    }
}

