/*
 * Decompiled with CFR 0.152.
 */
package de.markusbordihn.easynpc.configui.client.screen.editor.action;

import de.markusbordihn.easynpc.client.screen.components.AddButton;
import de.markusbordihn.easynpc.client.screen.components.Text;
import de.markusbordihn.easynpc.client.screen.components.TextButton;
import de.markusbordihn.easynpc.configui.Constants;
import de.markusbordihn.easynpc.configui.client.screen.EditorScreen;
import de.markusbordihn.easynpc.configui.client.screen.components.ActionsButton;
import de.markusbordihn.easynpc.configui.client.screen.components.DialogButtonButton;
import de.markusbordihn.easynpc.configui.client.screen.editor.action.ActionDataList;
import de.markusbordihn.easynpc.configui.data.editor.EditorType;
import de.markusbordihn.easynpc.configui.data.screen.AdditionalScreenData;
import de.markusbordihn.easynpc.configui.menu.editor.EditorMenu;
import de.markusbordihn.easynpc.configui.network.NetworkMessageHandlerManager;
import de.markusbordihn.easynpc.data.action.ActionDataEntry;
import de.markusbordihn.easynpc.data.action.ActionDataSet;
import de.markusbordihn.easynpc.data.action.ActionEventType;
import de.markusbordihn.easynpc.data.configuration.ConfigurationType;
import de.markusbordihn.easynpc.network.components.TextComponent;
import net.minecraft.class_1661;
import net.minecraft.class_2561;
import net.minecraft.class_327;
import net.minecraft.class_332;
import net.minecraft.class_364;
import net.minecraft.class_410;
import net.minecraft.class_4185;
import net.minecraft.class_437;
import net.minecraft.class_5244;

public class ActionDataEditorContainerScreen<T extends EditorMenu>
extends EditorScreen<T> {
    private static final int HOME_BUTTON_X_OFFSET = 3;
    private static final int HOME_BUTTON_Y_OFFSET = 3;
    private static final int HOME_BUTTON_WIDTH = 10;
    private static final int HOME_BUTTON_HEIGHT = 16;
    private static final int NAVIGATION_BUTTON_WIDTH = 140;
    private static final int LIST_X_OFFSET = 5;
    private static final int LIST_Y_START = 40;
    private static final int LIST_Y_END = 200;
    private static final int LIST_TOTAL_WIDTH = 314;
    private static final int HEADER_Y_OFFSET = 25;
    private static final int HEADER_HEIGHT = 18;
    private static final int ENTRY_HEIGHT = 21;
    private static final int FOOTER_Y_OFFSET = 210;
    private static final int FOOTER_HEIGHT = 31;
    private static final int ADD_BUTTON_X_OFFSET = 7;
    private static final int ADD_BUTTON_WIDTH = 300;
    private static final int COLOR_LIST_BACKGROUND = -1118482;
    private static final int COLOR_HEADER_BACKGROUND = -5592406;
    private static final int COLOR_FOOTER_BACKGROUND = -3750202;
    private static final int COLOR_SEPARATOR = -10066330;
    private final ActionDataSet actionDataSet;
    private final ActionEventType actionEventType = ((AdditionalScreenData)this.getAdditionalScreenData()).getActionEventType();
    private final ConfigurationType configurationType = ((AdditionalScreenData)this.getAdditionalScreenData()).getConfigurationType();
    private final EditorType editorType = ((AdditionalScreenData)this.getAdditionalScreenData()).getEditorType();
    private final boolean isDialogButtonContext = this.editorType != null && this.editorType == EditorType.DIALOG_BUTTON;
    private final boolean isActionEventContext = this.actionEventType != null && this.actionEventType != ActionEventType.NONE;
    protected class_4185 homeButton;
    protected class_4185 navigationLevelOne;
    protected class_4185 navigationLevelTwo;
    protected class_4185 newActionDataEntryButton;
    ActionDataList actionDataList;

    public ActionDataEditorContainerScreen(T menu, class_1661 inventory, class_2561 component) {
        super(menu, inventory, component);
        this.actionDataSet = this.getActionDataSet();
    }

    private ActionDataSet getActionDataSet() {
        if (this.isActionEventContext) {
            return ((AdditionalScreenData)this.getAdditionalScreenData()).getActionEventSet().getActionEvents(this.actionEventType);
        }
        if (this.isDialogButtonContext) {
            return this.getDialogButtonData().actionDataSet();
        }
        log.error("No valid action data set found!");
        return null;
    }

    public void method_25426() {
        super.method_25426();
        this.homeButton = (class_4185)this.method_37063((class_364)new TextButton(this.leftPos + 3, this.topPos + 3, 10, 16, "<", onPress -> this.handleBackNavigation()));
        if (this.isActionEventContext) {
            this.navigationLevelOne = (class_4185)this.method_37063((class_364)new ActionsButton(this.homeButton.method_46426() + this.homeButton.method_25368(), this.topPos + 3, 140, this.actionEventType.name(), onPress -> this.navigateToActionDataEditor()));
            this.navigationLevelOne.field_22763 = false;
        } else if (this.isDialogButtonContext) {
            this.navigationLevelOne = (class_4185)this.method_37063((class_364)new DialogButtonButton(this.homeButton.method_46426() + this.homeButton.method_25368(), this.topPos + 3, 140, this.getDialogButtonData().getButtonName(21).getString(), onPress -> NetworkMessageHandlerManager.getServerHandler().openDialogButtonEditor(this.getEasyNPCUUID(), this.getDialogUUID(), this.getDialogButtonUUID())));
        } else {
            this.navigationLevelOne = (class_4185)this.method_37063((class_364)new ActionsButton(this.homeButton.method_46426() + this.homeButton.method_25368(), this.topPos + 3, 140, "Actions", onPress -> this.navigateToActionDataEditor()));
            this.navigationLevelOne.field_22763 = false;
        }
        if (this.isDialogButtonContext) {
            this.navigationLevelTwo = (class_4185)this.method_37063((class_364)new ActionsButton(this.navigationLevelOne.method_46426() + this.navigationLevelOne.method_25368(), this.topPos + 3, 140, "Actions", onPress -> this.navigateToActionDataEditor()));
            this.navigationLevelTwo.field_22763 = false;
        }
        this.newActionDataEntryButton = (class_4185)this.method_37063((class_364)new AddButton(this.leftPos + 7, this.topPos + 210, 300, "action.add", onPress -> this.handleNewActionDataEntry()));
        this.actionDataList = new ActionDataList(this.actionDataSet, this.field_22787, this.field_22789 + 50, this.field_22790 - 60, this.leftPos + 5, this.topPos + 40, this.topPos + 200, 21, this::handleMoveUpOrderActionDataEntry, this::handleMoveDownOrderActionDataEntry, this::handleEditActionDataEntry, this::handleDeleteActionDataEntry);
        this.method_25429((class_364)this.actionDataList);
    }

    private void navigateToActionDataEditor() {
        if (this.configurationType != null && this.configurationType != ConfigurationType.NONE) {
            NetworkMessageHandlerManager.getServerHandler().openActionDataEditor(this.getEasyNPCUUID(), this.actionEventType, this.configurationType);
        } else if (this.isDialogButtonContext) {
            NetworkMessageHandlerManager.getServerHandler().openActionDataEditor(this.getEasyNPCUUID(), this.editorType, this.getDialogUUID(), this.getDialogButtonUUID());
        } else {
            log.error("No valid navigation found!");
            NetworkMessageHandlerManager.getServerHandler().openConfiguration(this.getEasyNPCUUID(), ConfigurationType.MAIN);
        }
    }

    private void handleBackNavigation() {
        if (this.configurationType != null && this.configurationType != ConfigurationType.NONE) {
            NetworkMessageHandlerManager.getServerHandler().openConfiguration(this.getEasyNPCUUID(), this.configurationType);
        } else if (this.isDialogButtonContext) {
            NetworkMessageHandlerManager.getServerHandler().openDialogButtonEditor(this.getEasyNPCUUID(), this.getDialogUUID(), this.getDialogButtonUUID());
        } else {
            log.error("No valid back navigation found!");
            NetworkMessageHandlerManager.getServerHandler().openConfiguration(this.getEasyNPCUUID(), ConfigurationType.MAIN);
        }
    }

    private void handleNewActionDataEntry() {
        if (this.isActionEventContext) {
            NetworkMessageHandlerManager.getServerHandler().openActionDataEntryEditor(this.getEasyNPCUUID(), this.actionEventType, this.configurationType, new ActionDataEntry());
        } else if (this.isDialogButtonContext) {
            NetworkMessageHandlerManager.getServerHandler().openActionDataEntryEditor(this.getEasyNPCUUID(), this.editorType, this.getDialogUUID(), this.getDialogButtonUUID(), new ActionDataEntry());
        } else {
            log.error("No valid new action data entry found!");
        }
    }

    private void handleDeleteActionDataEntry(ActionDataEntry actionDataEntry) {
        if (this.field_22787 == null || this.actionDataSet == null || actionDataEntry == null || actionDataEntry.getId().equals(Constants.EMPTY_UUID)) {
            return;
        }
        this.field_22787.method_1507((class_437)new class_410(confirmed -> {
            if (confirmed) {
                this.actionDataSet.remove(actionDataEntry.getId());
                this.updateActionDataSet();
                this.navigateToActionDataEditor();
            } else {
                this.field_22787.method_1507((class_437)this);
            }
        }, (class_2561)TextComponent.getTranslatedConfigText((String)"removeActionDataEntry.deleteQuestion"), (class_2561)TextComponent.getTranslatedConfigText((String)"removeActionDataEntry.deleteWarning", (String)actionDataEntry.actionDataType().name()), (class_2561)TextComponent.getTranslatedConfigText((String)"removeActionDataEntry.deleteButton"), class_5244.field_24335));
    }

    private void updateActionDataSet() {
        if (this.isActionEventContext) {
            NetworkMessageHandlerManager.getServerHandler().actionEventChange(this.getEasyNPCUUID(), this.actionEventType, this.actionDataSet);
        } else if (this.isDialogButtonContext) {
            NetworkMessageHandlerManager.getServerHandler().saveDialogButton(this.getEasyNPCUUID(), this.getDialogUUID(), this.getDialogButtonUUID(), this.getDialogButtonData().withActionDataSet(this.actionDataSet));
        } else {
            log.error("Unable to update Action Data Set {} for {}!", (Object)this.actionDataSet, (Object)this.getEasyNPCUUID());
        }
    }

    private void handleEditActionDataEntry(ActionDataEntry actionDataEntry) {
        log.info("Editing Action Data Entry {}: {}", (Object)actionDataEntry.getId(), (Object)actionDataEntry);
        if (this.isActionEventContext) {
            NetworkMessageHandlerManager.getServerHandler().openActionDataEntryEditor(this.getEasyNPCUUID(), this.actionEventType, this.configurationType, actionDataEntry);
        } else if (this.isDialogButtonContext) {
            NetworkMessageHandlerManager.getServerHandler().openActionDataEntryEditor(this.getEasyNPCUUID(), this.editorType, this.getDialogUUID(), this.getDialogButtonUUID(), actionDataEntry);
        } else {
            log.error("Unable to edit action data entry {}!", (Object)actionDataEntry);
        }
    }

    private void handleMoveUpOrderActionDataEntry(ActionDataEntry actionDataEntry) {
        log.info("Moving up Action Data Entry {}: {}", (Object)actionDataEntry.getId(), (Object)actionDataEntry);
        this.actionDataSet.moveUp(actionDataEntry);
        this.updateActionDataSet();
        this.navigateToActionDataEditor();
    }

    private void handleMoveDownOrderActionDataEntry(ActionDataEntry actionDataEntry) {
        log.info("Moving down Action Data Entry {}: {}", (Object)actionDataEntry.getId(), (Object)actionDataEntry);
        this.actionDataSet.moveDown(actionDataEntry);
        this.updateActionDataSet();
        this.navigateToActionDataEditor();
    }

    @Override
    public void method_25394(class_332 guiGraphics, int x, int y, float partialTicks) {
        super.method_25394(guiGraphics, x, y, partialTicks);
        guiGraphics.method_25294(this.leftPos + 5, this.topPos + 25 + 5, this.leftPos + 314, this.topPos + 200, -1118482);
        if (this.actionDataList != null) {
            this.actionDataList.method_25394(guiGraphics, x, y, partialTicks);
        }
        this.renderHeader(guiGraphics);
        this.renderFooter(guiGraphics);
        if (this.newActionDataEntryButton != null) {
            this.newActionDataEntryButton.method_25394(guiGraphics, x, y, partialTicks);
        }
    }

    private void renderHeader(class_332 guiGraphics) {
        guiGraphics.method_25294(this.leftPos + 5, this.topPos + 25, this.leftPos + 314, this.topPos + 25 + 18, -5592406);
        int headerLeft = this.leftPos + 10;
        int headerTop = this.topPos + 25 + 5;
        Text.drawString((class_332)guiGraphics, (class_327)this.field_22793, (String)"ID", (int)(headerLeft + 0), (int)headerTop, (int)0);
        Text.drawConfigString((class_332)guiGraphics, (class_327)this.field_22793, (String)"type", (int)(headerLeft + 22), (int)headerTop, (int)0);
        Text.drawConfigString((class_332)guiGraphics, (class_327)this.field_22793, (String)"value", (int)(headerLeft + 130), (int)headerTop, (int)0);
        Text.drawString((class_332)guiGraphics, (class_327)this.field_22793, (String)"Action", (int)(headerLeft + 230), (int)headerTop, (int)0);
        int separatorTop = headerTop - 5;
        guiGraphics.method_25294(headerLeft + 22 - 3, separatorTop, headerLeft + 22 - 2, separatorTop + 18, -10066330);
        guiGraphics.method_25294(headerLeft + 130 - 3, separatorTop, headerLeft + 130 - 2, separatorTop + 18, -10066330);
        guiGraphics.method_25294(headerLeft + 230 - 3, separatorTop, headerLeft + 230 - 2, separatorTop + 18, -10066330);
    }

    private void renderFooter(class_332 guiGraphics) {
        guiGraphics.method_25294(this.leftPos + 5, this.topPos + 200, this.leftPos + 314, this.topPos + 200 + 31, -3750202);
    }
}

