/*
 * Decompiled with CFR 0.152.
 */
package de.markusbordihn.easynpc.configui.client.screen.editor.action;

import de.markusbordihn.easynpc.client.screen.components.CancelButton;
import de.markusbordihn.easynpc.client.screen.components.DeleteButton;
import de.markusbordihn.easynpc.client.screen.components.SaveButton;
import de.markusbordihn.easynpc.client.screen.components.SpinButton;
import de.markusbordihn.easynpc.client.screen.components.Text;
import de.markusbordihn.easynpc.client.screen.components.TextButton;
import de.markusbordihn.easynpc.configui.Constants;
import de.markusbordihn.easynpc.configui.client.screen.EditorScreen;
import de.markusbordihn.easynpc.configui.client.screen.components.ActionButton;
import de.markusbordihn.easynpc.configui.client.screen.components.ActionsButton;
import de.markusbordihn.easynpc.configui.client.screen.editor.action.entry.ActionEntryWidget;
import de.markusbordihn.easynpc.configui.client.screen.editor.action.entry.CloseDialogEntry;
import de.markusbordihn.easynpc.configui.client.screen.editor.action.entry.CommandActionEntry;
import de.markusbordihn.easynpc.configui.client.screen.editor.action.entry.InteractBlockEntry;
import de.markusbordihn.easynpc.configui.client.screen.editor.action.entry.OpenDefaultDialogEntry;
import de.markusbordihn.easynpc.configui.client.screen.editor.action.entry.OpenNamedDialogEntry;
import de.markusbordihn.easynpc.configui.client.screen.editor.action.entry.OpenTradingScreenEntry;
import de.markusbordihn.easynpc.configui.client.screen.editor.action.entry.ScoreboardEntry;
import de.markusbordihn.easynpc.configui.data.editor.EditorType;
import de.markusbordihn.easynpc.configui.data.screen.AdditionalScreenData;
import de.markusbordihn.easynpc.configui.menu.editor.EditorMenu;
import de.markusbordihn.easynpc.configui.network.NetworkMessageHandlerManager;
import de.markusbordihn.easynpc.data.action.ActionDataEntry;
import de.markusbordihn.easynpc.data.action.ActionDataSet;
import de.markusbordihn.easynpc.data.action.ActionDataType;
import de.markusbordihn.easynpc.data.action.ActionEventType;
import de.markusbordihn.easynpc.data.configuration.ConfigurationType;
import de.markusbordihn.easynpc.network.components.TextComponent;
import java.util.Arrays;
import java.util.LinkedHashSet;
import java.util.UUID;
import java.util.stream.Collectors;
import net.minecraft.class_1661;
import net.minecraft.class_2561;
import net.minecraft.class_327;
import net.minecraft.class_332;
import net.minecraft.class_364;
import net.minecraft.class_4068;
import net.minecraft.class_410;
import net.minecraft.class_4185;
import net.minecraft.class_437;
import net.minecraft.class_5244;

public class ActionDataEntryEditorContainerScreen<T extends EditorMenu>
extends EditorScreen<T> {
    private final ActionDataEntry actionDataEntry;
    private final ActionDataSet actionDataSet;
    private final ActionEventType actionEventType = ((AdditionalScreenData)this.getAdditionalScreenData()).getActionEventType();
    private final ConfigurationType configurationType = ((AdditionalScreenData)this.getAdditionalScreenData()).getConfigurationType();
    private final EditorType editorType = ((AdditionalScreenData)this.getAdditionalScreenData()).getEditorType();
    private final UUID actionDataEntryId;
    protected class_4185 actionDataTypeButton;
    protected class_4185 cancelButton;
    protected class_4185 deleteButton;
    protected class_4185 homeButton;
    protected class_4185 saveButton;
    protected class_4185 navigationLevelOne;
    protected class_4185 navigationLevelTwo;
    protected int contentTop;
    private ActionEntryWidget actionEntryWidget;
    private ActionDataType actionDataType;

    public ActionDataEntryEditorContainerScreen(T menu, class_1661 inventory, class_2561 component) {
        super(menu, inventory, component);
        this.actionDataSet = this.getActionDataSet();
        this.actionDataEntryId = this.getActionDataEntryUUID();
        this.actionDataEntry = this.getActionDataEntry();
        this.actionDataType = this.actionDataEntry.actionDataType() != ActionDataType.NONE ? this.actionDataEntry.actionDataType() : ActionDataType.COMMAND;
    }

    private ActionDataSet getActionDataSet() {
        if (this.actionEventType != null && this.actionEventType != ActionEventType.NONE) {
            return ((AdditionalScreenData)this.getAdditionalScreenData()).getActionEventSet().getActionEvents(this.actionEventType);
        }
        if (this.editorType != null && this.editorType == EditorType.DIALOG_BUTTON) {
            return this.getDialogButtonData().actionDataSet();
        }
        log.error("No valid action data set found for {}!", (Object)this.getEasyNPCUUID());
        return new ActionDataSet();
    }

    private ActionDataEntry getActionDataEntry() {
        if (this.actionDataSet != null && this.actionDataEntryId != null && this.actionDataSet.contains(this.actionDataEntryId)) {
            return this.actionDataSet.getEntryOrDefault(this.actionDataEntryId);
        }
        if (this.actionDataSet != null && this.actionDataEntryId != null) {
            log.error("No valid action data entry found for {} in {}!", (Object)this.actionDataEntryId, (Object)this.actionDataSet);
        }
        return new ActionDataEntry();
    }

    private LinkedHashSet<ActionDataType> getAvailableActionDataTypes() {
        boolean requiresServerPlayer = this.requiresServerPlayer(this.actionEventType);
        return Arrays.stream(ActionDataType.values()).filter(type -> type != ActionDataType.NONE).filter(type -> {
            if (!requiresServerPlayer) {
                return !this.actionDataTypeRequiresServerPlayer((ActionDataType)type);
            }
            return true;
        }).sorted().collect(Collectors.toCollection(LinkedHashSet::new));
    }

    private boolean requiresServerPlayer(ActionEventType actionEventType) {
        return actionEventType != ActionEventType.ON_KILL;
    }

    public boolean currentEventRequiresServerPlayer() {
        return this.requiresServerPlayer(this.actionEventType);
    }

    private boolean actionDataTypeRequiresServerPlayer(ActionDataType actionDataType) {
        return actionDataType == ActionDataType.CLOSE_DIALOG || actionDataType == ActionDataType.OPEN_DEFAULT_DIALOG || actionDataType == ActionDataType.OPEN_NAMED_DIALOG || actionDataType == ActionDataType.OPEN_TRADING_SCREEN || actionDataType == ActionDataType.SCOREBOARD;
    }

    private void navigateToActionDataEditor() {
        if (this.actionEventType != null && this.actionEventType != ActionEventType.NONE) {
            NetworkMessageHandlerManager.getServerHandler().openActionDataEditor(this.getEasyNPCUUID(), this.actionEventType, this.configurationType);
        } else if (this.editorType != null && this.editorType == EditorType.DIALOG_BUTTON) {
            NetworkMessageHandlerManager.getServerHandler().openActionDataEditor(this.getEasyNPCUUID(), this.editorType, this.getDialogUUID(), this.getDialogButtonUUID());
        } else {
            log.error("No valid action event type found for {}!", (Object)this.getEasyNPCUUID());
        }
    }

    private void saveActionDataEntry() {
        if (this.actionDataSet == null) {
            return;
        }
        ActionDataEntry newActionDataEntry = this.actionEntryWidget != null ? this.actionEntryWidget.getActionDataEntry() : new ActionDataEntry();
        this.actionDataSet.put(this.actionDataEntryId, newActionDataEntry);
        if (this.actionEventType != null && this.actionEventType != ActionEventType.NONE) {
            NetworkMessageHandlerManager.getServerHandler().actionEventChange(this.getEasyNPCUUID(), this.actionEventType, this.actionDataSet);
        } else if (this.editorType != null && this.editorType == EditorType.DIALOG_BUTTON) {
            NetworkMessageHandlerManager.getServerHandler().saveDialogButton(this.getEasyNPCUUID(), this.getDialogUUID(), this.getDialogButtonUUID(), this.getDialogButtonData().withActionDataSet(this.actionDataSet));
        } else {
            log.error("Unable to save Action Data Set {} for {}!", (Object)this.actionDataSet, (Object)this.getEasyNPCUUID());
        }
    }

    private void deleteActionDataEntry() {
        if (this.field_22787 == null || this.actionDataSet == null || this.actionDataEntryId == null || this.actionDataEntryId == Constants.EMPTY_UUID) {
            return;
        }
        this.field_22787.method_1507((class_437)new class_410(confirmed -> {
            if (confirmed) {
                this.actionDataSet.remove(this.actionDataEntryId);
                if (this.actionEventType != null && this.actionEventType != ActionEventType.NONE) {
                    NetworkMessageHandlerManager.getServerHandler().actionEventChange(this.getEasyNPCUUID(), this.actionEventType, this.actionDataSet);
                } else if (this.editorType != null && this.editorType == EditorType.DIALOG_BUTTON) {
                    NetworkMessageHandlerManager.getServerHandler().saveDialogButton(this.getEasyNPCUUID(), this.getDialogUUID(), this.getDialogButtonUUID(), this.getDialogButtonData().withActionDataSet(this.actionDataSet));
                } else {
                    log.error("Unable to delete Action Data Set {} for {}!", (Object)this.actionDataSet, (Object)this.getEasyNPCUUID());
                }
                this.navigateToActionDataEditor();
            } else {
                this.field_22787.method_1507((class_437)this);
            }
        }, (class_2561)TextComponent.getTranslatedConfigText((String)"removeActionDataEntry.deleteQuestion"), (class_2561)TextComponent.getTranslatedConfigText((String)"removeActionDataEntry.deleteWarning", (String)this.actionDataEntry.actionDataType().toString()), (class_2561)TextComponent.getTranslatedConfigText((String)"removeActionDataEntry.deleteButton"), class_5244.field_24335));
    }

    protected void changeActionDataType(SpinButton<?> spinButton) {
        log.info("Change action data type to {}", spinButton.get());
        this.actionDataType = (ActionDataType)spinButton.get();
        this.method_37067();
        this.method_25426();
    }

    public void method_25426() {
        super.method_25426();
        this.contentTop = this.topPos + 20;
        this.homeButton = (class_4185)this.method_37063((class_364)new TextButton(this.leftPos + 3, this.topPos + 3, 10, 16, "<", onPress -> this.navigateToActionDataEditor()));
        this.navigationLevelOne = (class_4185)this.method_37063((class_364)new ActionsButton(this.homeButton.method_46426() + this.homeButton.method_25368(), this.topPos + 3, 140, "Actions", onPress -> this.navigateToActionDataEditor()));
        int actionDataEntryPosition = this.actionDataSet.getPosition(this.actionDataEntry);
        this.navigationLevelTwo = (class_4185)this.method_37063((class_364)new ActionButton(this.navigationLevelOne.method_46426() + this.navigationLevelOne.method_25368(), this.topPos + 3, 140, (String)(actionDataEntryPosition == -1 ? "Action: New" : "Action: " + this.actionDataSet.getPosition(this.actionDataEntry)), onPress -> this.navigateToActionDataEditor()));
        this.navigationLevelTwo.field_22763 = false;
        this.actionDataTypeButton = (class_4185)this.method_37063((class_364)new SpinButton(this.leftPos + 133, this.contentTop + 5, 160, 16, this.getAvailableActionDataTypes(), (Object)this.actionDataType, this::changeActionDataType));
        this.saveButton = (class_4185)this.method_37063((class_364)new SaveButton(this.leftPos + 25, this.bottomPos - 35, 85, "save", onPress -> {
            this.saveActionDataEntry();
            this.navigateToActionDataEditor();
        }));
        this.deleteButton = (class_4185)this.method_37063((class_364)new DeleteButton(this.saveButton.method_46426() + this.saveButton.method_25368() + 10, this.bottomPos - 35, 85, onPress -> this.deleteActionDataEntry()));
        this.cancelButton = (class_4185)this.method_37063((class_364)new CancelButton(this.deleteButton.method_46426() + this.deleteButton.method_25368() + 10, this.bottomPos - 35, 85, "cancel", onPress -> this.navigateToActionDataEditor()));
        switch (this.actionDataType) {
            case CLOSE_DIALOG: {
                this.actionEntryWidget = new CloseDialogEntry(this.actionDataEntry, this.actionDataSet, this);
                break;
            }
            case COMMAND: {
                this.actionEntryWidget = new CommandActionEntry(this.actionDataEntry, this.actionDataSet, this);
                break;
            }
            case INTERACT_BLOCK: {
                this.actionEntryWidget = new InteractBlockEntry(this.actionDataEntry, this.actionDataSet, this);
                break;
            }
            case OPEN_DEFAULT_DIALOG: {
                this.actionEntryWidget = new OpenDefaultDialogEntry(this.actionDataEntry, this.actionDataSet, this);
                break;
            }
            case OPEN_NAMED_DIALOG: {
                this.actionEntryWidget = new OpenNamedDialogEntry(this.actionDataEntry, this.actionDataSet, this);
                break;
            }
            case OPEN_TRADING_SCREEN: {
                this.actionEntryWidget = new OpenTradingScreenEntry(this.actionDataEntry, this.actionDataSet, this);
                break;
            }
            case SCOREBOARD: {
                this.actionEntryWidget = new ScoreboardEntry(this.actionDataEntry, this.actionDataSet, this);
                break;
            }
            default: {
                this.actionEntryWidget = null;
                log.error("Unsupported action data type {}!", (Object)this.actionDataType);
            }
        }
        int editorLeft = this.leftPos + 10;
        int editorTop = this.contentTop + 25;
        if (this.actionEntryWidget != null) {
            this.actionEntryWidget.init(editorLeft, editorTop);
        }
    }

    public <W extends class_364 & class_4068> W addActionEntryWidget(W widget) {
        return (W)this.method_37063(widget);
    }

    public class_327 getFont() {
        return this.field_22793;
    }

    @Override
    public void method_25394(class_332 guiGraphics, int x, int y, float partialTicks) {
        super.method_25394(guiGraphics, x, y, partialTicks);
        int editorLeft = this.leftPos + 10;
        int editorTop = this.contentTop + 25;
        Text.drawString((class_332)guiGraphics, (class_327)this.field_22793, (String)"Action Data Type:", (int)(this.leftPos + 10), (int)(this.topPos + 30), (int)0);
        if (this.actionEntryWidget != null) {
            this.actionEntryWidget.render(guiGraphics, editorLeft, editorTop);
        }
    }

    public void updateTick() {
        super.updateTick();
        if (this.saveButton != null) {
            boolean bl = this.saveButton.field_22763 = this.actionDataType != this.actionDataEntry.actionDataType() && this.actionDataEntry.actionDataType() != ActionDataType.NONE || this.actionEntryWidget != null && this.actionEntryWidget.hasChanged();
        }
        if (this.deleteButton != null) {
            this.deleteButton.field_22763 = this.actionDataSet != null && this.actionDataEntry != null && this.actionDataEntry.isValidAndNotEmpty() && this.actionDataEntryId != null && this.actionDataEntryId != Constants.EMPTY_UUID;
        }
    }
}

