/*
 * Decompiled with CFR 0.152.
 */
package de.markusbordihn.easynpc.configui.client.screen.editor.action.entry;

import de.markusbordihn.easynpc.client.screen.components.Checkbox;
import de.markusbordihn.easynpc.client.screen.components.Text;
import de.markusbordihn.easynpc.client.screen.components.TextField;
import de.markusbordihn.easynpc.configui.client.screen.editor.action.ActionDataEntryEditorContainerScreen;
import de.markusbordihn.easynpc.configui.client.screen.editor.action.entry.ActionEntryWidget;
import de.markusbordihn.easynpc.configui.client.screen.editor.action.entry.DialogCommandParser;
import de.markusbordihn.easynpc.data.action.ActionDataEntry;
import de.markusbordihn.easynpc.data.action.ActionDataSet;
import de.markusbordihn.easynpc.data.action.ActionDataType;
import net.minecraft.class_327;
import net.minecraft.class_332;

public class CommandActionEntry
extends ActionEntryWidget {
    private TextField actionValueTextField;
    private Checkbox debugCheckbox;
    private Checkbox executeAsUserCheckbox;
    private boolean showDialogCommandHint;
    private boolean showExecuteAsUserWarning;

    public CommandActionEntry(ActionDataEntry actionDataEntry, ActionDataSet actionDataSet, ActionDataEntryEditorContainerScreen<?> screen) {
        super(actionDataEntry, actionDataSet, screen);
        this.showExecuteAsUserWarning = !screen.currentEventRequiresServerPlayer();
    }

    @Override
    public void init(int editorLeft, int editorTop) {
        boolean executeAsUserValue;
        boolean hasActionData = this.hasActionData(ActionDataType.COMMAND);
        this.actionValueTextField = this.screen.addActionEntryWidget(new TextField(this.font, editorLeft, editorTop + 20, 275, 16));
        this.actionValueTextField.method_1880(512);
        this.actionValueTextField.method_1852(hasActionData ? this.actionDataEntry.command() : "");
        this.actionValueTextField.method_1863(this::checkForDialogCommand);
        boolean bl = executeAsUserValue = hasActionData && this.actionDataEntry.executeAsUser();
        if (this.showExecuteAsUserWarning) {
            executeAsUserValue = false;
        }
        this.executeAsUserCheckbox = this.screen.addActionEntryWidget(new Checkbox(editorLeft, editorTop + 40, "execute_as_player", executeAsUserValue));
        if (this.showExecuteAsUserWarning) {
            this.executeAsUserCheckbox.field_22763 = false;
        }
        this.debugCheckbox = this.screen.addActionEntryWidget(new Checkbox(editorLeft + 200, editorTop + 40, "debug", hasActionData && this.actionDataEntry.enableDebug()));
    }

    private void checkForDialogCommand(String command) {
        this.showDialogCommandHint = DialogCommandParser.isDialogOpenCommand(command);
    }

    @Override
    public void render(class_332 guiGraphics, int editorLeft, int editorTop) {
        Text.drawConfigString((class_332)guiGraphics, (class_327)this.font, (String)"action.command", (int)(editorLeft + 2), (int)(editorTop + 5), (int)0x404040);
        if (this.showDialogCommandHint) {
            Text.drawString((class_332)guiGraphics, (class_327)this.font, (String)"Hint: Use 'Open Named Dialog' action type instead", (int)(editorLeft + 2), (int)(editorTop + 60), (int)0xFFFF55);
        }
        if (this.showExecuteAsUserWarning) {
            Text.drawConfigString((class_332)guiGraphics, (class_327)this.font, (String)"action.executeAsUser.disabled.line1", (int)(editorLeft + 2), (int)(editorTop + 75), (int)43520);
            Text.drawConfigString((class_332)guiGraphics, (class_327)this.font, (String)"action.executeAsUser.disabled.line2", (int)(editorLeft + 2), (int)(editorTop + 85), (int)43520);
        }
    }

    @Override
    public ActionDataEntry getActionDataEntry() {
        String command = this.actionValueTextField.method_1882();
        ActionDataEntry parsedDialog = DialogCommandParser.parseDialogCommand(command);
        if (parsedDialog != null) {
            return parsedDialog;
        }
        return new ActionDataEntry(ActionDataType.COMMAND, command, this.executeAsUserCheckbox.selected(), this.debugCheckbox.selected());
    }

    @Override
    public boolean hasChanged() {
        return this.actionValueTextField != null && !this.actionValueTextField.method_1882().equals(this.actionDataEntry.command()) || this.executeAsUserCheckbox != null && this.executeAsUserCheckbox.selected() != this.actionDataEntry.executeAsUser() || this.debugCheckbox != null && this.debugCheckbox.selected() != this.actionDataEntry.enableDebug();
    }
}

