/*
 * Decompiled with CFR 0.152.
 */
package de.markusbordihn.easynpc.configui.client.screen.editor.action.entry;

import de.markusbordihn.easynpc.data.action.ActionDataEntry;
import de.markusbordihn.easynpc.data.action.ActionDataType;
import java.util.UUID;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

public class DialogCommandParser {
    private static final Pattern DIALOG_OPEN_PATTERN = Pattern.compile("^/?easy_npc\\s+dialog\\s+open\\s+([0-9a-fA-F]{8}-[0-9a-fA-F]{4}-[0-9a-fA-F]{4}-[0-9a-fA-F]{4}-[0-9a-fA-F]{12})\\s+\\S+\\s+(\\S+)$");

    private DialogCommandParser() {
    }

    public static ActionDataEntry parseDialogCommand(String command) {
        if (command == null || command.isEmpty()) {
            return null;
        }
        Matcher matcher = DIALOG_OPEN_PATTERN.matcher(command.trim());
        if (matcher.matches()) {
            try {
                UUID targetUUID = UUID.fromString(matcher.group(1));
                String dialogName = matcher.group(2);
                return new ActionDataEntry(ActionDataType.OPEN_NAMED_DIALOG, targetUUID, dialogName);
            }
            catch (IllegalArgumentException e) {
                return null;
            }
        }
        return null;
    }

    public static boolean isDialogOpenCommand(String command) {
        return command != null && DIALOG_OPEN_PATTERN.matcher(command.trim()).matches();
    }
}

