/*
 * Decompiled with CFR 0.152.
 */
package de.markusbordihn.easynpc.configui.client.screen.editor.action.entry;

import de.markusbordihn.easynpc.client.screen.components.Checkbox;
import de.markusbordihn.easynpc.client.screen.components.SpinButton;
import de.markusbordihn.easynpc.client.screen.components.Text;
import de.markusbordihn.easynpc.client.screen.components.TextField;
import de.markusbordihn.easynpc.configui.client.screen.editor.action.ActionDataEntryEditorContainerScreen;
import de.markusbordihn.easynpc.configui.client.screen.editor.action.entry.ActionEntryWidget;
import de.markusbordihn.easynpc.data.action.ActionDataEntry;
import de.markusbordihn.easynpc.data.action.ActionDataSet;
import de.markusbordihn.easynpc.data.action.ActionDataType;
import de.markusbordihn.easynpc.data.scoreboard.ScoreboardOperation;
import de.markusbordihn.easynpc.network.components.TextComponent;
import java.util.LinkedHashSet;
import net.minecraft.class_327;
import net.minecraft.class_332;

public class ScoreboardEntry
extends ActionEntryWidget {
    private TextField scoreboardNameTextField;
    private TextField scoreboardValueTextField;
    private Checkbox debugCheckbox;
    private ScoreboardOperation currentOperation;

    public ScoreboardEntry(ActionDataEntry actionDataEntry, ActionDataSet actionDataSet, ActionDataEntryEditorContainerScreen<?> screen) {
        super(actionDataEntry, actionDataSet, screen);
        this.currentOperation = this.parseOperation(actionDataEntry);
    }

    private ScoreboardOperation parseOperation(ActionDataEntry actionDataEntry) {
        if (!this.hasActionData(ActionDataType.SCOREBOARD) || actionDataEntry.command() == null) {
            return ScoreboardOperation.INCREASE;
        }
        return ScoreboardOperation.fromCommand((String)actionDataEntry.command());
    }

    private String[] parseCommandData(ActionDataEntry actionDataEntry) {
        if (!this.hasActionData(ActionDataType.SCOREBOARD) || actionDataEntry.command() == null) {
            return new String[]{"", "1"};
        }
        String command = actionDataEntry.command();
        String[] parts = command.split(":", 3);
        if (parts.length < 2) {
            return new String[]{"", "1"};
        }
        return new String[]{parts[1], parts.length > 2 ? parts[2] : "1"};
    }

    @Override
    public void init(int editorLeft, int editorTop) {
        boolean hasActionData = this.hasActionData(ActionDataType.SCOREBOARD);
        String[] commandData = this.parseCommandData(this.actionDataEntry);
        String scoreboardName = commandData[0];
        String scoreboardValue = commandData[1];
        LinkedHashSet<TranslatableScoreboardOperation> operationSet = new LinkedHashSet<TranslatableScoreboardOperation>();
        for (ScoreboardOperation op : ScoreboardOperation.values()) {
            operationSet.add(new TranslatableScoreboardOperation(op));
        }
        this.screen.addActionEntryWidget(new SpinButton(editorLeft, editorTop + 20, 120, 16, operationSet, (Object)new TranslatableScoreboardOperation(this.currentOperation), spinButton -> {
            Object value = spinButton.get();
            if (value instanceof TranslatableScoreboardOperation) {
                TranslatableScoreboardOperation translatable = (TranslatableScoreboardOperation)value;
                this.currentOperation = translatable.getOperation();
                if (this.scoreboardValueTextField != null) {
                    this.scoreboardValueTextField.method_1862(this.currentOperation == ScoreboardOperation.SET);
                }
            }
        }));
        this.scoreboardNameTextField = this.screen.addActionEntryWidget(new TextField(this.font, editorLeft + 125, editorTop + 20, 150, 16));
        this.scoreboardNameTextField.method_1880(32);
        this.scoreboardNameTextField.method_1852(scoreboardName);
        this.scoreboardValueTextField = this.screen.addActionEntryWidget(new TextField(this.font, editorLeft + 125, editorTop + 45, 150, 16));
        this.scoreboardValueTextField.method_1880(10);
        this.scoreboardValueTextField.method_1852(scoreboardValue);
        this.scoreboardValueTextField.method_1862(this.currentOperation == ScoreboardOperation.SET);
        this.debugCheckbox = this.screen.addActionEntryWidget(new Checkbox(editorLeft, editorTop + 70, "debug", hasActionData && this.actionDataEntry.enableDebug()));
    }

    @Override
    public void render(class_332 guiGraphics, int editorLeft, int editorTop) {
        Text.drawConfigString((class_332)guiGraphics, (class_327)this.font, (String)"action.name", (int)(editorLeft + 125), (int)(editorTop + 5), (int)0x404040);
        if (this.currentOperation == ScoreboardOperation.SET) {
            Text.drawConfigString((class_332)guiGraphics, (class_327)this.font, (String)"action.value", (int)(editorLeft + 85), (int)(editorTop + 49), (int)0x404040);
        }
    }

    @Override
    public ActionDataEntry getActionDataEntry() {
        String scoreboardName = this.scoreboardNameTextField.method_1882().trim();
        String value = this.currentOperation == ScoreboardOperation.SET ? this.scoreboardValueTextField.method_1882().trim() : "1";
        String command = this.currentOperation.getCommandName() + ":" + scoreboardName + ":" + value;
        return new ActionDataEntry(ActionDataType.SCOREBOARD, command, false, this.debugCheckbox.selected());
    }

    @Override
    public boolean hasChanged() {
        ActionDataEntry currentEntry = this.getActionDataEntry();
        return !this.actionDataEntry.actionDataType().equals((Object)ActionDataType.SCOREBOARD) || !this.actionDataEntry.command().equals(currentEntry.command()) || this.actionDataEntry.enableDebug() != currentEntry.enableDebug();
    }

    private static class TranslatableScoreboardOperation {
        private final ScoreboardOperation operation;

        TranslatableScoreboardOperation(ScoreboardOperation operation) {
            this.operation = operation;
        }

        ScoreboardOperation getOperation() {
            return this.operation;
        }

        public String toString() {
            return TextComponent.getTranslatedConfigText((String)this.operation.getTranslationKey()).getString();
        }

        public boolean equals(Object obj) {
            if (this == obj) {
                return true;
            }
            if (!(obj instanceof TranslatableScoreboardOperation)) {
                return false;
            }
            TranslatableScoreboardOperation other = (TranslatableScoreboardOperation)obj;
            return this.operation == other.operation;
        }

        public int hashCode() {
            return this.operation.hashCode();
        }
    }
}

