/*
 * Decompiled with CFR 0.152.
 */
package de.markusbordihn.easynpc.configui.client.screen.editor.condition;

import de.markusbordihn.easynpc.client.screen.components.CancelButton;
import de.markusbordihn.easynpc.client.screen.components.DeleteButton;
import de.markusbordihn.easynpc.client.screen.components.SaveButton;
import de.markusbordihn.easynpc.client.screen.components.SpinButton;
import de.markusbordihn.easynpc.client.screen.components.Text;
import de.markusbordihn.easynpc.client.screen.components.TextButton;
import de.markusbordihn.easynpc.configui.Constants;
import de.markusbordihn.easynpc.configui.client.screen.EditorScreen;
import de.markusbordihn.easynpc.configui.client.screen.components.DialogButton;
import de.markusbordihn.easynpc.configui.client.screen.editor.condition.entry.ConditionEntryWidget;
import de.markusbordihn.easynpc.configui.client.screen.editor.condition.entry.ExecutionLimitConditionEntry;
import de.markusbordihn.easynpc.configui.client.screen.editor.condition.entry.ScoreboardConditionEntry;
import de.markusbordihn.easynpc.configui.menu.editor.EditorMenu;
import de.markusbordihn.easynpc.configui.network.NetworkMessageHandlerManager;
import de.markusbordihn.easynpc.data.condition.ConditionDataEntry;
import de.markusbordihn.easynpc.data.condition.ConditionDataSet;
import de.markusbordihn.easynpc.data.condition.ConditionType;
import de.markusbordihn.easynpc.data.dialog.DialogDataEntry;
import de.markusbordihn.easynpc.network.components.TextComponent;
import java.util.Arrays;
import java.util.LinkedHashSet;
import java.util.Set;
import java.util.UUID;
import java.util.stream.Collectors;
import net.minecraft.class_1661;
import net.minecraft.class_2561;
import net.minecraft.class_327;
import net.minecraft.class_332;
import net.minecraft.class_364;
import net.minecraft.class_4068;
import net.minecraft.class_410;
import net.minecraft.class_4185;
import net.minecraft.class_437;
import net.minecraft.class_5244;

public class ConditionDataEntryEditorContainerScreen<T extends EditorMenu>
extends EditorScreen<T> {
    private final ConditionDataEntry conditionDataEntry;
    private final ConditionDataSet conditionDataSet = this.getConditionDataSet();
    private final UUID conditionDataEntryId = this.getConditionDataEntryUUID();
    protected class_4185 homeButton;
    protected class_4185 dialogButton;
    protected class_4185 conditionsButton;
    protected class_4185 saveButton;
    protected class_4185 cancelButton;
    protected class_4185 deleteButton;
    protected class_4185 conditionTypeButton;
    protected int contentTop;
    private ConditionEntryWidget conditionEntryWidget;
    private ConditionType conditionType;

    public ConditionDataEntryEditorContainerScreen(T menu, class_1661 inventory, class_2561 component) {
        super(menu, inventory, component);
        this.conditionDataEntry = this.getConditionDataEntry();
        this.conditionType = this.conditionDataEntry.conditionType() != ConditionType.NONE ? this.conditionDataEntry.conditionType() : ConditionType.SCOREBOARD;
    }

    private ConditionDataSet getConditionDataSet() {
        DialogDataEntry dialogData = this.getDialogData();
        if (dialogData != null && dialogData.getConditions() != null) {
            return new ConditionDataSet(dialogData.getConditions());
        }
        log.error("No valid condition data set found!");
        return new ConditionDataSet();
    }

    private ConditionDataEntry getConditionDataEntry() {
        if (this.conditionDataSet != null && this.conditionDataEntryId != null && this.conditionDataSet.hasCondition(this.conditionDataEntryId)) {
            return this.conditionDataSet.getCondition(this.conditionDataEntryId);
        }
        return new ConditionDataEntry(ConditionType.SCOREBOARD);
    }

    private void navigateToConditionDataEditor() {
        NetworkMessageHandlerManager.getServerHandler().openConditionDataEditor(this.getEasyNPCUUID(), this.getDialogUUID());
    }

    protected void changeConditionType(SpinButton<?> spinButton) {
        log.info("Change condition type to {}", spinButton.get());
        this.conditionType = (ConditionType)spinButton.get();
        this.method_37067();
        this.method_25426();
    }

    private void saveConditionDataEntry() {
        if (this.conditionDataSet == null) {
            return;
        }
        ConditionDataEntry newConditionDataEntry = this.conditionEntryWidget != null ? this.conditionEntryWidget.getConditionDataEntry() : new ConditionDataEntry(this.conditionType);
        this.conditionDataSet.put(this.conditionDataEntryId, newConditionDataEntry);
        DialogDataEntry dialogData = this.getDialogData();
        dialogData.setConditions(this.conditionDataSet.getConditions());
        NetworkMessageHandlerManager.getServerHandler().saveDialog(this.getEasyNPCUUID(), this.getDialogUUID(), dialogData);
    }

    private void deleteConditionDataEntry() {
        if (this.field_22787 == null || this.conditionDataSet == null || this.conditionDataEntryId == null || this.conditionDataEntryId == Constants.EMPTY_UUID) {
            return;
        }
        this.field_22787.method_1507((class_437)new class_410(confirmed -> {
            if (confirmed) {
                this.conditionDataSet.remove(this.conditionDataEntryId);
                DialogDataEntry dialogData = this.getDialogData();
                dialogData.setConditions(this.conditionDataSet.getConditions());
                NetworkMessageHandlerManager.getServerHandler().saveDialog(this.getEasyNPCUUID(), this.getDialogUUID(), dialogData);
                this.navigateToConditionDataEditor();
            } else {
                this.field_22787.method_1507((class_437)this);
            }
        }, (class_2561)TextComponent.getTranslatedConfigText((String)"removeConditionDataEntry.deleteQuestion"), (class_2561)TextComponent.getTranslatedConfigText((String)"removeConditionDataEntry.deleteWarning", (String)"SCOREBOARD"), (class_2561)TextComponent.getTranslatedConfigText((String)"removeConditionDataEntry.deleteButton"), class_5244.field_24335));
    }

    public void method_25426() {
        super.method_25426();
        this.contentTop = this.topPos + 20;
        this.homeButton = (class_4185)this.method_37063((class_364)new TextButton(this.leftPos + 7, this.topPos + 7, 10, 16, "<", onPress -> this.navigateToConditionDataEditor()));
        this.dialogButton = (class_4185)this.method_37063((class_364)new DialogButton(this.homeButton.method_46426() + this.homeButton.method_25368(), this.topPos + 7, 140, this.getDialogData().getName(21), onPress -> NetworkMessageHandlerManager.getServerHandler().openDialogEditor(this.getEasyNPCUUID(), this.getDialogUUID())));
        this.conditionsButton = (class_4185)this.method_37063((class_364)new DialogButton(this.dialogButton.method_46426() + this.dialogButton.method_25368(), this.topPos + 7, 140, "Conditions", onPress -> this.navigateToConditionDataEditor()));
        this.conditionTypeButton = (class_4185)this.method_37063((class_364)new SpinButton(this.leftPos + 133, this.contentTop + 5, 160, 16, (Set)Arrays.stream(ConditionType.values()).filter(type -> type != ConditionType.NONE).sorted().collect(Collectors.toCollection(LinkedHashSet::new)), (Object)this.conditionType, this::changeConditionType));
        this.saveButton = (class_4185)this.method_37063((class_364)new SaveButton(this.leftPos + 25, this.bottomPos - 35, 85, "save", onPress -> {
            this.saveConditionDataEntry();
            this.navigateToConditionDataEditor();
        }));
        this.deleteButton = (class_4185)this.method_37063((class_364)new DeleteButton(this.saveButton.method_46426() + this.saveButton.method_25368() + 10, this.bottomPos - 35, 85, onPress -> this.deleteConditionDataEntry()));
        this.cancelButton = (class_4185)this.method_37063((class_364)new CancelButton(this.deleteButton.method_46426() + this.deleteButton.method_25368() + 10, this.bottomPos - 35, 85, "cancel", onPress -> this.navigateToConditionDataEditor()));
        switch (this.conditionType) {
            case SCOREBOARD: {
                this.conditionEntryWidget = new ScoreboardConditionEntry(this.conditionDataEntry, this.conditionDataSet, this);
                break;
            }
            case EXECUTION_LIMIT: {
                this.conditionEntryWidget = new ExecutionLimitConditionEntry(this.conditionDataEntry, this.conditionDataSet, this);
                break;
            }
            default: {
                this.conditionEntryWidget = null;
                log.error("Unsupported condition type {}!", (Object)this.conditionType);
            }
        }
        if (this.conditionEntryWidget != null) {
            this.conditionEntryWidget.init(this.leftPos + 10, this.contentTop + 50);
        }
    }

    public <W extends class_364 & class_4068> W addConditionEntryWidget(W widget) {
        return (W)this.method_37063(widget);
    }

    public class_327 getFont() {
        return this.field_22793;
    }

    @Override
    public void method_25394(class_332 guiGraphics, int x, int y, float partialTicks) {
        super.method_25394(guiGraphics, x, y, partialTicks);
        Text.drawConfigString((class_332)guiGraphics, (class_327)this.field_22793, (String)"condition.type", (int)(this.leftPos + 10), (int)(this.topPos + 30), (int)0);
        Text.drawConfigString((class_332)guiGraphics, (class_327)this.field_22793, (String)"condition.help_text", (int)(this.leftPos + 10), (int)(this.topPos + 50), (int)0xAAAAAA);
        if (this.conditionEntryWidget != null) {
            this.conditionEntryWidget.render(guiGraphics, this.leftPos + 10, this.contentTop + 50);
        }
    }
}

