/*
 * Decompiled with CFR 0.152.
 */
package de.markusbordihn.easynpc.configui.client.screen.editor.condition;

import de.markusbordihn.easynpc.client.screen.components.DeleteButton;
import de.markusbordihn.easynpc.client.screen.components.DrawBorder;
import de.markusbordihn.easynpc.client.screen.components.EditButton;
import de.markusbordihn.easynpc.client.screen.components.Text;
import de.markusbordihn.easynpc.data.condition.ConditionDataEntry;
import de.markusbordihn.easynpc.data.condition.ConditionType;
import de.markusbordihn.easynpc.network.components.TextComponent;
import de.markusbordihn.easynpc.utils.TextUtils;
import net.minecraft.class_2561;
import net.minecraft.class_310;
import net.minecraft.class_327;
import net.minecraft.class_332;
import net.minecraft.class_4280;

public class ConditionDataListEntry
extends class_4280.class_4281<ConditionDataListEntry> {
    public static final int ID_LEFT_POS = 0;
    public static final int TYPE_LEFT_POS = 22;
    public static final int VALUE_LEFT_POS = 110;
    public static final int OPTIONS_LEFT_POS = 250;
    private static final int ENTRY_HEIGHT = 21;
    private static final int FIELD_LEFT_OFFSET = 5;
    private static final int FIELD_TOP_OFFSET = 5;
    private static final int COLUMN_SEPARATOR_OFFSET = 3;
    private static final int BUTTON_SPACING = 2;
    private static final int BUTTON_SIZE = 18;
    private static final int VALUE_MAX_LENGTH = 21;
    private static final int LIST_WIDTH = 309;
    private static final int COLOR_SEPARATOR_LINE = -5592406;
    private static final int COLOR_COLUMN_SEPARATOR = -10066330;
    private final class_327 font;
    private final int leftPos;
    private final int topPos;
    private final ConditionDataEntry conditionDataEntry;
    private final ConditionType conditionType;
    private final EditButton editButton;
    private final DeleteButton deleteButton;

    public ConditionDataListEntry(class_310 minecraft, ConditionDataEntry conditionDataEntry, int leftPos, int topPos, OnEdit onEdit, OnRemove onRemove) {
        this.font = minecraft.field_1772;
        this.leftPos = leftPos;
        this.topPos = topPos;
        this.conditionDataEntry = conditionDataEntry;
        this.conditionType = conditionDataEntry != null ? conditionDataEntry.conditionType() : ConditionType.NONE;
        this.editButton = new EditButton(this.leftPos + 250 + 4, this.topPos, 18, 18, onPress -> {
            if (onEdit != null) {
                onEdit.edit(conditionDataEntry);
            }
        });
        this.deleteButton = new DeleteButton(this.editButton.method_46426() + this.editButton.method_25368() + 2, this.topPos, onPress -> {
            if (onRemove != null) {
                onRemove.remove(conditionDataEntry);
            }
        });
    }

    public class_2561 method_37006() {
        return TextComponent.getText((String)(this.conditionType.name() + ":" + this.conditionDataEntry.name()));
    }

    public boolean method_25402(double mouseX, double mouseY, int button) {
        super.method_25402(mouseX, mouseY, button);
        this.editButton.method_25402(mouseX, mouseY, button);
        this.deleteButton.method_25402(mouseX, mouseY, button);
        return button == 0;
    }

    public void method_25343(class_332 guiGraphics, int entryId, int top, int left, int entryWidth, int entryHeight, int mouseX, int mouseY, boolean isSelected, float partialTicks) {
        guiGraphics.method_25294(this.leftPos, top + entryHeight + 2, this.leftPos + 309, top + entryHeight + 3, -5592406);
        int fieldsLeft = this.leftPos + 5;
        int fieldTop = top + 5;
        Text.drawString((class_332)guiGraphics, (class_327)this.font, (String)String.valueOf(entryId), (int)(fieldsLeft + 0 + 2), (int)fieldTop, (int)0);
        Text.drawConfigString((class_332)guiGraphics, (class_327)this.font, (String)("conditionType." + this.conditionType.name().toLowerCase()), (int)(fieldsLeft + 22 + 2), (int)fieldTop, (int)0);
        this.renderValuePreview(guiGraphics, fieldsLeft, fieldTop);
        this.editButton.method_25394(guiGraphics, mouseX, mouseY, partialTicks);
        this.editButton.method_46419(top);
        this.deleteButton.method_25394(guiGraphics, mouseX, mouseY, partialTicks);
        this.deleteButton.method_46419(top);
        this.renderSeparatorLines(guiGraphics, top);
    }

    private void renderValuePreview(class_332 guiGraphics, int fieldsLeft, int fieldTop) {
        String valuePreview = switch (this.conditionType) {
            case ConditionType.SCOREBOARD -> TextUtils.limitString((String)(this.conditionDataEntry.name() + " " + this.conditionDataEntry.operationType().name() + " " + this.conditionDataEntry.value()), (int)21);
            case ConditionType.EXECUTION_LIMIT -> TextUtils.limitString((String)(this.conditionDataEntry.value() + " (" + this.conditionDataEntry.text() + ")"), (int)21);
            default -> "-";
        };
        Text.drawString((class_332)guiGraphics, (class_327)this.font, (String)valuePreview, (int)(fieldsLeft + 110 + 2), (int)fieldTop, (int)0);
    }

    public void renderSeparatorLines(class_332 guiGraphics, int top) {
        int separatorTop = top - 1;
        int separatorLeft = this.leftPos + 5;
        DrawBorder.drawVerticalSeparator((class_332)guiGraphics, (int)(separatorLeft + 22 - 3), (int)separatorTop, (int)21, (int)-10066330);
        DrawBorder.drawVerticalSeparator((class_332)guiGraphics, (int)(separatorLeft + 110 - 3), (int)separatorTop, (int)21, (int)-10066330);
        DrawBorder.drawVerticalSeparator((class_332)guiGraphics, (int)(separatorLeft + 250 - 3), (int)separatorTop, (int)21, (int)-10066330);
    }

    public static interface OnEdit {
        public void edit(ConditionDataEntry var1);
    }

    public static interface OnRemove {
        public void remove(ConditionDataEntry var1);
    }
}

