/*
 * Decompiled with CFR 0.152.
 */
package de.markusbordihn.easynpc.configui.client.screen.editor.condition.entry;

import de.markusbordihn.easynpc.client.screen.components.ReloadButton;
import de.markusbordihn.easynpc.client.screen.components.SpinButton;
import de.markusbordihn.easynpc.client.screen.components.Text;
import de.markusbordihn.easynpc.client.screen.components.TextField;
import de.markusbordihn.easynpc.configui.client.screen.editor.condition.ConditionDataEntryEditorContainerScreen;
import de.markusbordihn.easynpc.configui.client.screen.editor.condition.entry.ConditionEntryWidget;
import de.markusbordihn.easynpc.configui.network.NetworkHandlerManager;
import de.markusbordihn.easynpc.configui.network.message.server.ResetExecutionLimitMessage;
import de.markusbordihn.easynpc.data.condition.ConditionDataEntry;
import de.markusbordihn.easynpc.data.condition.ConditionDataSet;
import de.markusbordihn.easynpc.data.condition.ConditionOperationType;
import de.markusbordihn.easynpc.data.condition.ConditionType;
import de.markusbordihn.easynpc.data.execution.ExecutionInterval;
import java.util.Arrays;
import java.util.LinkedHashSet;
import java.util.Set;
import java.util.stream.Collectors;
import net.minecraft.class_310;
import net.minecraft.class_327;
import net.minecraft.class_332;

public class ExecutionLimitConditionEntry
extends ConditionEntryWidget {
    private TextField maxExecutionsTextField;
    private SpinButton<ExecutionInterval> executionIntervalButton;

    public ExecutionLimitConditionEntry(ConditionDataEntry conditionDataEntry, ConditionDataSet conditionDataSet, ConditionDataEntryEditorContainerScreen<?> screen) {
        super(conditionDataEntry, conditionDataSet, screen);
    }

    @Override
    public void init(int editorLeft, int editorTop) {
        boolean hasConditionData = this.hasConditionData(ConditionType.EXECUTION_LIMIT);
        this.maxExecutionsTextField = this.screen.addConditionEntryWidget(new TextField(this.font, editorLeft, editorTop + 10, 35, hasConditionData ? String.valueOf(this.conditionDataEntry.value()) : "1", 4));
        this.executionIntervalButton = this.screen.addConditionEntryWidget(new SpinButton(this.maxExecutionsTextField.method_46426() + this.maxExecutionsTextField.method_25368() + 5, this.maxExecutionsTextField.method_46427(), 150, 16, (Set)Arrays.stream(ExecutionInterval.values()).sorted().collect(Collectors.toCollection(LinkedHashSet::new)), (Object)(hasConditionData ? ExecutionInterval.get((String)this.conditionDataEntry.text()) : ExecutionInterval.PER_DAY), button -> {}));
        ReloadButton resetCurrentPlayerButton = this.screen.addConditionEntryWidget(new ReloadButton(editorLeft + 5, this.executionIntervalButton.method_46427() + this.executionIntervalButton.method_25364() + 65, 300, 16, "condition.execution_limit.reset_current_player", onPress -> NetworkHandlerManager.sendMessageToServer(new ResetExecutionLimitMessage(this.screen.getDialogUUID(), false))));
        ReloadButton resetAllPlayersButton = this.screen.addConditionEntryWidget(new ReloadButton(resetCurrentPlayerButton.method_46426(), resetCurrentPlayerButton.method_46427() + resetCurrentPlayerButton.method_25364() + 5, 300, 16, "condition.execution_limit.reset_all_players", onPress -> NetworkHandlerManager.sendMessageToServer(new ResetExecutionLimitMessage(this.screen.getDialogUUID(), true))));
        resetAllPlayersButton.field_22763 = class_310.method_1551().field_1724 != null && class_310.method_1551().field_1724.method_5687(2);
    }

    @Override
    public void render(class_332 guiGraphics, int editorLeft, int editorTop) {
        if (this.maxExecutionsTextField != null) {
            Text.drawConfigString((class_332)guiGraphics, (class_327)this.font, (String)"condition.execution_limit.max_executions", (int)editorLeft, (int)(this.maxExecutionsTextField.method_46427() - 12), (int)0);
        }
    }

    @Override
    public ConditionDataEntry getConditionDataEntry() {
        int value = 1;
        if (this.maxExecutionsTextField != null) {
            try {
                value = Integer.parseInt(this.maxExecutionsTextField.method_1882());
            }
            catch (NumberFormatException numberFormatException) {
                // empty catch block
            }
        }
        return new ConditionDataEntry(ConditionType.EXECUTION_LIMIT, ConditionOperationType.NONE, "", value, this.executionIntervalButton != null ? ((ExecutionInterval)this.executionIntervalButton.get()).name() : ExecutionInterval.PER_DAY.name());
    }
}

