/*
 * Decompiled with CFR 0.152.
 */
package de.markusbordihn.easynpc.configui.client.screen.editor.condition.entry;

import de.markusbordihn.easynpc.client.screen.components.SpinButton;
import de.markusbordihn.easynpc.client.screen.components.Text;
import de.markusbordihn.easynpc.client.screen.components.TextField;
import de.markusbordihn.easynpc.configui.client.screen.editor.condition.ConditionDataEntryEditorContainerScreen;
import de.markusbordihn.easynpc.configui.client.screen.editor.condition.entry.ConditionEntryWidget;
import de.markusbordihn.easynpc.data.condition.ConditionDataEntry;
import de.markusbordihn.easynpc.data.condition.ConditionDataSet;
import de.markusbordihn.easynpc.data.condition.ConditionOperationType;
import de.markusbordihn.easynpc.data.condition.ConditionType;
import java.util.Arrays;
import java.util.LinkedHashSet;
import java.util.Set;
import java.util.stream.Collectors;
import net.minecraft.class_327;
import net.minecraft.class_332;

public class ScoreboardConditionEntry
extends ConditionEntryWidget {
    private TextField nameTextField;
    private SpinButton<ConditionOperationType> operationTypeButton;
    private TextField valueTextField;

    public ScoreboardConditionEntry(ConditionDataEntry conditionDataEntry, ConditionDataSet conditionDataSet, ConditionDataEntryEditorContainerScreen<?> screen) {
        super(conditionDataEntry, conditionDataSet, screen);
    }

    @Override
    public void init(int editorLeft, int editorTop) {
        boolean hasConditionData = this.hasConditionData(ConditionType.SCOREBOARD);
        this.nameTextField = this.screen.addConditionEntryWidget(new TextField(this.font, editorLeft + 110, editorTop, 180, hasConditionData ? this.conditionDataEntry.name() : "", 64));
        this.operationTypeButton = this.screen.addConditionEntryWidget(new SpinButton(editorLeft + 110, editorTop + 25, 180, 16, (Set)Arrays.stream(ConditionOperationType.values()).filter(type -> type != ConditionOperationType.NONE).sorted().collect(Collectors.toCollection(LinkedHashSet::new)), (Object)(hasConditionData ? this.conditionDataEntry.operationType() : ConditionOperationType.EQUALS), button -> {}));
        this.valueTextField = this.screen.addConditionEntryWidget(new TextField(this.font, editorLeft + 110, editorTop + 50, 180, hasConditionData ? String.valueOf(this.conditionDataEntry.value()) : "0", 10));
    }

    @Override
    public void render(class_332 guiGraphics, int editorLeft, int editorTop) {
        Text.drawConfigString((class_332)guiGraphics, (class_327)this.font, (String)"condition.scoreboard.name", (int)editorLeft, (int)(editorTop + 4), (int)0);
        Text.drawConfigString((class_332)guiGraphics, (class_327)this.font, (String)"condition.scoreboard.operation", (int)editorLeft, (int)(editorTop + 29), (int)0);
        Text.drawConfigString((class_332)guiGraphics, (class_327)this.font, (String)"condition.scoreboard.value", (int)editorLeft, (int)(editorTop + 54), (int)0);
    }

    @Override
    public ConditionDataEntry getConditionDataEntry() {
        int value = 0;
        if (this.valueTextField != null) {
            try {
                value = Integer.parseInt(this.valueTextField.method_1882());
            }
            catch (NumberFormatException numberFormatException) {
                // empty catch block
            }
        }
        return new ConditionDataEntry(ConditionType.SCOREBOARD, this.operationTypeButton != null ? (ConditionOperationType)this.operationTypeButton.get() : ConditionOperationType.EQUALS, this.nameTextField != null ? this.nameTextField.method_1882() : "", value);
    }
}

