/*
 * Decompiled with CFR 0.152.
 */
package de.markusbordihn.easynpc.configui.client.screen.editor.dialog;

import de.markusbordihn.easynpc.client.screen.components.AddButton;
import de.markusbordihn.easynpc.client.screen.components.CancelButton;
import de.markusbordihn.easynpc.client.screen.components.Checkbox;
import de.markusbordihn.easynpc.client.screen.components.DeleteButton;
import de.markusbordihn.easynpc.client.screen.components.SaveButton;
import de.markusbordihn.easynpc.client.screen.components.SpinButton;
import de.markusbordihn.easynpc.client.screen.components.SpriteButton;
import de.markusbordihn.easynpc.client.screen.components.Text;
import de.markusbordihn.easynpc.client.screen.components.TextButton;
import de.markusbordihn.easynpc.client.screen.components.TextEditButton;
import de.markusbordihn.easynpc.client.screen.components.TextField;
import de.markusbordihn.easynpc.configui.client.screen.EditorScreen;
import de.markusbordihn.easynpc.configui.client.screen.components.DialogButton;
import de.markusbordihn.easynpc.configui.client.screen.components.DialogButtonButton;
import de.markusbordihn.easynpc.configui.client.screen.components.DialogPriorityButton;
import de.markusbordihn.easynpc.configui.menu.editor.EditorMenu;
import de.markusbordihn.easynpc.configui.network.NetworkMessageHandlerManager;
import de.markusbordihn.easynpc.data.configuration.ConfigurationType;
import de.markusbordihn.easynpc.data.dialog.DialogButtonEntry;
import de.markusbordihn.easynpc.data.dialog.DialogDataEntry;
import de.markusbordihn.easynpc.data.dialog.DialogUtils;
import de.markusbordihn.easynpc.network.components.TextComponent;
import java.util.Set;
import net.minecraft.class_1661;
import net.minecraft.class_2561;
import net.minecraft.class_310;
import net.minecraft.class_327;
import net.minecraft.class_332;
import net.minecraft.class_364;
import net.minecraft.class_410;
import net.minecraft.class_4185;
import net.minecraft.class_437;
import net.minecraft.class_5244;

public class DialogEditorScreen<T extends EditorMenu>
extends EditorScreen<T> {
    private static final int MAX_NUMBER_OF_BUTTONS = 6;
    protected class_4185 homeButton;
    protected class_4185 dialogButton;
    protected class_4185 conditionsButton;
    protected class_4185 dialogTextButton;
    protected class_4185 addDialogButton;
    protected class_4185 saveButton;
    protected class_4185 cancelButton;
    protected class_4185 deleteButton;
    protected TextField dialogLabelTextField;
    protected Checkbox dialogLabelCheckbox;
    protected class_4185 dialogNameToLabelButton;
    protected DialogPriorityButton dialogPriorityButton;
    protected TextField dialogPriorityTextField;
    protected TextField dialogNameTextField;
    private String dialogLabelValue = "";
    private String dialogNameValue = "";
    private int dialogPriorityValue = 0;

    public DialogEditorScreen(T menu, class_1661 inventory, class_2561 component) {
        super(menu, inventory, component);
    }

    private void openPreviousScreen() {
        NetworkMessageHandlerManager.getServerHandler().openConfiguration(this.getEasyNPCUUID(), ConfigurationType.DIALOG);
    }

    private void deleteDialog() {
        class_310 minecraft = this.field_22787;
        if (minecraft == null) {
            return;
        }
        minecraft.method_1507((class_437)new class_410(confirmed -> {
            if (confirmed && this.getEasyNPCUUID() != null) {
                NetworkMessageHandlerManager.getServerHandler().removeDialog(this.getEasyNPCUUID(), this.getDialogUUID());
                NetworkMessageHandlerManager.getServerHandler().openConfiguration(this.getEasyNPCUUID(), ConfigurationType.DIALOG);
            } else {
                minecraft.method_1507((class_437)this);
            }
        }, (class_2561)TextComponent.getTranslatedConfigText((String)"removeDialog.deleteQuestion"), (class_2561)TextComponent.getTranslatedConfigText((String)"removeDialog.deleteWarning", (String)this.getDialogData().getName()), (class_2561)TextComponent.getTranslatedConfigText((String)"removeDialog.deleteButton"), class_5244.field_24335));
    }

    private void renderEditLabels(class_332 guiGraphics) {
        if (this.dialogNameTextField != null) {
            Text.drawConfigString((class_332)guiGraphics, (class_327)this.field_22793, (String)"dialog.name", (int)(this.leftPos + 10), (int)(this.dialogNameTextField.method_46427() + 4), (int)0);
        }
        if (this.dialogLabelTextField != null) {
            Text.drawConfigString((class_332)guiGraphics, (class_327)this.field_22793, (String)"label_id", (int)(this.leftPos + 10), (int)(this.dialogLabelTextField.method_46427() + 4), (int)0);
        }
        if (this.dialogPriorityButton != null) {
            Text.drawConfigString((class_332)guiGraphics, (class_327)this.field_22793, (String)"dialog.priority", (int)(this.leftPos + 10), (int)(this.dialogPriorityButton.method_46427() + 4), (int)0);
        }
        if (this.conditionsButton != null) {
            Text.drawConfigString((class_332)guiGraphics, (class_327)this.field_22793, (String)"dialog.conditions", (int)(this.leftPos + 10), (int)(this.conditionsButton.method_46427() + 4), (int)0);
        }
        if (this.dialogTextButton != null) {
            Text.drawConfigString((class_332)guiGraphics, (class_327)this.field_22793, (String)"dialog.text", (int)(this.leftPos + 10), (int)(this.dialogTextButton.method_46427() - 12), (int)0);
            Text.drawConfigString((class_332)guiGraphics, (class_327)this.field_22793, (String)"dialog.buttons", (int)(this.leftPos + 10), (int)(this.dialogTextButton.method_46427() + 25), (int)0);
        }
    }

    private void saveDialogData() {
        boolean hasChanged;
        int currentPriority = this.dialogPriorityButton.getPriority();
        if (this.dialogPriorityButton.isCustom() && this.dialogPriorityTextField != null) {
            try {
                currentPriority = Integer.parseInt(this.dialogPriorityTextField.method_1882());
            }
            catch (NumberFormatException numberFormatException) {
                // empty catch block
            }
        }
        boolean bl = hasChanged = !this.dialogNameTextField.method_1882().equals(this.dialogNameValue) || !this.dialogLabelTextField.method_1882().equals(this.dialogLabelValue) || currentPriority != this.dialogPriorityValue;
        if (!hasChanged) {
            return;
        }
        DialogDataEntry dialogDataEntry = this.getDialogData();
        dialogDataEntry.setName(this.dialogNameTextField.method_1882());
        dialogDataEntry.setLabel(this.dialogLabelTextField.method_1882());
        dialogDataEntry.setPriority(currentPriority);
        NetworkMessageHandlerManager.getServerHandler().saveDialog(this.getEasyNPCUUID(), this.getDialogUUID(), dialogDataEntry);
    }

    public void method_25426() {
        super.method_25426();
        this.homeButton = (class_4185)this.method_37063((class_364)new TextButton(this.leftPos + 7, this.topPos + 7, 10, 16, "<", onPress -> this.openPreviousScreen()));
        DialogDataEntry dialogDataEntry = this.getDialogData();
        this.dialogButton = (class_4185)this.method_37063((class_364)new DialogButton(this.homeButton.method_46426() + this.homeButton.method_25368(), this.topPos + 7, 140, dialogDataEntry.getName(21), onPress -> {}));
        this.dialogButton.field_22763 = false;
        this.dialogNameValue = this.getDialogData().getName();
        this.dialogNameTextField = new TextField(this.field_22793, this.leftPos + 100, this.topPos + 28, 150, this.dialogNameValue);
        this.dialogNameTextField.method_1880(64);
        this.method_37063((class_364)this.dialogNameTextField);
        this.dialogNameToLabelButton = (class_4185)this.method_37063((class_364)new SpriteButton(this.dialogNameTextField.method_46426() + this.dialogNameTextField.method_25368() + 1, this.dialogNameTextField.method_46427() - 1, 18, 18, 4, 4, 80, 80, 12, 12, onPress -> {
            if (this.dialogNameTextField != null && this.dialogLabelTextField != null) {
                String buttonName = this.dialogNameTextField.method_1882();
                this.dialogLabelTextField.method_1852(DialogUtils.generateButtonLabel((String)buttonName));
            }
        }));
        this.dialogLabelValue = dialogDataEntry.getLabel();
        this.dialogLabelTextField = new TextField(this.field_22793, this.leftPos + 100, this.topPos + 48, 100);
        this.dialogLabelTextField.method_1880(32);
        this.dialogLabelTextField.method_1852(this.dialogLabelValue);
        this.dialogLabelTextField.method_1888(this.dialogLabelTextField.method_1882().isEmpty());
        this.method_37063((class_364)this.dialogLabelTextField);
        this.dialogLabelCheckbox = new Checkbox(this.leftPos + 203, this.dialogLabelTextField.method_46427() + 1, "locked", !dialogDataEntry.getLabel().isEmpty(), checkbox -> this.dialogLabelTextField.method_1888(!checkbox.selected()));
        this.method_37063((class_364)this.dialogLabelCheckbox);
        this.conditionsButton = (class_4185)this.method_37063((class_364)new DialogButton(this.leftPos + 99, this.topPos + 67, 140, dialogDataEntry.hasConditions() ? "dialog.edit_conditions" : "dialog.create_conditions", onPress -> {
            this.saveDialogData();
            NetworkMessageHandlerManager.getServerHandler().openConditionDataEditor(this.getEasyNPCUUID(), this.getDialogUUID());
        }));
        this.dialogPriorityValue = dialogDataEntry.getPriority();
        this.dialogPriorityButton = (DialogPriorityButton)this.method_37063((class_364)new DialogPriorityButton(this.leftPos + 99, this.topPos + 86, 110, 16, this.dialogPriorityValue, (SpinButton.OnChange<DialogPriorityButton.PriorityValue>)((SpinButton.OnChange)button -> {
            if (this.dialogPriorityTextField != null) {
                this.dialogPriorityTextField.method_1862(this.dialogPriorityButton.isCustom());
                if (this.dialogPriorityButton.isCustom() && this.dialogPriorityTextField.method_1882().isEmpty()) {
                    this.dialogPriorityTextField.method_1852(String.valueOf(this.dialogPriorityValue));
                }
            }
        })));
        this.dialogPriorityTextField = new TextField(this.field_22793, this.dialogPriorityButton.method_46426() + this.dialogPriorityButton.method_25368() + 2, this.dialogPriorityButton.method_46427(), 30, this.dialogPriorityButton.isCustom() ? String.valueOf(this.dialogPriorityValue) : "", 3);
        this.dialogPriorityTextField.method_1862(this.dialogPriorityButton.isCustom());
        this.method_37063((class_364)this.dialogPriorityTextField);
        this.dialogTextButton = (class_4185)this.method_37063((class_364)new TextEditButton(this.leftPos + 7, this.topPos + 122, 315, "dialog.edit_text", onPress -> {
            this.saveDialogData();
            NetworkMessageHandlerManager.getServerHandler().openDialogTextEditor(this.getEasyNPCUUID(), this.getDialogUUID());
        }));
        this.defineDialogButtons(dialogDataEntry);
        this.saveButton = (class_4185)this.method_37063((class_364)new SaveButton(this.leftPos + 8, this.bottomPos - 30, 130, "save", onPress -> {
            this.saveDialogData();
            this.openPreviousScreen();
        }));
        this.deleteButton = (class_4185)this.method_37063((class_364)new DeleteButton(this.saveButton.method_46426() + this.saveButton.method_25368() + 10, this.bottomPos - 30, 85, onPress -> this.deleteDialog()));
        this.cancelButton = (class_4185)this.method_37063((class_364)new CancelButton(this.deleteButton.method_46426() + this.deleteButton.method_25368() + 5, this.bottomPos - 30, 85, "cancel", onPress -> this.openPreviousScreen()));
    }

    private void defineDialogButtons(DialogDataEntry dialogDataEntry) {
        Set dialogButtons = dialogDataEntry.getDialogButtons();
        boolean smallButtons = dialogButtons.size() < 4;
        int buttonIndex = 0;
        int buttonBaseLeftPos = this.leftPos + 7;
        int buttonTopPos = this.topPos + 157;
        int buttonLeftPos = buttonBaseLeftPos;
        int buttonSpace = 3;
        int buttonWidth = smallButtons ? 156 : 103;
        int buttonMaxTextLength = smallButtons ? 22 : 14;
        for (DialogButtonEntry dialogButtonEntry : dialogButtons) {
            if (buttonIndex > 5) break;
            if (smallButtons && buttonIndex == 2 || !smallButtons && buttonIndex == 3) {
                buttonTopPos += 18;
                buttonLeftPos = buttonBaseLeftPos;
            }
            DialogButtonButton dialogActionButton = new DialogButtonButton(buttonLeftPos, buttonTopPos, buttonWidth, dialogButtonEntry.getButtonName(buttonMaxTextLength).getString(), onPress -> {
                log.info("Edit dialog button {}", (Object)dialogButtonEntry.id());
                NetworkMessageHandlerManager.getServerHandler().openDialogButtonEditor(this.getEasyNPCUUID(), this.getDialogUUID(), dialogButtonEntry.id());
            });
            this.method_37063((class_364)dialogActionButton);
            buttonLeftPos += buttonWidth + buttonSpace;
            ++buttonIndex;
        }
        if (buttonIndex < 6) {
            this.addDialogButton = new AddButton(dialogButtons.size() < 5 && buttonIndex != 2 ? buttonLeftPos : buttonBaseLeftPos, dialogButtons.size() < 5 && buttonIndex != 2 ? buttonTopPos : buttonTopPos + 18, smallButtons ? buttonWidth : 208, "dialog.add_button", onPress -> {
                this.saveDialogData();
                NetworkMessageHandlerManager.getServerHandler().openDialogButtonEditor(this.getEasyNPCUUID(), this.getDialogUUID());
            });
            this.method_37063((class_364)this.addDialogButton);
        }
    }

    public void updateTick() {
        super.updateTick();
        if (this.saveButton != null) {
            int currentPriority = this.dialogPriorityButton.getPriority();
            if (this.dialogPriorityButton.isCustom() && this.dialogPriorityTextField != null) {
                try {
                    currentPriority = Integer.parseInt(this.dialogPriorityTextField.method_1882());
                }
                catch (NumberFormatException numberFormatException) {
                    // empty catch block
                }
            }
            boolean bl = this.saveButton.field_22763 = !this.dialogNameTextField.method_1882().equals(this.dialogNameValue) || !this.dialogLabelTextField.method_1882().equals(this.dialogLabelValue) || currentPriority != this.dialogPriorityValue;
        }
        if (this.dialogLabelCheckbox != null && this.dialogNameToLabelButton != null) {
            this.dialogNameToLabelButton.field_22763 = !this.dialogLabelCheckbox.selected();
        }
    }

    @Override
    public void method_25394(class_332 guiGraphics, int x, int y, float partialTicks) {
        super.method_25394(guiGraphics, x, y, partialTicks);
        this.renderEditLabels(guiGraphics);
        if (this.dialogNameToLabelButton != null && this.dialogNameToLabelButton.method_25405((double)x, (double)y)) {
            guiGraphics.method_51438(this.field_22793, (class_2561)TextComponent.getTranslatedConfigText((String)"name_to_label.tooltip"), x, y);
        }
    }
}

