/*
 * Decompiled with CFR 0.152.
 */
package de.markusbordihn.easynpc.configui.client.screen.preset;

import de.markusbordihn.easynpc.client.screen.components.SpinButton;
import de.markusbordihn.easynpc.client.screen.components.Text;
import de.markusbordihn.easynpc.client.screen.components.TextButton;
import de.markusbordihn.easynpc.client.screen.components.TextField;
import de.markusbordihn.easynpc.configui.client.screen.CustomScreen;
import de.markusbordihn.easynpc.configui.client.screen.preset.PresetDetailsView;
import de.markusbordihn.easynpc.configui.client.screen.preset.PresetInfoView;
import de.markusbordihn.easynpc.configui.client.screen.preset.PresetList;
import de.markusbordihn.easynpc.configui.client.screen.preset.PresetListEntry;
import de.markusbordihn.easynpc.configui.client.screen.preset.PresetPreviewView;
import de.markusbordihn.easynpc.configui.data.preset.PresetFilterType;
import de.markusbordihn.easynpc.configui.data.screen.AdditionalScreenData;
import de.markusbordihn.easynpc.configui.menu.preset.PresetBrowserMenu;
import de.markusbordihn.easynpc.configui.network.NetworkMessageHandlerManager;
import de.markusbordihn.easynpc.data.preset.PresetMetadata;
import de.markusbordihn.easynpc.data.preset.PresetType;
import de.markusbordihn.easynpc.io.ClientDefaultPresetDataFiles;
import de.markusbordihn.easynpc.io.CustomPresetDataFiles;
import de.markusbordihn.easynpc.io.LocalPresetDataFiles;
import de.markusbordihn.easynpc.io.WorldPresetDataFiles;
import de.markusbordihn.easynpc.utils.CompoundTagUtils;
import java.util.Collections;
import java.util.HashSet;
import java.util.Set;
import java.util.function.Function;
import java.util.stream.Stream;
import net.minecraft.class_1661;
import net.minecraft.class_2487;
import net.minecraft.class_2499;
import net.minecraft.class_2561;
import net.minecraft.class_2960;
import net.minecraft.class_327;
import net.minecraft.class_332;
import net.minecraft.class_364;
import net.minecraft.class_410;
import net.minecraft.class_4185;
import net.minecraft.class_437;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public class PresetBrowserScreen
extends CustomScreen<PresetBrowserMenu, AdditionalScreenData> {
    protected static final Logger log = LogManager.getLogger((String)"Easy NPC: Config UI");
    private static final int PREVIEW_Y = 90;
    private PresetList presetListWidget;
    private PresetListEntry selectedEntry;
    private class_4185 spawnAsNewButton;
    private class_4185 spawnWithOriginalButton;
    private TextField searchBox;
    private PresetFilterType currentFilter = PresetFilterType.ALL;
    private String searchFilter = "";
    private int infoBoxHeight;

    public PresetBrowserScreen(PresetBrowserMenu menu, class_1661 inventory, class_2561 component) {
        super(menu, inventory, component, 328, 243);
        this.showCloseButton = true;
        this.renderBackground = false;
        this.renderDefaultScreenBackground = false;
    }

    public boolean method_25421() {
        return false;
    }

    @Override
    protected void method_25426() {
        super.method_25426();
        int listWidth = 150;
        int listX = 5;
        int listY = 55;
        int filterY = 30;
        this.method_37063((class_364)new SpinButton(listX, filterY, 68, 16, PresetFilterType.getFilterNames(), (Object)PresetFilterType.ALL.name(), button -> {
            this.currentFilter = PresetFilterType.valueOf((String)button.get());
            this.refreshPresetList();
        }));
        this.searchBox = new TextField(this.field_22793, listX + 73, filterY, listWidth - 65);
        this.searchBox.method_1880(50);
        this.searchBox.method_47404((class_2561)class_2561.method_43471((String)"text.easy_npc.config.preset_browser.search"));
        this.searchBox.method_1863(text -> {
            this.searchFilter = text.toLowerCase();
            this.refreshPresetList();
        });
        this.method_37063((class_364)this.searchBox);
        this.presetListWidget = new PresetList(this.field_22787, listWidth, this.field_22790 - 65, listY, 30);
        this.method_25429((class_364)this.presetListWidget);
        this.infoBoxHeight = Math.min((int)((float)this.field_22790 * 0.22f), 70);
        this.spawnAsNewButton = (class_4185)this.method_37063((class_364)new TextButton(listX + listWidth + 15, this.field_22790 - 35, (this.field_22789 - (listX + listWidth + 15) - 10 - 5) / 2, "preset_browser.spawn_new", button -> this.spawnPreset(false)));
        this.spawnAsNewButton.field_22763 = false;
        this.spawnAsNewButton.field_22764 = false;
        this.spawnWithOriginalButton = (class_4185)this.method_37063((class_364)new TextButton(this.spawnAsNewButton.method_46426() + this.spawnAsNewButton.method_25368() + 5, this.spawnAsNewButton.method_46427(), this.spawnAsNewButton.method_25368(), "preset_browser.spawn_original", button -> this.spawnPreset(true)));
        this.spawnWithOriginalButton.field_22763 = false;
        this.spawnWithOriginalButton.field_22764 = false;
        this.loadPresets();
    }

    public boolean isSelected(class_2960 preset) {
        return this.selectedEntry != null && this.selectedEntry.getPreset().equals((Object)preset);
    }

    public void selectEntry(PresetListEntry entry) {
        boolean hasUUID;
        this.selectedEntry = entry;
        this.spawnAsNewButton.field_22763 = entry != null;
        this.spawnAsNewButton.field_22764 = entry != null;
        this.spawnWithOriginalButton.field_22763 = hasUUID = entry != null && entry.getPresetData() != null && entry.getPresetData().data() != null && entry.getPresetData().data().method_25928("UUID");
        this.spawnWithOriginalButton.field_22764 = hasUUID;
    }

    private boolean matchesFilters(class_2960 preset, PresetMetadata metadata, PresetType type) {
        if (!this.currentFilter.matches(type)) {
            return false;
        }
        if (!this.searchFilter.isEmpty()) {
            return LocalPresetDataFiles.getPresetDisplayName((class_2960)preset, (PresetMetadata)metadata).toLowerCase().contains(this.searchFilter) || preset.method_12832().toLowerCase().contains(this.searchFilter) || metadata.description().toLowerCase().contains(this.searchFilter) || metadata.category().toLowerCase().contains(this.searchFilter) || metadata.author().toLowerCase().contains(this.searchFilter);
        }
        return true;
    }

    private void refreshPresetList() {
        this.presetListWidget.method_25396().clear();
        this.selectedEntry = null;
        this.spawnAsNewButton.field_22763 = false;
        this.spawnWithOriginalButton.field_22763 = false;
        this.spawnWithOriginalButton.field_22764 = false;
        this.loadPresets();
    }

    private void loadPresets() {
        this.loadPresetsOfType(PresetType.LOCAL, LocalPresetDataFiles.getPresetResourceLocations(), LocalPresetDataFiles::getPresetMetadata);
        this.loadPresetsOfType(PresetType.DEFAULT, ClientDefaultPresetDataFiles.getDefaultPresetResourceLocations(), ClientDefaultPresetDataFiles::getPresetMetadata);
        if (this.getAdditionalScreenData() != null) {
            this.loadPresetsFromServerSync();
        }
    }

    private void loadPresetsFromServerSync() {
        Set<class_2960> worldPresets;
        Set<class_2960> dataPresets;
        Set<class_2960> customPresets = this.loadPresetListFromAdditionalData("CustomPresets");
        if (!customPresets.isEmpty()) {
            this.loadPresetsOfType(PresetType.CUSTOM, customPresets.stream(), CustomPresetDataFiles::getPresetMetadata);
        }
        if (!(dataPresets = this.loadPresetListFromAdditionalData("DataPresets")).isEmpty()) {
            this.loadPresetsOfType(PresetType.DATA, dataPresets.stream(), preset -> this.loadMetadataFromAdditionalData("DataPresetsMetadata", (class_2960)preset));
        }
        if (!(worldPresets = this.loadPresetListFromAdditionalData("WorldPresets")).isEmpty()) {
            this.loadPresetsOfType(PresetType.WORLD, worldPresets.stream(), WorldPresetDataFiles::getPresetMetadata);
        }
    }

    private Set<class_2960> loadPresetListFromAdditionalData(String key) {
        if (this.getAdditionalScreenData() == null) {
            return Collections.emptySet();
        }
        class_2499 listTag = ((AdditionalScreenData)this.getAdditionalScreenData()).getList(key);
        if (listTag.isEmpty()) {
            return Collections.emptySet();
        }
        return new HashSet<class_2960>(CompoundTagUtils.readResourceLocations((class_2499)listTag));
    }

    private PresetMetadata loadMetadataFromAdditionalData(String metadataKey, class_2960 preset) {
        if (this.getAdditionalScreenData() == null) {
            return PresetMetadata.createDefault();
        }
        class_2487 metadataMap = ((AdditionalScreenData)this.getAdditionalScreenData()).get(metadataKey);
        if (metadataMap == null || !metadataMap.method_10545(preset.toString())) {
            return PresetMetadata.createDefault();
        }
        return PresetMetadata.fromCompoundTag((class_2487)metadataMap.method_10562(preset.toString()));
    }

    private void loadPresetsOfType(PresetType type, Stream<class_2960> presets, Function<class_2960, PresetMetadata> metadataProvider) {
        if (!this.currentFilter.matches(type)) {
            return;
        }
        presets.forEach(preset -> {
            PresetMetadata metadata = (PresetMetadata)metadataProvider.apply((class_2960)preset);
            if (this.matchesFilters((class_2960)preset, metadata, type)) {
                this.presetListWidget.addEntry(new PresetListEntry((class_2960)preset, metadata, type, this));
            }
        });
    }

    private void spawnPreset(boolean withOriginal) {
        if (this.selectedEntry == null) {
            return;
        }
        if (withOriginal) {
            this.showConfirmationDialog();
        } else {
            this.executeSpawn(false);
        }
    }

    private void showConfirmationDialog() {
        if (this.field_22787 == null || this.selectedEntry == null) {
            return;
        }
        String uuid = "Unknown";
        if (this.selectedEntry.getPresetData() != null && this.selectedEntry.getPresetData().data() != null && this.selectedEntry.getPresetData().data().method_25928("UUID")) {
            uuid = this.selectedEntry.getPresetData().data().method_25926("UUID").toString();
        }
        this.field_22787.method_1507((class_437)new class_410(confirmed -> {
            if (confirmed) {
                this.executeSpawn(true);
            }
            this.field_22787.method_1507((class_437)this);
        }, (class_2561)class_2561.method_43471((String)"text.easy_npc.config.preset_browser.confirm_title"), (class_2561)class_2561.method_43469((String)"text.easy_npc.config.preset_browser.confirm_message", (Object[])new Object[]{uuid}), (class_2561)class_2561.method_43471((String)"text.easy_npc.config.preset_browser.confirm_yes"), (class_2561)class_2561.method_43471((String)"text.easy_npc.config.preset_browser.confirm_no")));
    }

    private void executeSpawn(boolean withOriginal) {
        if (this.selectedEntry == null) {
            return;
        }
        log.info("Spawning preset {}: {}", (Object)(withOriginal ? "with original UUID/position" : "as new NPC"), (Object)this.selectedEntry.getPreset());
        if (this.selectedEntry.getPresetType() == PresetType.LOCAL && this.selectedEntry.getPresetData() != null) {
            NetworkMessageHandlerManager.getServerHandler().spawnPresetWithData(this.selectedEntry.getPresetData(), withOriginal);
        } else {
            NetworkMessageHandlerManager.getServerHandler().spawnPreset(this.selectedEntry.getPresetType(), this.selectedEntry.getPreset(), withOriginal);
        }
        this.method_25419();
    }

    public void method_25394(class_332 guiGraphics, int mouseX, int mouseY, float partialTicks) {
        super.method_25394(guiGraphics, mouseX, mouseY, partialTicks);
        if (this.searchBox != null) {
            this.searchBox.method_25394(guiGraphics, mouseX, mouseY, partialTicks);
        }
        this.presetListWidget.method_25394(guiGraphics, mouseX, mouseY, partialTicks);
        if (this.selectedEntry != null) {
            this.renderPresetTitle(guiGraphics);
            this.renderPreviewPanels(guiGraphics, mouseX, mouseY);
        }
    }

    private void renderPresetTitle(class_332 guiGraphics) {
        Text.drawString((class_332)guiGraphics, (class_327)this.field_22793, (String)LocalPresetDataFiles.getPresetDisplayName((class_2960)this.selectedEntry.getPreset(), (PresetMetadata)this.selectedEntry.getMetadata()), (int)(this.spawnAsNewButton.method_46426() + 5), (int)35, (int)0x3F3F3F);
    }

    private void renderPreviewPanels(class_332 guiGraphics, int mouseX, int mouseY) {
        int rightPanelX = this.spawnAsNewButton.method_46426();
        int rightPanelWidth = this.spawnWithOriginalButton.method_46426() + this.spawnWithOriginalButton.method_25368() - rightPanelX;
        int previewBoxWidth = rightPanelWidth / 2 - 25;
        int previewBoxY = 45;
        PresetPreviewView.render(guiGraphics, this.field_22793, this.selectedEntry.getPreviewNPC(), rightPanelX, previewBoxY, previewBoxWidth, 110, 90, mouseX, mouseY);
        PresetDetailsView.render(guiGraphics, this.field_22793, this.selectedEntry.getPreviewNPC(), this.selectedEntry.getPresetData(), rightPanelX + previewBoxWidth + 5, previewBoxY, rightPanelWidth - previewBoxWidth - 5, 110);
        PresetInfoView.render(guiGraphics, this.field_22793, this.selectedEntry.getPreset(), this.selectedEntry.getMetadata(), rightPanelX, previewBoxY + 115, rightPanelWidth, this.infoBoxHeight);
        this.spawnAsNewButton.method_46419(previewBoxY + 115 + this.infoBoxHeight + 5);
        this.spawnWithOriginalButton.method_46419(this.spawnAsNewButton.method_46427());
    }

    public void method_25432() {
        if (this.presetListWidget != null) {
            this.presetListWidget.removed();
        }
        super.method_25432();
    }

    public boolean method_25402(double mouseX, double mouseY, int button) {
        return this.presetListWidget.method_25402(mouseX, mouseY, button) || super.method_25402(mouseX, mouseY, button);
    }

    public boolean method_25401(double mouseX, double mouseY, double deltaX, double deltaY) {
        return this.presetListWidget.method_25401(mouseX, mouseY, deltaX, deltaY) || super.method_25401(mouseX, mouseY, deltaX, deltaY);
    }
}

