/*
 * Decompiled with CFR 0.152.
 */
package de.markusbordihn.easynpc.configui.client.screen.preset;

import de.markusbordihn.easynpc.client.screen.components.DrawBorder;
import de.markusbordihn.easynpc.client.screen.components.DrawBox;
import de.markusbordihn.easynpc.client.screen.components.Text;
import de.markusbordihn.easynpc.configui.client.renderer.screen.EntityConfigScreenRenderer;
import de.markusbordihn.easynpc.configui.client.screen.preset.PresetBrowserScreen;
import de.markusbordihn.easynpc.data.preset.PresetData;
import de.markusbordihn.easynpc.data.preset.PresetMetadata;
import de.markusbordihn.easynpc.data.preset.PresetType;
import de.markusbordihn.easynpc.data.render.EntityRenderConfig;
import de.markusbordihn.easynpc.entity.easynpc.EasyNPC;
import de.markusbordihn.easynpc.handler.PresetHandler;
import de.markusbordihn.easynpc.io.ClientDefaultPresetDataFiles;
import de.markusbordihn.easynpc.io.LocalPresetDataFiles;
import net.minecraft.class_1132;
import net.minecraft.class_1297;
import net.minecraft.class_1937;
import net.minecraft.class_2561;
import net.minecraft.class_2960;
import net.minecraft.class_310;
import net.minecraft.class_327;
import net.minecraft.class_332;
import net.minecraft.class_4280;
import net.minecraft.server.MinecraftServer;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public class PresetListEntry
extends class_4280.class_4281<PresetListEntry> {
    protected static final Logger log = LogManager.getLogger((String)"Easy NPC: Config UI");
    private static final float TEXT_SCALE = 0.75f;
    private static final int PREVIEW_BOX_SIZE = 24;
    private final class_2960 preset;
    private final PresetMetadata metadata;
    private final PresetType presetType;
    private final PresetBrowserScreen screen;
    private PresetData presetData;
    private EasyNPC<?> previewNPC;

    public PresetListEntry(class_2960 preset, PresetMetadata metadata, PresetType presetType, PresetBrowserScreen screen) {
        this.preset = preset;
        this.metadata = metadata;
        this.presetType = presetType;
        this.screen = screen;
        this.loadPresetData();
    }

    private void loadPresetData() {
        try {
            if (this.presetType == PresetType.LOCAL) {
                this.presetData = LocalPresetDataFiles.loadPresetData((class_2960)this.preset);
                if (this.presetData != null && this.presetData.hasValidData()) {
                    this.loadPreviewNPC();
                } else {
                    log.warn("Invalid PresetData for LOCAL preset: {}", (Object)this.preset);
                }
                return;
            }
            if (this.presetType == PresetType.DEFAULT) {
                this.presetData = ClientDefaultPresetDataFiles.loadDefaultPresetData((class_2960)this.preset);
                if (this.presetData != null && this.presetData.hasValidData()) {
                    this.loadPreviewNPC();
                } else {
                    log.warn("Invalid PresetData for DEFAULT preset: {}", (Object)this.preset);
                }
                return;
            }
            class_1132 server = class_310.method_1551().method_1576();
            if (server != null) {
                this.presetData = PresetHandler.loadPreset((class_2960)this.preset, (PresetType)this.presetType, (MinecraftServer)server);
                if (this.presetData != null && this.presetData.hasValidData()) {
                    this.loadPreviewNPC();
                } else {
                    log.warn("Invalid PresetData for: {}", (Object)this.preset);
                }
            } else {
                log.debug("Preset preview not available on dedicated server for: {} (spawning will still work)", (Object)this.preset);
            }
        }
        catch (Exception e) {
            log.error("Failed to load preset data for {}: {}", (Object)this.preset, (Object)e.getMessage());
        }
    }

    private void loadPreviewNPC() {
        try {
            class_310 minecraft = class_310.method_1551();
            if (minecraft.field_1687 == null || this.presetData == null) {
                return;
            }
            class_1297 entity = this.presetData.entityType().method_5883((class_1937)minecraft.field_1687);
            if (entity instanceof EasyNPC) {
                EasyNPC easyNPC = (EasyNPC)entity;
                entity.method_5651(this.presetData.data());
                this.previewNPC = easyNPC;
            } else if (entity != null) {
                log.warn("Preset {} is not an EasyNPC entity", (Object)this.preset);
            }
        }
        catch (Exception e) {
            log.error("Failed to create preview NPC for {}: {}", (Object)this.preset, (Object)e.getMessage());
        }
    }

    public void cleanup() {
        if (this.previewNPC != null && this.previewNPC.getEntity() != null) {
            this.previewNPC.getEntity().method_31472();
            this.previewNPC = null;
        }
    }

    public class_2960 getPreset() {
        return this.preset;
    }

    public PresetMetadata getMetadata() {
        return this.metadata;
    }

    public PresetType getPresetType() {
        return this.presetType;
    }

    public PresetData getPresetData() {
        return this.presetData;
    }

    public EasyNPC<?> getPreviewNPC() {
        return this.previewNPC;
    }

    public void method_25343(class_332 guiGraphics, int index, int top, int left, int width, int height, int mouseX, int mouseY, boolean isMouseOver, float partialTicks) {
        guiGraphics.method_25294(left, top, left + width, top + height, this.screen.isSelected(this.preset) ? -2130706433 : (isMouseOver ? 0x40FFFFFF : 0));
        int previewBoxX = left + 1;
        int previewBoxY = top + 1;
        this.renderPreviewBox(guiGraphics, previewBoxX, previewBoxY, mouseX, mouseY);
        this.renderPresetInfo(guiGraphics, left, top);
    }

    private void renderPreviewBox(class_332 guiGraphics, int x, int y, int mouseX, int mouseY) {
        DrawBox.draw((class_332)guiGraphics, (int)x, (int)y, (int)24, (int)24);
        DrawBorder.draw((class_332)guiGraphics, (int)x, (int)y, (int)24, (int)24);
        if (this.previewNPC != null) {
            EntityConfigScreenRenderer.renderEntity(guiGraphics, this.previewNPC, EntityRenderConfig.guiScaled((int)(x + 12), (int)(y + 24 - 12), (int)10, (float)0.0f, (float)0.0f), mouseX, mouseY);
        }
    }

    private void renderPresetInfo(class_332 guiGraphics, int left, int top) {
        guiGraphics.method_51448().method_22903();
        guiGraphics.method_51448().method_22905(0.75f, 0.75f, 1.0f);
        int scaledX = (int)((float)(left + 26) / 0.75f);
        int scaledY = (int)((float)(top + 2) / 0.75f);
        int lineHeight = 13;
        Text.drawString((class_332)guiGraphics, (class_327)this.screen.getFont(), (String)LocalPresetDataFiles.getPresetDisplayName((class_2960)this.preset, (PresetMetadata)this.metadata), (int)scaledX, (int)scaledY, (int)0);
        Text.drawString((class_332)guiGraphics, (class_327)this.screen.getFont(), (String)(this.presetType.name() + " - " + this.metadata.category()), (int)scaledX, (int)(scaledY + lineHeight), (int)0x3F3F3F);
        Text.drawString((class_332)guiGraphics, (class_327)this.screen.getFont(), (String)this.metadata.version(), (int)scaledX, (int)(scaledY + lineHeight * 2), (int)0x3F3F3F);
        guiGraphics.method_51448().method_22909();
    }

    public class_2561 method_37006() {
        return class_2561.method_43470((String)LocalPresetDataFiles.getPresetDisplayName((class_2960)this.preset, (PresetMetadata)this.metadata));
    }

    public boolean method_25402(double mouseX, double mouseY, int button) {
        this.screen.selectEntry(this);
        return true;
    }
}

