/*
 * Decompiled with CFR 0.152.
 */
package de.markusbordihn.easynpc.configui.data.preset;

import de.markusbordihn.easynpc.data.preset.PresetType;
import java.util.Arrays;
import java.util.Set;
import java.util.stream.Collectors;
import java.util.stream.Stream;

public enum PresetFilterType {
    ALL(null),
    CUSTOM(PresetType.CUSTOM),
    DATA(PresetType.DATA),
    DEFAULT(PresetType.DEFAULT),
    LOCAL(PresetType.LOCAL),
    WORLD(PresetType.WORLD);

    private final PresetType presetType;

    private PresetFilterType(PresetType presetType) {
        this.presetType = presetType;
    }

    public static Set<PresetFilterType> getAllFilters() {
        return Arrays.stream(PresetFilterType.values()).collect(Collectors.toSet());
    }

    public static Set<String> getFilterNames() {
        return Stream.of(PresetFilterType.values()).map(Enum::name).collect(Collectors.toSet());
    }

    public PresetType getPresetType() {
        return this.presetType;
    }

    public boolean matches(PresetType type) {
        return this.presetType == null || this.presetType == type;
    }
}

