/*
 * Decompiled with CFR 0.152.
 */
package de.markusbordihn.easynpc.configui.menu;

import de.markusbordihn.easynpc.access.AccessManager;
import de.markusbordihn.easynpc.configui.data.custom.CustomMenuType;
import de.markusbordihn.easynpc.configui.data.editor.EditorType;
import de.markusbordihn.easynpc.configui.data.screen.AdditionalScreenData;
import de.markusbordihn.easynpc.configui.menu.ConfigUIMenu;
import de.markusbordihn.easynpc.configui.menu.MenuManager;
import de.markusbordihn.easynpc.configui.menu.configuration.ConfigurationMenu;
import de.markusbordihn.easynpc.configui.menu.configuration.ConfigurationMenuHandler;
import de.markusbordihn.easynpc.configui.menu.custom.CustomMenuHandler;
import de.markusbordihn.easynpc.configui.menu.editor.EditorMenu;
import de.markusbordihn.easynpc.configui.menu.editor.EditorMenuHandler;
import de.markusbordihn.easynpc.data.action.ActionEventType;
import de.markusbordihn.easynpc.data.configuration.ConfigurationType;
import de.markusbordihn.easynpc.data.configuration.ConfigurationTypeHelper;
import de.markusbordihn.easynpc.data.screen.ScreenData;
import de.markusbordihn.easynpc.entity.easynpc.EasyNPC;
import java.util.UUID;
import net.minecraft.class_2487;
import net.minecraft.class_3222;
import net.minecraft.class_3908;
import net.minecraft.class_3917;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public interface MenuHandlerInterface {
    public static final Logger log = LogManager.getLogger((String)"Easy NPC: Config UI");

    default public void openConfigurationMenu(ConfigurationType configurationType, class_3222 serverPlayer, EasyNPC<?> easyNPC, int pageIndex) {
        if (!AccessManager.hasAccess((class_3222)serverPlayer, easyNPC)) {
            return;
        }
        ConfigurationType configurationTypeAlias = ConfigurationTypeHelper.resolveConfigurationTypeAlias((ConfigurationType)configurationType, easyNPC);
        class_3917<? extends ConfigurationMenu> menuType = this.getMenuTypeByConfigurationType(configurationTypeAlias);
        if (menuType == null) {
            log.error("Unknown configuration {} for {} from {}", (Object)configurationTypeAlias, easyNPC, (Object)serverPlayer);
            return;
        }
        ScreenData screenData = ConfigurationMenuHandler.getScreenData(configurationTypeAlias, easyNPC, serverPlayer, pageIndex);
        class_3908 menuProvider = ConfigurationMenuHandler.getMenuProvider(configurationTypeAlias, easyNPC, menuType, screenData);
        UUID npcUUID = easyNPC.getEntityUUID();
        MenuManager.openMenu(npcUUID, menuProvider, serverPlayer, screenData.encode());
    }

    default public void openEditorMenu(EditorType editorType, class_3222 serverPlayer, EasyNPC<?> easyNPC, UUID dialogId, UUID dialogButtonId, UUID actionDataEntryId, ActionEventType actionEventType, ConfigurationType configurationType, EditorType formerEditorType, int pageIndex) {
        if (!AccessManager.hasAccess((class_3222)serverPlayer, easyNPC)) {
            return;
        }
        class_2487 additionalSyncData = new class_2487();
        AdditionalScreenData.addActionEventType(additionalSyncData, actionEventType);
        AdditionalScreenData.addConfigurationType(additionalSyncData, configurationType);
        AdditionalScreenData.addEditorType(additionalSyncData, formerEditorType);
        this.openEditorMenu(editorType, serverPlayer, easyNPC, dialogId, dialogButtonId, actionDataEntryId, null, pageIndex, additionalSyncData);
    }

    default public void openEditorMenu(EditorType editorType, class_3222 serverPlayer, EasyNPC<?> easyNPC, UUID dialogId, int pageIndex) {
        this.openEditorMenu(editorType, serverPlayer, easyNPC, dialogId, null, null, null, pageIndex, new class_2487());
    }

    default public void openEditorMenu(EditorType editorType, class_3222 serverPlayer, EasyNPC<?> easyNPC, UUID dialogId, UUID dialogButtonId, int pageIndex) {
        this.openEditorMenu(editorType, serverPlayer, easyNPC, dialogId, dialogButtonId, null, null, pageIndex, new class_2487());
    }

    default public void openEditorMenu(EditorType editorType, class_3222 serverPlayer, EasyNPC<?> easyNPC, UUID dialogId, UUID dialogButtonId, UUID actionDataEntryId, UUID conditionDataEntryId, int pageIndex, class_2487 additionalSyncData) {
        if (!AccessManager.hasAccess((class_3222)serverPlayer, easyNPC)) {
            return;
        }
        class_3917<? extends EditorMenu> menuType = this.getMenuTypeByEditorType(editorType);
        if (menuType == null) {
            log.error("Unknown editor {} for {} from {}", (Object)editorType, easyNPC, (Object)serverPlayer);
            return;
        }
        ScreenData screenData = EditorMenuHandler.getScreenData(editorType, easyNPC, dialogId, dialogButtonId, actionDataEntryId, conditionDataEntryId, pageIndex, additionalSyncData);
        class_3908 menuProvider = EditorMenuHandler.getMenuProvider(editorType, easyNPC, menuType, screenData);
        UUID npcUUID = easyNPC.getEntityUUID();
        MenuManager.openMenu(npcUUID, menuProvider, serverPlayer, screenData.encode());
    }

    default public void openCustomMenu(CustomMenuType customMenuType, class_3222 serverPlayer) {
        class_3917<? extends ConfigUIMenu> menuType = this.getMenuTypeByCustomType(customMenuType);
        if (menuType == null) {
            log.error("Unable to get menu type for custom menu type: {}", (Object)customMenuType);
            return;
        }
        ScreenData screenData = CustomMenuHandler.getScreenData(customMenuType, serverPlayer);
        class_3908 menuProvider = CustomMenuHandler.getMenuProvider(customMenuType, menuType, screenData);
        if (menuProvider == null) {
            log.error("Unable to get menu provider for custom menu type: {}", (Object)customMenuType);
            return;
        }
        UUID npcUUID = screenData.uuid();
        MenuManager.openMenu(npcUUID, menuProvider, serverPlayer, screenData.encode());
    }

    public class_3917<? extends ConfigurationMenu> getMenuTypeByConfigurationType(ConfigurationType var1);

    public class_3917<? extends EditorMenu> getMenuTypeByEditorType(EditorType var1);

    public class_3917<? extends ConfigUIMenu> getMenuTypeByCustomType(CustomMenuType var1);
}

