/*
 * Decompiled with CFR 0.152.
 */
package de.markusbordihn.easynpc.configui.menu.configuration;

import de.markusbordihn.easynpc.configui.data.screen.AdditionalScreenData;
import de.markusbordihn.easynpc.configui.menu.configuration.ConfigurationMenu;
import de.markusbordihn.easynpc.configui.menu.configuration.equipment.EquipmentConfigurationMenu;
import de.markusbordihn.easynpc.configui.menu.configuration.trading.AdvancedTradingConfigurationMenu;
import de.markusbordihn.easynpc.configui.menu.configuration.trading.BasicTradingConfigurationMenu;
import de.markusbordihn.easynpc.data.configuration.ConfigurationType;
import de.markusbordihn.easynpc.data.screen.ScreenData;
import de.markusbordihn.easynpc.entity.easynpc.EasyNPC;
import de.markusbordihn.easynpc.io.CustomPresetDataFiles;
import de.markusbordihn.easynpc.io.DefaultPresetDataFiles;
import de.markusbordihn.easynpc.io.WorldPresetDataFiles;
import de.markusbordihn.easynpc.network.components.TextComponent;
import de.markusbordihn.easynpc.utils.CompoundTagUtils;
import java.util.Locale;
import java.util.Set;
import java.util.UUID;
import java.util.stream.Collectors;
import net.minecraft.class_1657;
import net.minecraft.class_1661;
import net.minecraft.class_1703;
import net.minecraft.class_2487;
import net.minecraft.class_2520;
import net.minecraft.class_2561;
import net.minecraft.class_3222;
import net.minecraft.class_3908;
import net.minecraft.class_3917;
import net.minecraft.server.MinecraftServer;

public class ConfigurationMenuHandler {
    public static class_3908 getMenuProvider(final ConfigurationType configurationType, EasyNPC<?> easyNPC, final class_3917<? extends ConfigurationMenu> menuType, final ScreenData screenData) {
        final class_2561 displayName = ConfigurationMenuHandler.getConfigurationTitle(configurationType, easyNPC);
        if (configurationType == ConfigurationType.EQUIPMENT) {
            return new class_3908(){

                public class_1703 createMenu(int containerId, class_1661 playerInventory, class_1657 player) {
                    return new EquipmentConfigurationMenu(menuType, containerId, playerInventory, screenData.encode());
                }

                public class_2561 method_5476() {
                    return displayName;
                }

                public String toString() {
                    return "EquipmentConfigurationMenu[" + String.valueOf(displayName) + "]";
                }
            };
        }
        if (configurationType == ConfigurationType.ADVANCED_TRADING) {
            return new class_3908(){

                public class_1703 createMenu(int containerId, class_1661 playerInventory, class_1657 player) {
                    return new AdvancedTradingConfigurationMenu(menuType, containerId, playerInventory, screenData.encode());
                }

                public class_2561 method_5476() {
                    return displayName;
                }

                public String toString() {
                    return "AdvancedTradingConfigurationMenu[" + String.valueOf(displayName) + "]";
                }
            };
        }
        if (configurationType == ConfigurationType.BASIC_TRADING) {
            return new class_3908(){

                public class_1703 createMenu(int containerId, class_1661 playerInventory, class_1657 player) {
                    return new BasicTradingConfigurationMenu(menuType, containerId, playerInventory, screenData.encode());
                }

                public class_2561 method_5476() {
                    return displayName;
                }

                public String toString() {
                    return "BasicTradingConfigurationMenu[" + String.valueOf(displayName) + "]";
                }
            };
        }
        return new class_3908(){

            public class_1703 createMenu(int containerId, class_1661 playerInventory, class_1657 player) {
                return new ConfigurationMenu(menuType, containerId, playerInventory, screenData.encode());
            }

            public class_2561 method_5476() {
                return displayName;
            }

            public String toString() {
                return "ConfigurationMenu." + String.valueOf(configurationType) + "[" + String.valueOf(displayName) + "]";
            }
        };
    }

    public static ScreenData getScreenData(ConfigurationType configurationType, EasyNPC<?> easyNPC, class_3222 serverPlayer, int pageIndex) {
        UUID npcUUID = easyNPC.getEntityUUID();
        class_2487 additionalSyncData = new class_2487();
        switch (configurationType) {
            case DEFAULT_PRESET_IMPORT: {
                Set defaultPresets = DefaultPresetDataFiles.getPresetResourceLocations((MinecraftServer)serverPlayer.method_5682()).collect(Collectors.toSet());
                additionalSyncData.method_10566("DefaultPresets", (class_2520)CompoundTagUtils.writeResourceLocations(defaultPresets));
                break;
            }
            case CUSTOM_PRESET_IMPORT: {
                CustomPresetDataFiles.refreshPresetResourceLocations();
                Set customPresets = CustomPresetDataFiles.getPresetResourceLocationSet();
                additionalSyncData.method_10566("CustomPresets", (class_2520)CompoundTagUtils.writeResourceLocations((Set)customPresets));
                break;
            }
            case WORLD_PRESET_IMPORT: {
                WorldPresetDataFiles.refreshPresetResourceLocations();
                Set worldPresets = WorldPresetDataFiles.getPresetResourceLocationSet();
                additionalSyncData.method_10566("WorldPresets", (class_2520)CompoundTagUtils.writeResourceLocations((Set)worldPresets));
                break;
            }
            case BASIC_ACTION: 
            case DIALOG_ACTION: 
            case DISTANCE_ACTION: {
                AdditionalScreenData.addActionEventSet(additionalSyncData, easyNPC);
                break;
            }
            case BASE_ATTRIBUTE: {
                AdditionalScreenData.addBaseAttributes(additionalSyncData, easyNPC);
                break;
            }
            case NONE_DIALOG: 
            case BASIC_DIALOG: 
            case YES_NO_DIALOG: 
            case ADVANCED_DIALOG: {
                AdditionalScreenData.addDialogDataSet(additionalSyncData, easyNPC);
                break;
            }
            case ATTACK_OBJECTIVE: 
            case BASIC_OBJECTIVE: 
            case FOLLOW_OBJECTIVE: 
            case LOOK_OBJECTIVE: {
                AdditionalScreenData.addObjectiveDataSet(additionalSyncData, easyNPC);
                break;
            }
        }
        return new ScreenData(npcUUID, null, null, null, null, pageIndex, additionalSyncData);
    }

    private static class_2561 getConfigurationTitle(ConfigurationType configurationType, EasyNPC<?> easyNPC) {
        return TextComponent.getTranslatedConfigText((String)(configurationType.name().toLowerCase(Locale.ROOT) + ".title"), (String)easyNPC.getEntity().method_5477().method_10858(16));
    }
}

