/*
 * Decompiled with CFR 0.152.
 */
package de.markusbordihn.easynpc.configui.menu.custom;

import de.markusbordihn.easynpc.configui.data.custom.CustomMenuType;
import de.markusbordihn.easynpc.configui.menu.preset.PresetBrowserMenu;
import de.markusbordihn.easynpc.data.preset.PresetMetadata;
import de.markusbordihn.easynpc.data.screen.ScreenData;
import de.markusbordihn.easynpc.io.CustomPresetDataFiles;
import de.markusbordihn.easynpc.io.DataPresetDataFiles;
import de.markusbordihn.easynpc.io.WorldPresetDataFiles;
import de.markusbordihn.easynpc.network.components.TextComponent;
import de.markusbordihn.easynpc.utils.CompoundTagUtils;
import java.util.Set;
import java.util.UUID;
import java.util.stream.Collectors;
import net.minecraft.class_1657;
import net.minecraft.class_1661;
import net.minecraft.class_1703;
import net.minecraft.class_2487;
import net.minecraft.class_2520;
import net.minecraft.class_2561;
import net.minecraft.class_2960;
import net.minecraft.class_3222;
import net.minecraft.class_3908;
import net.minecraft.class_3917;
import net.minecraft.server.MinecraftServer;

public class CustomMenuHandler {
    private CustomMenuHandler() {
    }

    public static ScreenData getScreenData(CustomMenuType customMenuType, class_3222 serverPlayer) {
        class_2487 additionalData = new class_2487();
        if (customMenuType == CustomMenuType.PRESET_BROWSER) {
            WorldPresetDataFiles.refreshPresetResourceLocations();
            Set worldPresets = WorldPresetDataFiles.getPresetResourceLocationSet();
            additionalData.method_10566("WorldPresets", (class_2520)CompoundTagUtils.writeResourceLocations((Set)worldPresets));
            class_2487 worldMetadata = new class_2487();
            for (class_2960 preset : worldPresets) {
                PresetMetadata metadata = WorldPresetDataFiles.getPresetMetadata((class_2960)preset);
                worldMetadata.method_10566(preset.toString(), (class_2520)metadata.toCompoundTag());
            }
            additionalData.method_10566("WorldPresetsMetadata", (class_2520)worldMetadata);
            CustomPresetDataFiles.refreshPresetResourceLocations();
            Set customPresets = CustomPresetDataFiles.getPresetResourceLocationSet();
            additionalData.method_10566("CustomPresets", (class_2520)CompoundTagUtils.writeResourceLocations((Set)customPresets));
            class_2487 customMetadata = new class_2487();
            for (class_2960 preset : customPresets) {
                PresetMetadata metadata = CustomPresetDataFiles.getPresetMetadata((class_2960)preset);
                customMetadata.method_10566(preset.toString(), (class_2520)metadata.toCompoundTag());
            }
            additionalData.method_10566("CustomPresetsMetadata", (class_2520)customMetadata);
            Set dataPresets = DataPresetDataFiles.getPresetResourceLocations((MinecraftServer)serverPlayer.method_5682()).collect(Collectors.toSet());
            additionalData.method_10566("DataPresets", (class_2520)CompoundTagUtils.writeResourceLocations(dataPresets));
            class_2487 dataMetadata = new class_2487();
            for (class_2960 preset : dataPresets) {
                PresetMetadata metadata = DataPresetDataFiles.getPresetMetadata((MinecraftServer)serverPlayer.method_5682(), (class_2960)preset);
                dataMetadata.method_10566(preset.toString(), (class_2520)metadata.toCompoundTag());
            }
            additionalData.method_10566("DataPresetsMetadata", (class_2520)dataMetadata);
        }
        return new ScreenData(UUID.randomUUID(), null, null, null, null, 0, additionalData);
    }

    public static class_3908 getMenuProvider(CustomMenuType customMenuType, final class_3917<?> menuType, final ScreenData screenData) {
        final class_2561 displayName = CustomMenuHandler.getCustomMenuTitle(customMenuType);
        if (customMenuType == CustomMenuType.PRESET_BROWSER) {
            return new class_3908(){

                public class_1703 createMenu(int containerId, class_1661 playerInventory, class_1657 player) {
                    return new PresetBrowserMenu(menuType, containerId, playerInventory, screenData.encode());
                }

                public class_2561 method_5476() {
                    return displayName;
                }
            };
        }
        return null;
    }

    private static class_2561 getCustomMenuTitle(CustomMenuType customMenuType) {
        return TextComponent.getTranslatedConfigText((String)(customMenuType.getName() + ".title"));
    }
}

