/*
 * Decompiled with CFR 0.152.
 */
package de.markusbordihn.easynpc.configui.network.message.client;

import de.markusbordihn.easynpc.data.preset.PresetExportFormat;
import de.markusbordihn.easynpc.data.skin.SkinModel;
import de.markusbordihn.easynpc.io.CustomPresetDataFiles;
import de.markusbordihn.easynpc.io.PresetFileHandler;
import de.markusbordihn.easynpc.network.message.NetworkMessageRecord;
import java.io.File;
import java.util.UUID;
import net.minecraft.class_2487;
import net.minecraft.class_2520;
import net.minecraft.class_2540;
import net.minecraft.class_2960;
import net.minecraft.class_8710;
import net.minecraft.class_9129;
import net.minecraft.class_9139;

public record ExportClientPresetMessage(UUID uuid, String name, SkinModel skinModel, String fileName, class_2487 data, PresetExportFormat exportFormat) implements NetworkMessageRecord
{
    public static final class_2960 MESSAGE_ID = class_2960.method_60655((String)"easy_npc_config_ui", (String)"preset_export_client");
    public static final class_8710.class_9154<ExportClientPresetMessage> PAYLOAD_TYPE = new class_8710.class_9154(MESSAGE_ID);
    public static final class_9139<class_9129, ExportClientPresetMessage> STREAM_CODEC = class_9139.method_56437((buffer, message) -> message.write((class_2540)buffer), ExportClientPresetMessage::create);

    public static ExportClientPresetMessage create(class_2540 buffer) {
        return new ExportClientPresetMessage(buffer.method_10790(), buffer.method_19772(), (SkinModel)buffer.method_10818(SkinModel.class), buffer.method_19772(), buffer.method_10798(), (PresetExportFormat)buffer.method_10818(PresetExportFormat.class));
    }

    public void write(class_2540 buffer) {
        buffer.method_10797(this.uuid);
        buffer.method_10814(this.name);
        buffer.method_10817((Enum)this.skinModel);
        buffer.method_10814(this.fileName);
        buffer.method_10794((class_2520)this.data);
        buffer.method_10817((Enum)this.exportFormat);
    }

    public class_2960 id() {
        return MESSAGE_ID;
    }

    public class_8710.class_9154<ExportClientPresetMessage> method_56479() {
        return PAYLOAD_TYPE;
    }

    public void handleClient() {
        if (this.uuid == null || this.uuid.toString().isEmpty() || this.name == null || this.name.isEmpty() || this.skinModel == null || this.data == null || this.fileName == null || this.fileName.isEmpty()) {
            log.error("Invalid preset export data: {}", (Object)this);
            return;
        }
        File presetFile = CustomPresetDataFiles.getPresetFile((SkinModel)this.skinModel, (String)(this.fileName + this.exportFormat.getFileExtension()));
        if (presetFile == null) {
            log.error("Failed to get preset file for {}", (Object)this);
            return;
        }
        log.info("Exporting EasyNPC {} with UUID {} and skin {} to {} (Format: {})", (Object)this.name, (Object)this.uuid, (Object)this.skinModel, (Object)presetFile, (Object)this.exportFormat);
        if (!PresetFileHandler.save((File)presetFile, (class_2487)this.data)) {
            log.error("Failed to export EasyNPC {} with UUID {} and skin {} to {}", (Object)this.name, (Object)this.uuid, (Object)this.skinModel, (Object)presetFile);
        }
    }
}

