/*
 * Decompiled with CFR 0.152.
 */
package de.markusbordihn.easynpc.configui.network.message.server;

import de.markusbordihn.easynpc.data.preset.PresetData;
import de.markusbordihn.easynpc.data.preset.PresetType;
import de.markusbordihn.easynpc.handler.PresetHandler;
import de.markusbordihn.easynpc.network.message.NetworkMessageRecord;
import java.util.UUID;
import net.minecraft.class_243;
import net.minecraft.class_2487;
import net.minecraft.class_2520;
import net.minecraft.class_2540;
import net.minecraft.class_2960;
import net.minecraft.class_3218;
import net.minecraft.class_3222;
import net.minecraft.class_8710;
import net.minecraft.class_9129;
import net.minecraft.class_9139;

public record SpawnPresetMessage(PresetType presetType, class_2960 resourceLocation, boolean useOriginalData, class_2487 presetData) implements NetworkMessageRecord
{
    public static final class_2960 MESSAGE_ID = class_2960.method_60655((String)"easy_npc_config_ui", (String)"spawn_preset");
    public static final class_8710.class_9154<SpawnPresetMessage> PAYLOAD_TYPE = new class_8710.class_9154(MESSAGE_ID);
    public static final class_9139<class_9129, SpawnPresetMessage> STREAM_CODEC = class_9139.method_56437((buffer, message) -> message.write((class_2540)buffer), SpawnPresetMessage::create);

    public SpawnPresetMessage(PresetType presetType, class_2960 resourceLocation, boolean useOriginalData) {
        this(presetType, resourceLocation, useOriginalData, null);
    }

    public static SpawnPresetMessage create(class_2540 buffer) {
        PresetType presetType = (PresetType)buffer.method_10818(PresetType.class);
        class_2960 resourceLocation = buffer.method_10810();
        boolean useOriginalData = buffer.readBoolean();
        boolean hasPresetData = buffer.readBoolean();
        class_2487 presetData = hasPresetData ? buffer.method_10798() : null;
        return new SpawnPresetMessage(presetType, resourceLocation, useOriginalData, presetData);
    }

    public void write(class_2540 buffer) {
        buffer.method_10817((Enum)this.presetType);
        buffer.method_10812(this.resourceLocation);
        buffer.method_52964(this.useOriginalData);
        buffer.method_52964(this.presetData != null);
        if (this.presetData != null) {
            buffer.method_10794((class_2520)this.presetData);
        }
    }

    public class_2960 id() {
        return MESSAGE_ID;
    }

    public class_8710.class_9154<? extends class_8710> method_56479() {
        return PAYLOAD_TYPE;
    }

    public void handleServer(class_3222 serverPlayer) {
        boolean success;
        class_243 position;
        class_243 playerLook = serverPlayer.method_5720();
        class_243 spawnPos = serverPlayer.method_19538().method_1031(playerLook.field_1352 * 3.0, 0.0, playerLook.field_1350 * 3.0);
        UUID uuid = this.useOriginalData ? null : UUID.randomUUID();
        class_243 class_2432 = position = this.useOriginalData ? null : spawnPos;
        if (this.presetData != null) {
            PresetData presetDataObj = PresetData.fromCompoundTag((class_2960)this.resourceLocation, (PresetType)this.presetType, (class_2487)this.presetData);
            if (presetDataObj != null && presetDataObj.hasValidData()) {
                success = PresetHandler.importPreset((class_3218)serverPlayer.method_51469(), (PresetData)presetDataObj, (class_243)position, (UUID)uuid, (class_3222)serverPlayer);
            } else {
                log.error("Invalid preset data for {}", (Object)this.resourceLocation);
                success = false;
            }
        } else {
            success = PresetHandler.importPreset((class_3218)serverPlayer.method_51469(), (PresetType)this.presetType, (class_2960)this.resourceLocation, (class_243)position, (UUID)uuid, (class_3222)serverPlayer);
        }
        if (!success) {
            log.error("Failed to spawn preset {} for player {}", (Object)this.resourceLocation, (Object)serverPlayer.method_5477().getString());
        }
    }
}

