/*
 * Decompiled with CFR 0.152.
 */
package de.markusbordihn.easynpc.configui.validator;

import java.awt.image.BufferedImage;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.net.URL;
import javax.imageio.IIOException;
import javax.imageio.ImageIO;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public class RemoteImageValidator {
    protected static final Logger log = LogManager.getLogger((String)"Easy NPC: Core");

    private RemoteImageValidator() {
    }

    public static boolean isValidImage(URL remoteUrl) {
        BufferedImage image;
        if (remoteUrl.toString().endsWith(".webp")) {
            log.error("WebP images are not supported, please use PNG images!");
            return false;
        }
        try {
            image = ImageIO.read(remoteUrl);
        }
        catch (IIOException iioException) {
            log.error("Unable to download image from URL {}: {}", (Object)remoteUrl, (Object)iioException.getMessage());
            return false;
        }
        catch (FileNotFoundException fileNotFoundException) {
            log.error("Image not found at URL {}: {}", (Object)remoteUrl, (Object)fileNotFoundException.getMessage());
            return false;
        }
        catch (IOException | IllegalArgumentException exception) {
            log.error("Unable to get any valid image from URL {}: {}", (Object)remoteUrl, (Object)exception.getMessage());
            return false;
        }
        catch (Exception exception) {
            log.error("Unexpected error loading image from URL {}: {}", (Object)remoteUrl, (Object)exception.getMessage());
            return false;
        }
        if (image == null) {
            log.error("Unable to get any valid image from URL {}!", (Object)remoteUrl);
            return false;
        }
        return RemoteImageValidator.isValidImageSize(image);
    }

    private static boolean isValidImageSize(BufferedImage image) {
        if (image == null) {
            return false;
        }
        if (image.getWidth() == 48 && image.getHeight() == 32) {
            return true;
        }
        if (image.getWidth() < 32 || image.getHeight() < 32 || image.getWidth() % 32 != 0 || image.getHeight() % 32 != 0) {
            log.error("Invalid image size {}x{}, must be at least 32x32 and multiple of 32!", (Object)image.getWidth(), (Object)image.getHeight());
            return false;
        }
        return true;
    }
}

