/*
 * Decompiled with CFR 0.152.
 */
package com.lunazstudios.cobblefurnies.block.entity;

import com.cobblemon.mod.common.CobblemonRecipeTypes;
import com.cobblemon.mod.common.item.components.PotComponent;
import com.cobblemon.mod.common.item.crafting.CookingPotRecipeBase;
import com.lunazstudios.cobblefurnies.block.StoveBlock;
import com.lunazstudios.cobblefurnies.menu.StoveMenu;
import com.lunazstudios.cobblefurnies.registry.CFBlockEntityTypes;
import com.mojang.serialization.DynamicOps;
import java.util.List;
import java.util.Optional;
import net.minecraft.class_1262;
import net.minecraft.class_1661;
import net.minecraft.class_1662;
import net.minecraft.class_1703;
import net.minecraft.class_1732;
import net.minecraft.class_1737;
import net.minecraft.class_1792;
import net.minecraft.class_1799;
import net.minecraft.class_1935;
import net.minecraft.class_1937;
import net.minecraft.class_2338;
import net.minecraft.class_2371;
import net.minecraft.class_2487;
import net.minecraft.class_2509;
import net.minecraft.class_2561;
import net.minecraft.class_2624;
import net.minecraft.class_2680;
import net.minecraft.class_2769;
import net.minecraft.class_3913;
import net.minecraft.class_3956;
import net.minecraft.class_7225;
import net.minecraft.class_8566;
import net.minecraft.class_8786;
import net.minecraft.class_9694;
import net.minecraft.class_9695;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class StoveBlockEntity
extends class_2624
implements class_8566,
class_1732,
class_1737 {
    public static final int RESULT_SLOT = 0;
    public static final int[] CRAFTING_SLOTS = new int[]{1, 2, 3, 4, 5, 6, 7, 8, 9};
    public static final int[] SEASONING_SLOTS = new int[]{10, 11, 12};
    public static final int PREVIEW_SLOT = 13;
    public static final int TOTAL_SLOTS = 14;
    private final class_2371<class_1799> items = class_2371.method_10213((int)14, (Object)class_1799.field_8037);
    private PotComponent potComponent;
    private int cookingProgress = 0;
    private int cookingTotalTime = 200;
    private boolean isLidOpen = true;
    private final class_3913 dataAccess = new class_3913(){

        public int method_17390(int index) {
            return switch (index) {
                case 0 -> StoveBlockEntity.this.cookingProgress;
                case 1 -> StoveBlockEntity.this.cookingTotalTime;
                case 2 -> {
                    if (StoveBlockEntity.this.field_11863 != null && ((Boolean)StoveBlockEntity.this.method_11010().method_11654((class_2769)StoveBlock.LID)).booleanValue()) {
                        yield 0;
                    }
                    yield 1;
                }
                case 3 -> 0;
                default -> 0;
            };
        }

        public void method_17391(int index, int value) {
            switch (index) {
                case 0: {
                    StoveBlockEntity.this.cookingProgress = value;
                    break;
                }
                case 1: {
                    StoveBlockEntity.this.cookingTotalTime = value;
                    break;
                }
                case 2: {
                    StoveBlockEntity.this.toggleLid(value == 1);
                }
            }
        }

        public int method_17389() {
            return 4;
        }
    };

    public void toggleLid(boolean isOpen) {
        if (this.field_11863 == null) {
            return;
        }
        class_2680 state = this.method_11010();
        class_2680 newState = (class_2680)state.method_11657((class_2769)StoveBlock.LID, (Comparable)Boolean.valueOf(!isOpen));
        this.field_11863.method_8652(this.field_11867, newState, 3);
        this.method_5431();
    }

    public StoveBlockEntity(class_2338 pos, class_2680 state) {
        super(CFBlockEntityTypes.STOVE.get(), pos, state);
    }

    @NotNull
    public class_2561 method_17823() {
        return class_2561.method_43471((String)"container.cobblefurnies.stove");
    }

    @NotNull
    public class_2561 method_5476() {
        return this.method_17823();
    }

    public int method_17398() {
        return 3;
    }

    public int method_17397() {
        return 3;
    }

    @NotNull
    public class_2371<class_1799> method_11282() {
        return this.items;
    }

    protected void method_11281(class_2371<class_1799> newItems) {
        this.items.clear();
        this.items.addAll(newItems);
    }

    public int method_5439() {
        return 14;
    }

    @NotNull
    protected class_1703 method_5465(int containerId, class_1661 inventory) {
        return new StoveMenu(containerId, inventory, this, this.dataAccess);
    }

    public void method_7662(@Nullable class_8786<?> recipe) {
    }

    @Nullable
    public class_8786<?> method_7663() {
        return null;
    }

    public void method_7683(class_1662 stackedContents) {
        for (class_1799 itemStack : this.items) {
            stackedContents.method_7404(itemStack);
        }
    }

    public static void serverTick(class_1937 level, class_2338 pos, class_2680 state, StoveBlockEntity stove) {
        if (level.field_9236) {
            return;
        }
        class_9694 input = class_9694.method_59986((int)3, (int)3, (List)stove.items.subList(1, 10));
        Optional<class_8786<CookingPotRecipeBase>> recipeOpt = StoveBlockEntity.fetchRecipe(level, input, (class_3956<? extends CookingPotRecipeBase>)CobblemonRecipeTypes.INSTANCE.getCOOKING_POT_COOKING());
        if (recipeOpt.isEmpty()) {
            recipeOpt = StoveBlockEntity.fetchRecipe(level, input, (class_3956<? extends CookingPotRecipeBase>)CobblemonRecipeTypes.INSTANCE.getCOOKING_POT_SHAPELESS());
        }
        if (recipeOpt.isEmpty()) {
            stove.cookingProgress = 0;
            stove.method_5447(13, class_1799.field_8037);
            return;
        }
        class_8786<CookingPotRecipeBase> recipeHolder = recipeOpt.get();
        CookingPotRecipeBase recipe = (CookingPotRecipeBase)recipeHolder.comp_1933();
        class_1799 result = recipe.assemble(input, (class_7225.class_7874)level.method_30349());
        List<class_1799> validSeasonings = stove.getSeasonings().stream().filter(stack -> stack.method_31573(recipe.getSeasoningTag())).toList();
        recipe.applySeasoning(result, validSeasonings);
        stove.method_5447(13, result);
        class_1799 resultSlot = stove.method_5438(0);
        boolean lidClosed = (Boolean)state.method_11654((class_2769)StoveBlock.LID);
        if (!(lidClosed && (resultSlot.method_7960() || class_1799.method_31577((class_1799)resultSlot, (class_1799)result) && resultSlot.method_7947() < resultSlot.method_7914()))) {
            stove.cookingProgress = 0;
            return;
        }
        stove.cookingProgress += 2;
        if (stove.cookingProgress >= stove.cookingTotalTime) {
            stove.cookingProgress = 0;
            stove.method_7662(recipeHolder);
            if (resultSlot.method_7960()) {
                stove.method_5447(0, result.method_7972());
            } else {
                resultSlot.method_7933(result.method_7947());
            }
            stove.consumeIngredients(recipe);
            StoveBlockEntity.method_31663((class_1937)level, (class_2338)pos, (class_2680)state);
        }
    }

    public void handleSafeDrop() {
        if (this.cookingProgress > 0) {
            class_1799 result = this.method_5438(0);
            class_1799 preview = this.method_5438(13);
            if (!preview.method_7960() && (result.method_7960() || class_1799.method_31577((class_1799)preview, (class_1799)result))) {
                this.method_5447(13, class_1799.field_8037);
            }
        }
    }

    private static Optional<class_8786<CookingPotRecipeBase>> fetchRecipe(class_1937 level, class_9694 input, class_3956<? extends CookingPotRecipeBase> type) {
        return level.method_8433().method_8132(type, (class_9695)input, level).map(r -> r);
    }

    private void consumeIngredients(CookingPotRecipeBase recipe) {
        for (int slot : CRAFTING_SLOTS) {
            this.consumeItem(slot);
        }
        for (int slot : SEASONING_SLOTS) {
            class_1799 seasoningStack = this.method_5438(slot);
            if (seasoningStack.method_7960() || !seasoningStack.method_31573(recipe.getSeasoningTag()) || !recipe.getSeasoningProcessors().stream().anyMatch(p -> p.consumesItem(seasoningStack))) continue;
            this.consumeItem(slot);
        }
    }

    private void consumeItem(int slot) {
        class_1799 stack = this.method_5438(slot);
        if (!stack.method_7960()) {
            if (stack.method_7909().method_7857()) {
                class_1792 remainderItem = stack.method_7909().method_7858();
                stack.method_7934(1);
                if (stack.method_7960() && remainderItem != null) {
                    this.method_5447(slot, new class_1799((class_1935)remainderItem));
                }
            } else {
                stack.method_7934(1);
                if (stack.method_7960()) {
                    this.method_5447(slot, class_1799.field_8037);
                }
            }
        }
    }

    public List<class_1799> getSeasonings() {
        return this.items.subList(10, 13).stream().filter(stack -> !stack.method_7960()).toList();
    }

    public void setPotItem(@Nullable class_1799 stack) {
        this.potComponent = stack != null && !stack.method_7960() ? new PotComponent(stack) : null;
        this.method_5431();
        if (this.field_11863 != null) {
            this.field_11863.method_8413(this.field_11867, this.method_11010(), this.method_11010(), 2);
        }
    }

    public class_1799 getPotItem() {
        return this.potComponent != null ? this.potComponent.getPotItem() : class_1799.field_8037;
    }

    protected void method_11007(class_2487 tag, class_7225.class_7874 registries) {
        super.method_11007(tag, registries);
        tag.method_10569("CookingProgress", this.cookingProgress);
        tag.method_10556("IsLidOpen", this.isLidOpen);
        class_1262.method_5426((class_2487)tag, this.items, (class_7225.class_7874)registries);
        if (this.potComponent != null) {
            PotComponent.Companion.getCODEC().encodeStart((DynamicOps)class_2509.field_11560, (Object)this.potComponent).result().ifPresent(potTag -> tag.method_10566("PotComponent", potTag));
        }
    }

    protected void method_11014(class_2487 tag, class_7225.class_7874 registries) {
        super.method_11014(tag, registries);
        this.cookingProgress = tag.method_10550("CookingProgress");
        this.isLidOpen = tag.method_10577("IsLidOpen");
        this.items.clear();
        for (int i = 0; i < 14; ++i) {
            this.items.add((Object)class_1799.field_8037);
        }
        class_1262.method_5429((class_2487)tag, this.items, (class_7225.class_7874)registries);
        if (tag.method_10545("PotComponent")) {
            PotComponent.Companion.getCODEC().parse((DynamicOps)class_2509.field_11560, (Object)tag.method_10580("PotComponent")).result().ifPresent(component -> {
                this.potComponent = component;
            });
        }
    }
}

