/*
 * Decompiled with CFR 0.152.
 */
package com.lunazstudios.cobblefurnies.client.bbmodel;

import com.google.gson.JsonArray;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.JsonParser;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.Reader;
import java.util.ArrayList;
import java.util.Comparator;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import net.minecraft.class_2960;
import net.minecraft.class_310;
import net.minecraft.class_3298;
import org.joml.Vector3f;

public class BBModel {
    public int texW = 64;
    public int texH = 64;
    public Map<String, Group> groups = new HashMap<String, Group>();
    public List<Group> roots = new ArrayList<Group>();
    public Map<String, AnimationClip> clips = new HashMap<String, AnimationClip>();

    /*
     * Enabled aggressive exception aggregation
     */
    public static BBModel load(class_2960 rl) {
        try (InputStream stream = ((class_3298)class_310.method_1551().method_1478().method_14486(rl).get()).method_14482();){
            BBModel bBModel;
            try (InputStreamReader reader = new InputStreamReader(stream);){
                JsonObject root = JsonParser.parseReader((Reader)reader).getAsJsonObject();
                BBModel m = new BBModel();
                if (root.has("model")) {
                    JsonObject model = root.getAsJsonObject("model");
                    if (model.has("texture")) {
                        JsonArray t = model.getAsJsonArray("texture");
                        m.texW = t.get(0).getAsInt();
                        m.texH = t.get(1).getAsInt();
                    }
                    JsonObject gr = model.getAsJsonObject("groups");
                    for (Map.Entry e : gr.entrySet()) {
                        String name = (String)e.getKey();
                        JsonObject gObj = ((JsonElement)e.getValue()).getAsJsonObject();
                        Group g = new Group();
                        g.name = name;
                        if (gObj.has("origin")) {
                            JsonArray a = gObj.getAsJsonArray("origin");
                            g.origin.set(a.get(0).getAsFloat(), a.get(1).getAsFloat(), a.get(2).getAsFloat());
                        }
                        if (gObj.has("parent")) {
                            g.parent = gObj.get("parent").getAsString();
                        }
                        if (gObj.has("rotate")) {
                            JsonArray r = gObj.getAsJsonArray("rotate");
                            g.rotateDeg.set(r.get(0).getAsFloat(), r.get(1).getAsFloat(), r.get(2).getAsFloat());
                        }
                        if (gObj.has("cubes")) {
                            JsonArray arr = gObj.getAsJsonArray("cubes");
                            for (JsonElement ce : arr) {
                                JsonArray a;
                                JsonObject cObj = ce.getAsJsonObject();
                                Cube c = new Cube();
                                if (cObj.has("origin")) {
                                    a = cObj.getAsJsonArray("origin");
                                    c.origin.set(a.get(0).getAsFloat(), a.get(1).getAsFloat(), a.get(2).getAsFloat());
                                }
                                if (cObj.has("from")) {
                                    a = cObj.getAsJsonArray("from");
                                    c.from.set(a.get(0).getAsFloat(), a.get(1).getAsFloat(), a.get(2).getAsFloat());
                                }
                                if (cObj.has("size")) {
                                    a = cObj.getAsJsonArray("size");
                                    c.size.set(a.get(0).getAsFloat(), a.get(1).getAsFloat(), a.get(2).getAsFloat());
                                }
                                if (cObj.has("offset")) {
                                    c.offset = cObj.get("offset").getAsFloat();
                                }
                                if (cObj.has("rotate")) {
                                    JsonArray r = cObj.getAsJsonArray("rotate");
                                    c.rotateDeg.set(r.get(0).getAsFloat(), r.get(1).getAsFloat(), r.get(2).getAsFloat());
                                }
                                if (cObj.has("uvs")) {
                                    JsonObject u = cObj.getAsJsonObject("uvs");
                                    for (String face : List.of("front", "back", "right", "left", "bottom", "top")) {
                                        if (!u.has(face)) continue;
                                        JsonArray r = u.getAsJsonArray(face);
                                        UVRect uv = new UVRect();
                                        uv.u1 = r.get(0).getAsInt();
                                        uv.v1 = r.get(1).getAsInt();
                                        uv.u2 = r.get(2).getAsInt();
                                        uv.v2 = r.get(3).getAsInt();
                                        c.faceUV.put(face, uv);
                                    }
                                }
                                g.cubes.add(c);
                            }
                        }
                        m.groups.put(name, g);
                    }
                    for (Group g : m.groups.values()) {
                        if (g.parent == null || !m.groups.containsKey(g.parent)) continue;
                        m.groups.get((Object)g.parent).children.add(g);
                    }
                    for (Group g : m.groups.values()) {
                        if (g.parent != null) continue;
                        m.roots.add(g);
                    }
                }
                if (root.has("animations")) {
                    JsonObject anims = root.getAsJsonObject("animations");
                    for (Map.Entry e : anims.entrySet()) {
                        String clipName = (String)e.getKey();
                        JsonObject aObj = ((JsonElement)e.getValue()).getAsJsonObject();
                        AnimationClip clip = new AnimationClip();
                        clip.name = clipName;
                        if (aObj.has("duration")) {
                            clip.durationSec = aObj.get("duration").getAsFloat();
                        }
                        if (aObj.has("groups")) {
                            JsonObject gmap = aObj.getAsJsonObject("groups");
                            for (Map.Entry ge : gmap.entrySet()) {
                                Object k2;
                                JsonArray row;
                                String gname = (String)ge.getKey();
                                JsonObject gDef = ((JsonElement)ge.getValue()).getAsJsonObject();
                                AnimTrack track = new AnimTrack();
                                track.group = gname;
                                if (gDef.has("translate")) {
                                    JsonArray tarr = gDef.getAsJsonArray("translate");
                                    for (JsonElement te : tarr) {
                                        row = te.getAsJsonArray();
                                        k2 = new TranslateKey();
                                        ((TranslateKey)k2).time = row.get(0).getAsFloat();
                                        ((TranslateKey)k2).interp = row.get(1).getAsString();
                                        ((TranslateKey)k2).value = new Vector3f(row.get(2).getAsFloat(), row.get(3).getAsFloat(), row.get(4).getAsFloat());
                                        track.translate.add((TranslateKey)k2);
                                    }
                                    track.translate.sort(Comparator.comparingDouble(k -> k.time));
                                }
                                if (gDef.has("rotate")) {
                                    JsonArray rarr = gDef.getAsJsonArray("rotate");
                                    for (JsonElement re : rarr) {
                                        row = re.getAsJsonArray();
                                        k2 = new RotateKey();
                                        ((RotateKey)k2).time = row.get(0).getAsFloat();
                                        ((RotateKey)k2).interp = row.get(1).getAsString();
                                        ((RotateKey)k2).value = new Vector3f(row.get(2).getAsFloat(), row.get(3).getAsFloat(), row.get(4).getAsFloat());
                                        track.rotate.add((RotateKey)k2);
                                    }
                                    track.rotate.sort(Comparator.comparingDouble(k -> k.time));
                                }
                                clip.tracks.put(gname, track);
                            }
                        }
                        m.clips.put(clipName, clip);
                    }
                }
                bBModel = m;
            }
            return bBModel;
        }
        catch (Exception ex) {
            throw new RuntimeException("Failed to load BBModel: " + String.valueOf(rl) + " -> " + String.valueOf(ex), ex);
        }
    }

    public static class Group {
        public String name;
        public String parent;
        public Vector3f origin = new Vector3f();
        public List<Cube> cubes = new ArrayList<Cube>();
        public List<Group> children = new ArrayList<Group>();
        public Vector3f rotateDeg = new Vector3f();
    }

    public static class Cube {
        public Vector3f from = new Vector3f();
        public Vector3f size = new Vector3f();
        public Map<String, UVRect> faceUV = new HashMap<String, UVRect>();
        public Vector3f origin = new Vector3f();
        public float offset = 0.0f;
        public Vector3f rotateDeg = new Vector3f();
    }

    public static class UVRect {
        public int u1;
        public int v1;
        public int u2;
        public int v2;
    }

    public static class AnimationClip {
        public String name;
        public float durationSec = 0.0f;
        public Map<String, AnimTrack> tracks = new HashMap<String, AnimTrack>();
    }

    public static class AnimTrack {
        public String group;
        public List<TranslateKey> translate = new ArrayList<TranslateKey>();
        public List<RotateKey> rotate = new ArrayList<RotateKey>();
    }

    public static class TranslateKey {
        public float time;
        public String interp;
        public Vector3f value;
    }

    public static class RotateKey {
        public float time;
        public String interp;
        public Vector3f value;
    }
}

