/*
 * Decompiled with CFR 0.152.
 */
package com.lunazstudios.cobblefurnies.client.screen;

import com.lunazstudios.cobblefurnies.client.screen.ClientFurnicrafterRecipeIngredientTooltip;
import com.lunazstudios.cobblefurnies.client.screen.ClientFurnicrafterRecipeTooltip;
import com.lunazstudios.cobblefurnies.menu.FurniCrafterMenu;
import com.lunazstudios.cobblefurnies.mixin.client.GuiGraphicsInvoker;
import com.lunazstudios.cobblefurnies.network.message.CraftRecipeMessage;
import com.lunazstudios.cobblefurnies.recipe.CountedIngredient;
import com.lunazstudios.cobblefurnies.recipe.FurniCraftingRecipe;
import dev.architectury.networking.NetworkManager;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import net.minecraft.class_1109;
import net.minecraft.class_1113;
import net.minecraft.class_124;
import net.minecraft.class_1661;
import net.minecraft.class_1703;
import net.minecraft.class_2561;
import net.minecraft.class_2960;
import net.minecraft.class_310;
import net.minecraft.class_332;
import net.minecraft.class_3417;
import net.minecraft.class_3532;
import net.minecraft.class_437;
import net.minecraft.class_465;
import net.minecraft.class_5683;
import net.minecraft.class_5684;
import net.minecraft.class_6880;
import net.minecraft.class_8001;
import net.minecraft.class_8710;
import net.minecraft.class_8786;

public class FurniCrafterScreen
extends class_465<FurniCrafterMenu> {
    public static final class_2960 TEXTURE = class_2960.method_60655((String)"cobblefurnies", (String)"textures/gui/container/furnicrafter.png");
    private static final int RECIPES_PER_ROW = 6;
    private static final int BUTTON_SIZE = 20;
    private static final int GRID_X_OFFSET = 7;
    private static final int GRID_Y_OFFSET = 18;
    private static final int WINDOW_WIDTH = 120;
    private static final int WINDOW_HEIGHT = 88;
    private static final int SCROLL_SPEED = 10;
    private static final int SCROLLBAR_HEIGHT = 15;
    private static final int SCROLLBAR_AREA = 88;
    private static final int SCROLLBAR_TEXTURE_ENABLED_X = 176;
    private static final int SCROLLBAR_TEXTURE_DISABLED_X = 188;
    private static final int SCROLLBAR_TEXTURE_Y = 40;
    private static final int Y_OFFSET_CORRECTION = 0;
    private List<FurniCraftingRecipe> recipes = new ArrayList<FurniCraftingRecipe>();
    private double scroll = 0.0;
    private int hoveredRecipeIndex = -1;
    private int clickedY = -1;
    private int scrollbarDragOffset = 0;

    public FurniCrafterScreen(FurniCrafterMenu menu, class_1661 inventory, class_2561 title) {
        super((class_1703)menu, inventory, title);
        this.field_2792 = 176;
        this.field_2779 = 204;
        this.field_25270 = 110;
        this.updateRecipes();
    }

    private void updateRecipes() {
        this.recipes = ((FurniCrafterMenu)this.field_2797).getAvailableRecipes().stream().map(class_8786::comp_1933).toList();
    }

    public void method_25394(class_332 graphics, int mouseX, int mouseY, float partialTick) {
        super.method_25394(graphics, mouseX, mouseY, partialTick);
        this.method_2380(graphics, mouseX, mouseY);
        if (this.hoveredRecipeIndex != -1 && this.isMouseWithinBounds(mouseX, mouseY, this.field_2776 + 7, this.field_2800 + 18, 120, 88)) {
            this.renderRecipeTooltip(graphics, mouseX, mouseY, this.hoveredRecipeIndex);
        }
    }

    private void renderRecipeTooltip(class_332 graphics, int mouseX, int mouseY, int recipeIndex) {
        class_8786<FurniCraftingRecipe> holder = ((FurniCrafterMenu)this.field_2797).getAvailableRecipes().get(recipeIndex);
        FurniCraftingRecipe recipe = (FurniCraftingRecipe)holder.comp_1933();
        ArrayList<class_5684> components = new ArrayList<class_5684>();
        components.add((class_5684)new class_5683(recipe.method_8110(null).method_7964().method_30937()));
        if (!class_437.method_25442()) {
            components.add(new ClientFurnicrafterRecipeTooltip((FurniCrafterMenu)this.field_2797, recipe));
            components.add((class_5684)new class_5683(class_2561.method_43471((String)"gui.cobblefurnies.hold_shift_for_details").method_27692(class_124.field_1080).method_30937()));
        } else {
            HashMap<Integer, Integer> counted = new HashMap<Integer, Integer>();
            for (CountedIngredient ingredient : recipe.getMaterials()) {
                components.add(new ClientFurnicrafterRecipeIngredientTooltip((FurniCrafterMenu)this.field_2797, ingredient, counted));
            }
        }
        ((GuiGraphicsInvoker)graphics).invokeRenderTooltipInternal(this.field_22793, components, mouseX, mouseY, class_8001.field_41687);
    }

    protected void method_2389(class_332 graphics, float partialTicks, int mouseX, int mouseY) {
        graphics.method_25290(TEXTURE, this.field_2776, this.field_2800, 0.0f, 0.0f, this.field_2792, this.field_2779, 256, 256);
        this.renderRecipes(graphics, mouseX, mouseY);
        this.renderScrollbar(graphics);
    }

    private void renderRecipes(class_332 graphics, int mouseX, int mouseY) {
        this.hoveredRecipeIndex = -1;
        int clipX = this.field_2776 + 7;
        int clipY = this.field_2800 + 18;
        graphics.method_44379(clipX, clipY, clipX + 120, clipY + 88);
        int totalRecipes = this.recipes.size();
        int startRow = (int)(this.scroll / 20.0);
        int startIndex = startRow * 6;
        int rowsToDraw = (int)Math.ceil(4.4) + 1;
        int endIndex = Math.min(totalRecipes, startIndex + rowsToDraw * 6);
        boolean mouseInGrid = this.isMouseWithinBounds(mouseX, mouseY, clipX, clipY, 120, 88);
        for (int i = startIndex; i < endIndex; ++i) {
            int row = i / 6;
            int col = i % 6;
            int x = this.field_2776 + 7 + col * 20;
            int y = this.field_2800 + 18 + row * 20 - (int)this.scroll - 0;
            boolean canCraft = ((FurniCrafterMenu)this.field_2797).canCraft(this.recipes.get(i));
            int textureU = 176 + (!canCraft ? 20 : 0);
            boolean textureV = false;
            graphics.method_25290(TEXTURE, x, y, (float)textureU, (float)textureV, 20, 20, 256, 256);
            graphics.method_51445(this.recipes.get(i).method_8110(null), x + 2, y + 2);
            if (!mouseInGrid || mouseX < x || mouseX >= x + 20 || mouseY < y || mouseY >= y + 20) continue;
            this.hoveredRecipeIndex = i;
        }
        graphics.method_44380();
    }

    private void renderScrollbar(class_332 graphics) {
        int maxScroll = this.getMaxScroll();
        int scrollbarX = this.field_2776 + 7 + 120 + 3;
        int scrollbarY = this.field_2800 + 18 - 0;
        int trackHeight = 73;
        int currentHandlePos = maxScroll > 0 ? (int)(this.scroll / (double)maxScroll * (double)trackHeight) : 0;
        int textureX = maxScroll > 0 ? 176 : 188;
        graphics.method_25290(TEXTURE, scrollbarX, scrollbarY + currentHandlePos, (float)textureX, 40.0f, 12, 15, 256, 256);
    }

    private int getMaxScroll() {
        int totalRows = (int)Math.ceil((double)this.recipes.size() / 6.0);
        return Math.max(0, totalRows * 20 - 88);
    }

    private boolean isMouseWithinBounds(double mouseX, double mouseY, int x, int y, int width, int height) {
        return mouseX >= (double)x && mouseX < (double)(x + width) && mouseY >= (double)y && mouseY < (double)(y + height);
    }

    public boolean method_25402(double mouseX, double mouseY, int button) {
        if (button == 0) {
            int currentHandlePos;
            if (this.hoveredRecipeIndex != -1) {
                this.craftItem(this.hoveredRecipeIndex);
                class_310.method_1551().method_1483().method_4873((class_1113)class_1109.method_47978((class_6880)class_3417.field_15015, (float)1.0f));
                return true;
            }
            int scrollbarX = this.field_2776 + 7 + 120 + 3;
            int scrollbarY = this.field_2800 + 18 - 0;
            int maxScroll = this.getMaxScroll();
            int trackHeight = 73;
            int n = currentHandlePos = maxScroll > 0 ? (int)(this.scroll / (double)maxScroll * (double)trackHeight) : 0;
            if (this.isMouseWithinBounds(mouseX, mouseY, scrollbarX, scrollbarY + currentHandlePos, 12, 15)) {
                this.scrollbarDragOffset = (int)mouseY - (scrollbarY + currentHandlePos);
                this.clickedY = (int)mouseY;
                return true;
            }
        }
        return super.method_25402(mouseX, mouseY, button);
    }

    public boolean method_25403(double mouseX, double mouseY, int button, double dragX, double dragY) {
        if (this.clickedY != -1) {
            int scrollbarY = this.field_2800 + 18 - 0;
            int trackHeight = 73;
            int newHandlePos = (int)mouseY - scrollbarY - this.scrollbarDragOffset;
            newHandlePos = class_3532.method_15340((int)newHandlePos, (int)0, (int)trackHeight);
            this.scroll = (double)newHandlePos / (double)trackHeight * (double)this.getMaxScroll();
            return true;
        }
        return super.method_25403(mouseX, mouseY, button, dragX, dragY);
    }

    public boolean method_25406(double mouseX, double mouseY, int button) {
        if (button == 0 && this.clickedY != -1) {
            this.clickedY = -1;
            return true;
        }
        return super.method_25406(mouseX, mouseY, button);
    }

    public boolean method_25401(double mouseX, double mouseY, double deltaX, double deltaY) {
        if (this.clickedY == -1 && this.isMouseWithinBounds(mouseX, mouseY, this.field_2776 + 7, this.field_2800 + 18, 135, 88)) {
            this.scroll = class_3532.method_15350((double)(this.scroll - deltaY * 10.0), (double)0.0, (double)this.getMaxScroll());
            return true;
        }
        return super.method_25401(mouseX, mouseY, deltaX, deltaY);
    }

    private void craftItem(int recipeIndex) {
        CraftRecipeMessage message = new CraftRecipeMessage(((FurniCrafterMenu)this.field_2797).field_7763, recipeIndex);
        NetworkManager.sendToServer((class_8710)message);
    }

    public void updateRecipeButtons() {
        this.updateRecipes();
    }
}

