/*
 * Decompiled with CFR 0.152.
 */
package com.lunazstudios.cobblefurnies.recipe;

import com.lunazstudios.cobblefurnies.recipe.CountedIngredient;
import com.lunazstudios.cobblefurnies.registry.CFRecipes;
import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.Codec;
import com.mojang.serialization.DataResult;
import com.mojang.serialization.MapCodec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import net.minecraft.class_1799;
import net.minecraft.class_1856;
import net.minecraft.class_1860;
import net.minecraft.class_1865;
import net.minecraft.class_1937;
import net.minecraft.class_2371;
import net.minecraft.class_3956;
import net.minecraft.class_7225;
import net.minecraft.class_9129;
import net.minecraft.class_9139;
import net.minecraft.class_9696;
import org.jetbrains.annotations.NotNull;

public class FurniCraftingRecipe
implements class_1860<class_9696> {
    private final class_2371<CountedIngredient> materials;
    private final class_1799 result;
    private final boolean notification;

    public FurniCraftingRecipe(class_2371<CountedIngredient> materials, class_1799 result, boolean notification) {
        this.materials = materials;
        this.result = result;
        this.notification = notification;
    }

    public boolean matches(class_9696 input, class_1937 level) {
        class_1799 inputStack = input.method_59984(0);
        if (inputStack.method_7960()) {
            return false;
        }
        for (CountedIngredient ci : this.materials) {
            if (!ci.ingredient().method_8093(inputStack)) continue;
            return true;
        }
        return false;
    }

    @NotNull
    public class_1799 assemble(class_9696 input, class_7225.class_7874 provider) {
        return this.result.method_7972();
    }

    public boolean method_8113(int width, int height) {
        return true;
    }

    @NotNull
    public class_1799 method_8110(class_7225.class_7874 provider) {
        return this.result.method_7972();
    }

    @NotNull
    public class_1865<?> method_8119() {
        return CFRecipes.FURNI_CRAFTING_SERIALIZER;
    }

    @NotNull
    public class_3956<?> method_17716() {
        return CFRecipes.FURNI_CRAFTING_RECIPE_TYPE;
    }

    public class_2371<CountedIngredient> getMaterials() {
        return this.materials;
    }

    public class_1799[] getMaterialStacks() {
        return (class_1799[])this.materials.stream().map(ci -> {
            class_1799[] stacks = ci.ingredient().method_8105();
            if (stacks.length > 0) {
                class_1799 stack = stacks[0].method_7972();
                stack.method_7939(ci.count());
                return stack;
            }
            return class_1799.field_8037;
        }).toArray(class_1799[]::new);
    }

    public class_1799 getResult() {
        return this.result;
    }

    public static class Type
    implements class_3956<FurniCraftingRecipe> {
        public static final Type INSTANCE = new Type();
    }

    public static class Serializer
    implements class_1865<FurniCraftingRecipe> {
        public static final Serializer INSTANCE = new Serializer();
        public static final MapCodec<FurniCraftingRecipe> CODEC = RecordCodecBuilder.mapCodec(instance -> instance.group((App)CountedIngredient.CODEC.listOf().fieldOf("materials").flatXmap(list -> DataResult.success((Object)class_2371.method_10212((Object)CountedIngredient.EMPTY, (Object[])list.toArray(new CountedIngredient[0]))), nonNullList -> DataResult.success(nonNullList.stream().toList())).forGetter(recipe -> recipe.materials), (App)class_1799.field_24671.fieldOf("result").forGetter(recipe -> recipe.result), (App)Codec.BOOL.optionalFieldOf("show_notification", (Object)false).forGetter(recipe -> recipe.notification)).apply((Applicative)instance, FurniCraftingRecipe::new));
        public static final class_9139<class_9129, FurniCraftingRecipe> STREAM_CODEC = class_9139.method_56437((buf, recipe) -> {
            buf.method_10804(recipe.materials.size());
            for (CountedIngredient ci : recipe.materials) {
                buf.method_10804(ci.count());
                class_1856.field_48355.encode(buf, (Object)ci.ingredient());
            }
            class_1799.field_48349.encode(buf, (Object)recipe.result);
            buf.method_52964(recipe.notification);
        }, buf -> {
            int size = buf.method_10816();
            class_2371 materials = class_2371.method_10211();
            for (int i = 0; i < size; ++i) {
                int count = buf.method_10816();
                class_1856 ingredient = (class_1856)class_1856.field_48355.decode(buf);
                materials.add((Object)new CountedIngredient(ingredient, count));
            }
            class_1799 result = (class_1799)class_1799.field_48349.decode(buf);
            boolean notification = buf.readBoolean();
            return new FurniCraftingRecipe((class_2371<CountedIngredient>)materials, result, notification);
        });

        public MapCodec<FurniCraftingRecipe> method_53736() {
            return CODEC;
        }

        public class_9139<class_9129, FurniCraftingRecipe> method_56104() {
            return STREAM_CODEC;
        }
    }
}

