/*
 * Decompiled with CFR 0.152.
 */
package dev.felnull.specialmodelloader.impl;

import com.google.common.collect.ImmutableList;
import com.google.gson.JsonObject;
import dev.felnull.specialmodelloader.api.SpecialModelLoaderAPI;
import dev.felnull.specialmodelloader.api.model.LoadedResource;
import dev.felnull.specialmodelloader.api.model.ModelLoader;
import dev.felnull.specialmodelloader.api.model.obj.ObjModelLoader;
import dev.felnull.specialmodelloader.api.model.obj.ObjModelOption;
import dev.felnull.specialmodelloader.impl.SpecialModelLoader;
import dev.felnull.specialmodelloader.impl.model.NeoForgeCompat;
import dev.felnull.specialmodelloader.impl.model.obj.ObjModelLoaderImp;
import dev.felnull.specialmodelloader.impl.util.JsonUtils;
import java.io.BufferedReader;
import java.io.IOException;
import java.io.Reader;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Optional;
import net.fabricmc.api.EnvType;
import net.fabricmc.api.Environment;
import net.minecraft.class_1100;
import net.minecraft.class_2960;
import net.minecraft.class_3298;
import net.minecraft.class_3300;
import net.minecraft.class_3518;
import org.apache.commons.lang3.tuple.Pair;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.annotations.Unmodifiable;

@Environment(value=EnvType.CLIENT)
public class SpecialModelLoaderAPIImpl
implements SpecialModelLoaderAPI {
    public static final SpecialModelLoaderAPIImpl INSTANCE = new SpecialModelLoaderAPIImpl();
    private final List<ModelLoader> loaders = ImmutableList.of((Object)ObjModelLoaderImp.INSTANCE);

    @Override
    @NotNull
    public ObjModelLoader getObjLoader() {
        return ObjModelLoaderImp.INSTANCE;
    }

    @Override
    @Nullable
    public LoadedResource loadResource(@NotNull class_3300 resourceManager, @NotNull class_2960 modelLocation) {
        Pair<class_2960, ObjModelOption> forgeModel;
        ArrayList<JsonObject> models = new ArrayList<JsonObject>();
        JsonObject jo = this.readJson(resourceManager, modelLocation);
        if (NeoForgeCompat.isEnable() && (forgeModel = NeoForgeCompat.getObjModelData(jo)) != null) {
            return this.getObjLoader().loadResource(resourceManager, (class_2960)forgeModel.getLeft(), (ObjModelOption)forgeModel.getRight());
        }
        class_2960 location = JsonUtils.getParentLocation(jo);
        HashSet<class_2960> parents = new HashSet<class_2960>();
        while (location != null) {
            models.add(jo);
            if (parents.contains(location)) {
                SpecialModelLoader.LOGGER.warn("Model parent specification is looping: '{}', '{}'", (Object)modelLocation, (Object)location);
                return null;
            }
            parents.add(location);
            ModelLoader loader = this.getLoader(location);
            if (loader != null) {
                JsonObject ret = new JsonObject();
                Collections.reverse(models);
                models.forEach(r -> r.asMap().forEach((name, rlm) -> ret.add(name, rlm.deepCopy())));
                return loader.loadResource(resourceManager, ret);
            }
            jo = this.readJson(resourceManager, location);
            location = JsonUtils.getParentLocation(jo);
        }
        return null;
    }

    @Override
    @NotNull
    public class_1100 makeModel(@NotNull LoadedResource resource) {
        return resource.getLoader().makeModel(resource);
    }

    @Override
    public @Unmodifiable @NotNull List<ModelLoader> getLoaders() {
        return this.loaders;
    }

    private ModelLoader getLoader(class_2960 location) {
        return this.getLoaders().stream().filter(r -> r.isLoaderLocation(location)).limit(1L).findFirst().orElse(null);
    }

    private JsonObject readJson(class_3300 resourceManager, class_2960 modelLocation) {
        JsonObject jo;
        class_2960 modelPath = class_2960.method_60655((String)modelLocation.method_12836(), (String)("models/" + modelLocation.method_12832() + ".json"));
        Optional res = resourceManager.method_14486(modelPath);
        if (res.isEmpty()) {
            return null;
        }
        try (BufferedReader reader = ((class_3298)res.get()).method_43039();){
            jo = class_3518.method_15255((Reader)reader);
        }
        catch (IOException ex) {
            throw new IllegalStateException("Failed to load json: " + String.valueOf(modelLocation), ex);
        }
        return jo;
    }
}

