/*
 * Decompiled with CFR 0.152.
 */
package dev.felnull.specialmodelloader.impl.handler;

import com.google.common.collect.ImmutableSet;
import com.google.gson.Gson;
import com.google.gson.JsonArray;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import dev.felnull.specialmodelloader.api.event.SpecialModelLoaderEvents;
import dev.felnull.specialmodelloader.impl.SpecialModelLoader;
import java.io.BufferedReader;
import java.io.Reader;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.Executor;
import java.util.function.BiPredicate;
import java.util.function.Predicate;
import java.util.regex.Pattern;
import net.fabricmc.api.EnvType;
import net.fabricmc.api.Environment;
import net.minecraft.class_2960;
import net.minecraft.class_3300;

@Environment(value=EnvType.CLIENT)
public class SMLClientHandler {
    private static final Gson GSON = new Gson();
    private static final String MANUAL_LOAD_SCOPE_RESOURCE_NAME = "sml_load_scopes";

    public static void init() {
        SpecialModelLoaderEvents.LOAD_SCOPE_ASYNC.register(SMLClientHandler::provideSimpleLoadScopePredicate);
        SpecialModelLoaderEvents.LOAD_SCOPE_ASYNC.register(SMLClientHandler::provideManualLoadScopePredicate);
    }

    private static CompletableFuture<Predicate<class_2960>> provideSimpleLoadScopePredicate(class_3300 resourceManager, Executor executor) {
        BiPredicate<class_3300, class_2960> predicate = ((SpecialModelLoaderEvents.LoadScope)SpecialModelLoaderEvents.LOAD_SCOPE.invoker()).provideLoadScopePredicate();
        return CompletableFuture.supplyAsync(() -> loc -> predicate.test(resourceManager, (class_2960)loc), executor);
    }

    private static CompletableFuture<Predicate<class_2960>> provideManualLoadScopePredicate(class_3300 resourceManager, Executor executor) {
        return CompletableFuture.supplyAsync(() -> {
            ImmutableSet.Builder patternsBuilder = new ImmutableSet.Builder();
            resourceManager.method_14488(MANUAL_LOAD_SCOPE_RESOURCE_NAME, loc -> loc.method_12832().endsWith(".json")).forEach((location, resource) -> {
                try (BufferedReader reader = resource.method_43039();){
                    JsonObject jo = (JsonObject)GSON.fromJson((Reader)reader, JsonObject.class);
                    SMLClientHandler.loadManualLoadScope((ImmutableSet.Builder<Pattern>)patternsBuilder, jo);
                }
                catch (Exception e) {
                    SpecialModelLoader.LOGGER.error("Error occurred while loading model load scope resource json {}", location, (Object)e);
                }
            });
            ImmutableSet patterns = patternsBuilder.build();
            int size = patterns.size();
            if (size >= 1) {
                SpecialModelLoader.LOGGER.info("Loaded {} manual model load scope", (Object)size);
            }
            return loc -> patterns.stream().anyMatch(pattern -> pattern.matcher(loc.toString()).matches());
        }, executor);
    }

    private static void loadManualLoadScope(ImmutableSet.Builder<Pattern> builder, JsonObject jsonObject) {
        if (!(jsonObject.has("version") && jsonObject.get("version").isJsonPrimitive() && jsonObject.getAsJsonPrimitive("version").isNumber())) {
            throw new IllegalStateException("Unknown version");
        }
        int version = jsonObject.getAsJsonPrimitive("version").getAsInt();
        if (version != 1) {
            throw new IllegalStateException("Unsupported version");
        }
        if (!jsonObject.has("entry") || !jsonObject.get("entry").isJsonArray()) {
            return;
        }
        JsonArray entries = jsonObject.getAsJsonArray("entry");
        for (JsonElement entry : entries) {
            if (!entry.isJsonPrimitive() || !entry.getAsJsonPrimitive().isString()) continue;
            builder.add((Object)Pattern.compile(entry.getAsString()));
        }
    }
}

