/*
 * Decompiled with CFR 0.152.
 */
package com.hisroyalty.cobbledgacha.cobblemon;

import com.cobblemon.mod.common.Cobblemon;
import com.cobblemon.mod.common.CobblemonEntities;
import com.cobblemon.mod.common.api.spawning.CobblemonSpawnPools;
import com.cobblemon.mod.common.api.spawning.detail.PokemonSpawnDetail;
import com.cobblemon.mod.common.api.spawning.detail.SpawnDetail;
import com.cobblemon.mod.common.api.storage.PokemonStoreManager;
import com.cobblemon.mod.common.entity.pokemon.PokemonEntity;
import com.cobblemon.mod.common.pokemon.Pokemon;
import com.hisroyalty.cobbledgacha.cobblemon.GachaBuckets;
import com.hisroyalty.cobbledgacha.cobblemon.GachaSpawnEntry;
import com.hisroyalty.cobbledgacha.cobblemon.GachaSpawnRegistry;
import java.util.ArrayList;
import java.util.List;
import java.util.Random;
import net.minecraft.class_124;
import net.minecraft.class_1297;
import net.minecraft.class_1937;
import net.minecraft.class_2338;
import net.minecraft.class_2561;
import net.minecraft.class_3218;
import net.minecraft.class_3222;
import org.jetbrains.annotations.Nullable;

public class CobblemonGacha {
    public static void spawnPokemon(class_3218 level, class_2338 pos, @Nullable class_3222 player) {
        boolean machineHasCustomPool;
        boolean bl = machineHasCustomPool = !GachaSpawnRegistry.isEmpty();
        if (machineHasCustomPool) {
            CobblemonGacha.useGachaSpawns(level, pos, player);
        } else {
            CobblemonGacha.useCobblemonWorldSpawns(level, pos, player);
        }
    }

    public static void useCobblemonWorldSpawns(class_3218 level, class_2338 pos, @Nullable class_3222 player) {
        ArrayList<PokemonSpawnDetail> validSpawns = new ArrayList<PokemonSpawnDetail>();
        for (SpawnDetail detail : CobblemonSpawnPools.WORLD_SPAWN_POOL.getDetails()) {
            if (!(detail instanceof PokemonSpawnDetail)) continue;
            PokemonSpawnDetail pokemonDetail = (PokemonSpawnDetail)detail;
            validSpawns.add(pokemonDetail);
        }
        if (validSpawns.isEmpty()) {
            if (player != null) {
                player.method_43496((class_2561)class_2561.method_43471((String)"No Pok\u00e9mon spawn data found.").method_27692(class_124.field_1061));
            }
            return;
        }
        PokemonSpawnDetail chosen = CobblemonGacha.selectWeighted(validSpawns, new Random());
        if (chosen == null) {
            return;
        }
        Pokemon pokemon = chosen.getPokemon().create(player);
        CobblemonGacha.spawnPokemonEntity(level, pos, player, pokemon);
    }

    private static void useGachaSpawns(class_3218 level, class_2338 pos, @Nullable class_3222 player) {
        List<GachaSpawnEntry> entries = GachaSpawnRegistry.getAll();
        if (entries.isEmpty()) {
            if (player != null) {
                player.method_43496((class_2561)class_2561.method_43470((String)"No custom gacha spawns loaded.").method_27692(class_124.field_1061));
            }
            return;
        }
        Random random = new Random();
        String bucket = GachaBuckets.roll(random);
        List<GachaSpawnEntry> candidates = entries.stream().filter(e -> e.bucket().equalsIgnoreCase(bucket)).filter(e -> e.matches(level, pos)).toList();
        if (candidates.isEmpty()) {
            if (player != null) {
                player.method_43496((class_2561)class_2561.method_43470((String)("No spawns available for bucket: " + bucket)).method_27692(class_124.field_1061));
            }
            return;
        }
        GachaSpawnEntry chosen = CobblemonGacha.selectWeightedInBucket(candidates, random);
        if (chosen == null) {
            return;
        }
        Pokemon pokemon = chosen.create(player, random);
        CobblemonGacha.spawnPokemonEntity(level, pos, player, pokemon);
    }

    private static GachaSpawnEntry selectWeightedInBucket(List<GachaSpawnEntry> entries, Random random) {
        int total = 0;
        for (GachaSpawnEntry e : entries) {
            total = (int)((double)total + e.weight());
        }
        int roll = random.nextInt(total);
        int current = 0;
        for (GachaSpawnEntry e : entries) {
            if (roll >= (current = (int)((double)current + e.weight()))) continue;
            return e;
        }
        return entries.get(entries.size() - 1);
    }

    private static void spawnPokemonEntity(class_3218 level, class_2338 pos, @Nullable class_3222 player, Pokemon pokemon) {
        PokemonEntity entity = new PokemonEntity((class_1937)level, pokemon, CobblemonEntities.POKEMON);
        entity.setPokemon(pokemon);
        class_2338 spawnPos = player != null ? player.method_24515() : pos;
        entity.method_5641((double)spawnPos.method_10263() + 0.5, (double)(spawnPos.method_10264() + 1), (double)spawnPos.method_10260() + 0.5, level.field_9229.method_43057() * 360.0f, 0.0f);
        level.method_8649((class_1297)entity);
        if (player != null) {
            player.method_43496((class_2561)class_2561.method_43470((String)"A wild ").method_10852((class_2561)class_2561.method_43470((String)pokemon.getSpecies().getName()).method_27692(class_124.field_1060)).method_10852((class_2561)class_2561.method_43470((String)" appeared!")));
        }
    }

    private static PokemonSpawnDetail selectWeighted(List<PokemonSpawnDetail> details, Random random) {
        float total = 0.0f;
        for (PokemonSpawnDetail d : details) {
            total += d.getWeight();
        }
        float roll = random.nextFloat() * total;
        float current = 0.0f;
        for (PokemonSpawnDetail d : details) {
            if (!(roll <= (current += d.getWeight()))) continue;
            return d;
        }
        return details.get(details.size() - 1);
    }

    private static void givePokemon(@Nullable class_3222 player, Pokemon pokemon) {
        if (player == null) {
            return;
        }
        PokemonStoreManager storage = Cobblemon.INSTANCE.getStorage();
        if (!storage.getParty(player).add(pokemon)) {
            storage.getPC(player).add(pokemon);
            player.method_43496((class_2561)class_2561.method_43470((String)"Party full! Pok\u00e9mon sent to PC.").method_27692(class_124.field_1054));
        } else {
            player.method_43496((class_2561)class_2561.method_43470((String)"Obtained Pok\u00e9mon: ").method_10852((class_2561)class_2561.method_43470((String)pokemon.getSpecies().getName()).method_27692(class_124.field_1060)));
        }
    }
}

