/*
 * Decompiled with CFR 0.152.
 */
package com.hisroyalty.cobbledgacha.cobblemon;

import com.cobblemon.mod.common.api.pokemon.PokemonProperties;
import com.cobblemon.mod.common.api.pokemon.PokemonSpecies;
import com.cobblemon.mod.common.pokemon.Pokemon;
import com.cobblemon.mod.common.pokemon.Species;
import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.Codec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import java.util.List;
import java.util.Optional;
import java.util.Random;
import net.minecraft.class_2338;
import net.minecraft.class_2960;
import net.minecraft.class_3218;
import net.minecraft.class_3222;
import net.minecraft.class_5321;

public record GachaSpawnEntry(String species, String bucket, double weight, int minLevel, int maxLevel, Optional<List<class_2960>> biomes) {
    public static final Codec<GachaSpawnEntry> CODEC = RecordCodecBuilder.create(i -> i.group((App)Codec.STRING.fieldOf("species").forGetter(GachaSpawnEntry::species), (App)Codec.STRING.fieldOf("bucket").forGetter(GachaSpawnEntry::bucket), (App)Codec.DOUBLE.fieldOf("weight").forGetter(GachaSpawnEntry::weight), (App)Codec.INT.fieldOf("minLevel").forGetter(GachaSpawnEntry::minLevel), (App)Codec.INT.fieldOf("maxLevel").forGetter(GachaSpawnEntry::maxLevel), (App)class_2960.field_25139.listOf().optionalFieldOf("biomes").forGetter(GachaSpawnEntry::biomes)).apply((Applicative)i, GachaSpawnEntry::new));

    public boolean matches(class_3218 level, class_2338 pos) {
        if (this.biomes.isEmpty()) {
            return true;
        }
        return this.biomes.get().contains(((class_5321)level.method_23753(pos).method_40230().get()).method_29177());
    }

    public Pokemon create(class_3222 player, Random random) {
        String[] parts = this.species.split(" ");
        Species s = PokemonSpecies.getByName((String)parts[0]);
        int level = this.minLevel + random.nextInt(this.maxLevel - this.minLevel + 1);
        PokemonProperties props = new PokemonProperties();
        props.setSpecies(s.getName());
        props.setLevel(Integer.valueOf(level));
        for (int i = 1; i < parts.length; ++i) {
            String[] kv = parts[i].split("=", 2);
            if (kv.length != 2) continue;
            PokemonProperties parsed = PokemonProperties.Companion.parse(kv[0] + "=" + kv[1]);
            props.getCustomProperties().addAll(parsed.getCustomProperties());
        }
        return props.create();
    }

    public Species getSpecies() {
        String base = this.species.split(" ")[0];
        return PokemonSpecies.getByName((String)base);
    }
}

