/*
 * Decompiled with CFR 0.152.
 */
package de.markusbordihn.easynpc.client.renderer;

import de.markusbordihn.easynpc.client.renderer.entity.EntityRendererUtils;
import de.markusbordihn.easynpc.client.renderer.entity.ModCustomEntityRenderer;
import de.markusbordihn.easynpc.client.renderer.entity.ModEpicFightEntityRenderer;
import de.markusbordihn.easynpc.client.renderer.entity.ModNPCEntityRenderer;
import de.markusbordihn.easynpc.client.renderer.entity.ModRawEntityRenderer;
import de.markusbordihn.easynpc.compat.CompatConstants;
import de.markusbordihn.easynpc.entity.ModEntityType;
import de.markusbordihn.easynpc.entity.UserDefinedEntityRegistry;
import de.markusbordihn.easynpc.entity.UserDefinedEntityType;
import java.util.function.Function;
import net.fabricmc.fabric.api.client.rendering.v1.EntityRendererRegistry;
import net.minecraft.class_1297;
import net.minecraft.class_1299;
import net.minecraft.class_1309;
import net.minecraft.class_5617;
import net.minecraft.class_897;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public class EntityRenderer {
    protected static final Logger log = LogManager.getLogger((String)"Easy NPC: Core");

    private EntityRenderer() {
    }

    public static void register() {
        log.info("{} Entity Renders ...", (Object)"\ud83d\udde3 Register Easy NPC: Core");
        for (ModRawEntityRenderer modRawEntityRenderer : ModRawEntityRenderer.values()) {
            EntityRendererRegistry.register(ModEntityType.getEntityType(modRawEntityRenderer.getEntityType()), context -> modRawEntityRenderer.getRenderer().apply(context));
        }
        for (Enum enum_ : ModNPCEntityRenderer.values()) {
            EntityRendererRegistry.register(ModEntityType.getEntityType(((ModNPCEntityRenderer)enum_).getEntityType()), arg_0 -> EntityRenderer.lambda$register$1((ModNPCEntityRenderer)enum_, arg_0));
        }
        for (Enum enum_ : ModCustomEntityRenderer.values()) {
            EntityRendererRegistry.register(ModEntityType.getEntityType(((ModCustomEntityRenderer)enum_).getEntityType()), arg_0 -> EntityRenderer.lambda$register$2((ModCustomEntityRenderer)enum_, arg_0));
        }
        for (UserDefinedEntityType type : UserDefinedEntityRegistry.getAvailableEntityTypes()) {
            class_1299<?> entityType = UserDefinedEntityRegistry.getRegisteredEntityType(type);
            if (entityType == null) continue;
            EntityRenderer.registerEntityRendererWithTypecast(entityType, context -> EntityRenderer.createRendererForBaseType(context, type.getBaseEntityType()));
        }
        if (CompatConstants.MOD_EPIC_FIGHT_LOADED) {
            for (ModEpicFightEntityRenderer modEpicFightEntityRenderer : ModEpicFightEntityRenderer.values()) {
                EntityRendererRegistry.register(ModEntityType.getEntityType(modEpicFightEntityRenderer.getEntityType()), context -> modEpicFightEntityRenderer.getRenderer().apply(context));
            }
        }
    }

    private static class_897<? extends class_1309> createRendererForBaseType(class_5617.class_5618 context, class_1299<?> baseEntityType) {
        for (ModRawEntityRenderer modRawEntityRenderer : ModRawEntityRenderer.values()) {
            if (ModEntityType.getEntityType(modRawEntityRenderer.getEntityType()) != baseEntityType) continue;
            return modRawEntityRenderer.getRenderer().apply(context);
        }
        for (Enum enum_ : ModNPCEntityRenderer.values()) {
            if (ModEntityType.getEntityType(((ModNPCEntityRenderer)enum_).getEntityType()) != baseEntityType) continue;
            return ((ModNPCEntityRenderer)enum_).getRenderer().apply(context);
        }
        for (Enum enum_ : ModCustomEntityRenderer.values()) {
            if (ModEntityType.getEntityType(((ModCustomEntityRenderer)enum_).getEntityType()) != baseEntityType) continue;
            return ((ModCustomEntityRenderer)enum_).getRenderer().apply(context);
        }
        Function<class_5617.class_5618, class_897<? extends class_1309>> rendererFactory = EntityRendererUtils.getVanillaRendererFactory(baseEntityType);
        if (rendererFactory != null) {
            return rendererFactory.apply(context);
        }
        return EntityRendererUtils.createFallbackRenderer(context, baseEntityType);
    }

    private static <T extends class_1297> void registerEntityRendererWithTypecast(class_1299<?> entityType, Function<class_5617.class_5618, class_897<? extends class_1309>> rendererFactory) {
        class_5617 provider = context -> {
            class_897 renderer = (class_897)rendererFactory.apply(context);
            return renderer;
        };
        EntityRendererRegistry.register(entityType, (class_5617)provider);
    }

    private static /* synthetic */ class_897 lambda$register$2(ModCustomEntityRenderer renderer, class_5617.class_5618 context) {
        return renderer.getRenderer().apply(context);
    }

    private static /* synthetic */ class_897 lambda$register$1(ModNPCEntityRenderer renderer, class_5617.class_5618 context) {
        return renderer.getRenderer().apply(context);
    }
}

