/*
 * Decompiled with CFR 0.152.
 */
package de.markusbordihn.easynpc.client.renderer.entity;

import de.markusbordihn.easynpc.Constants;
import de.markusbordihn.easynpc.api.model.CustomModelConfig;
import de.markusbordihn.easynpc.api.model.OriginalModelConfig;
import de.markusbordihn.easynpc.api.skin.VariantTexture;
import de.markusbordihn.easynpc.client.texture.CustomTextureManager;
import de.markusbordihn.easynpc.client.texture.PlayerTextureManager;
import de.markusbordihn.easynpc.client.texture.RemoteTextureManager;
import de.markusbordihn.easynpc.data.skin.SkinType;
import de.markusbordihn.easynpc.entity.easynpc.EasyNPC;
import de.markusbordihn.easynpc.entity.easynpc.data.SkinDataCapable;
import java.util.function.Supplier;
import net.minecraft.class_1309;
import net.minecraft.class_2960;

public interface EasyNPCEntityRenderer {
    public class_2960 getDefaultTexture();

    default public OriginalModelConfig getOriginalModelConfig() {
        return OriginalModelConfig.DEFAULT;
    }

    default public CustomModelConfig getCustomModelConfig() {
        return CustomModelConfig.NONE;
    }

    default public class_2960 getTransparentTexture() {
        return Constants.BLANK_ENTITY_TEXTURE;
    }

    default public class_2960 getTextureLocationWithConfig(class_1309 entity) {
        OriginalModelConfig originalConfig = this.getOriginalModelConfig();
        if (this.getCustomModelConfig().shouldHideOriginal() || originalConfig.isHidden()) {
            return this.getTransparentTexture();
        }
        if (originalConfig.hasCustomTexture()) {
            return originalConfig.getCustomTexture();
        }
        if (entity instanceof EasyNPC) {
            EasyNPC easyNPC = (EasyNPC)entity;
            if (originalConfig.shouldUseVariantTexture()) {
                return this.getVariantTexture(easyNPC);
            }
            return this.getEntityTexture(easyNPC);
        }
        return this.getDefaultTexture();
    }

    default public class_2960 getTextureByVariant(Enum<?> variant) {
        if (variant instanceof VariantTexture) {
            VariantTexture variantTexture = (VariantTexture)((Object)variant);
            return variantTexture.getTextureLocation();
        }
        return this.getDefaultTexture();
    }

    default public class_2960 getCustomTexture(SkinDataCapable<?> entity) {
        return CustomTextureManager.getOrCreateTextureWithDefault(entity, this.getDefaultTexture());
    }

    default public class_2960 getPlayerTexture(SkinDataCapable<?> entity) {
        return PlayerTextureManager.getOrCreateTextureWithDefault(entity, this.getDefaultTexture());
    }

    default public class_2960 getRemoteTexture(SkinDataCapable<?> entity) {
        return RemoteTextureManager.getOrCreateTextureWithDefault(entity, this.getDefaultTexture());
    }

    default public class_2960 getEntityTexture(EasyNPC<?> easyNPC) {
        SkinDataCapable skinData = easyNPC.getEasyNPCSkinData();
        return switch (skinData.getSkinType()) {
            case SkinType.NONE -> Constants.BLANK_ENTITY_TEXTURE;
            case SkinType.CUSTOM -> this.getCustomTexture(skinData);
            case SkinType.SECURE_REMOTE_URL, SkinType.INSECURE_REMOTE_URL -> this.getRemoteTexture(skinData);
            default -> this.getTextureByVariant(easyNPC.getEasyNPCVariantData().getSkinVariantType());
        };
    }

    default public class_2960 getVariantTexture(EasyNPC<?> easyNPC) {
        return this.getTextureByVariant(easyNPC.getEasyNPCVariantData().getSkinVariantType());
    }

    default public class_2960 getEntityPlayerTexture(EasyNPC<?> easyNPC) {
        SkinDataCapable skinData = easyNPC.getEasyNPCSkinData();
        return switch (skinData.getSkinType()) {
            case SkinType.NONE -> Constants.BLANK_ENTITY_TEXTURE;
            case SkinType.CUSTOM -> this.getCustomTexture(skinData);
            case SkinType.PLAYER_SKIN -> this.getPlayerTexture(skinData);
            case SkinType.SECURE_REMOTE_URL, SkinType.INSECURE_REMOTE_URL -> this.getRemoteTexture(skinData);
            default -> this.getTextureByVariant(easyNPC.getEasyNPCVariantData().getSkinVariantType());
        };
    }

    default public class_2960 getEntityTextureWithDefaultCallback(EasyNPC<?> easyNPC, Supplier<class_2960> defaultTextureSupplier) {
        SkinDataCapable skinData = easyNPC.getEasyNPCSkinData();
        return switch (skinData.getSkinType()) {
            case SkinType.NONE -> Constants.BLANK_ENTITY_TEXTURE;
            case SkinType.CUSTOM -> this.getCustomTexture(skinData);
            case SkinType.SECURE_REMOTE_URL, SkinType.INSECURE_REMOTE_URL -> this.getRemoteTexture(skinData);
            default -> defaultTextureSupplier.get();
        };
    }
}

