/*
 * Decompiled with CFR 0.152.
 */
package de.markusbordihn.easynpc.client.renderer.entity.custom;

import de.markusbordihn.easynpc.client.model.custom.DopplerModel;
import de.markusbordihn.easynpc.client.renderer.entity.EasyNPCEntityRenderer;
import de.markusbordihn.easynpc.client.renderer.manager.EntityTypeManager;
import de.markusbordihn.easynpc.client.renderer.manager.RendererManager;
import de.markusbordihn.easynpc.data.render.RenderType;
import de.markusbordihn.easynpc.data.skin.variant.DopplerSkinVariant;
import de.markusbordihn.easynpc.entity.easynpc.EasyNPC;
import de.markusbordihn.easynpc.entity.easynpc.data.RenderDataCapable;
import net.minecraft.class_1297;
import net.minecraft.class_1299;
import net.minecraft.class_1309;
import net.minecraft.class_1314;
import net.minecraft.class_2960;
import net.minecraft.class_4587;
import net.minecraft.class_4597;
import net.minecraft.class_5601;
import net.minecraft.class_5617;
import net.minecraft.class_583;
import net.minecraft.class_897;
import net.minecraft.class_909;
import net.minecraft.class_922;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public class DopplerRenderer<E extends class_1314>
extends class_909<E, DopplerModel<E>>
implements EasyNPCEntityRenderer {
    protected static final class_2960 DEFAULT_TEXTURE = DopplerSkinVariant.DOPPLER.getTextureLocation();
    private static final Logger log = LogManager.getLogger((String)"Easy NPC: Core");

    public DopplerRenderer(class_5617.class_5618 context, class_5601 modelLayerLocation) {
        super(context, new DopplerModel(context.method_32167(modelLayerLocation)), 0.5f);
    }

    private boolean renderEntity(class_1314 entity, float entityYaw, float partialTicks, class_4587 poseStack, class_4597 buffer, int packedLight) {
        if (!(entity instanceof EasyNPC)) {
            return false;
        }
        EasyNPC easyNPC = (EasyNPC)entity;
        RenderDataCapable renderData = easyNPC.getEasyNPCRenderData();
        if (renderData == null || renderData.getRenderDataEntry() == null || renderData.getRenderDataEntry().getRenderType() != RenderType.CUSTOM_ENTITY) {
            return false;
        }
        class_1299<? extends class_1297> renderEntityType = renderData.getRenderDataEntry().getRenderEntityType();
        class_1314 customEntity = EntityTypeManager.getPathfinderMob(renderEntityType, entity.method_37908());
        if (customEntity == null) {
            return false;
        }
        String entityTypeName = EntityTypeManager.getEntityTypeName(renderEntityType);
        class_922<? extends class_1309, ? extends class_583<? extends class_1309>> livingEntityRenderer = RendererManager.getLivingEntityRenderer(renderEntityType, customEntity);
        if (livingEntityRenderer != null) {
            try {
                RendererManager.copyCustomLivingEntityData(entity, (class_1309)customEntity, entityTypeName);
                livingEntityRenderer.method_4054((class_1309)customEntity, entityYaw, partialTicks, poseStack, buffer, packedLight);
                return true;
            }
            catch (Exception exception) {
                log.error("Failed to render custom living entity {} ({}):", (Object)customEntity, renderEntityType, (Object)exception);
                EntityTypeManager.addUnsupportedEntityType(renderEntityType);
                return false;
            }
        }
        class_897<? extends class_1297> entityRenderer = RendererManager.getEntityRenderer(renderEntityType, customEntity);
        if (entityRenderer != null) {
            try {
                RendererManager.copyCustomLivingEntityData(entity, (class_1309)customEntity, entityTypeName);
                entityRenderer.method_3936((class_1297)customEntity, entityYaw, partialTicks, poseStack, buffer, packedLight);
                return true;
            }
            catch (Exception exception) {
                log.error("Failed to render custom entity {} ({}):", (Object)customEntity, renderEntityType, (Object)exception);
                EntityTypeManager.addUnsupportedEntityType(renderEntityType);
                return false;
            }
        }
        return false;
    }

    public class_2960 getTextureLocation(E entity) {
        if (entity instanceof EasyNPC) {
            EasyNPC easyNPC = (EasyNPC)entity;
            return this.getEntityTexture(easyNPC);
        }
        return DEFAULT_TEXTURE;
    }

    @Override
    public class_2960 getDefaultTexture() {
        return DEFAULT_TEXTURE;
    }

    public void render(E entity, float entityYaw, float partialTicks, class_4587 poseStack, class_4597 bufferSource, int packedLight) {
        if (this.renderEntity((class_1314)entity, entityYaw, partialTicks, poseStack, bufferSource, packedLight)) {
            return;
        }
        super.method_4054(entity, entityYaw, partialTicks, poseStack, bufferSource, packedLight);
    }
}

