/*
 * Decompiled with CFR 0.152.
 */
package de.markusbordihn.easynpc.client.renderer.manager;

import de.markusbordihn.easynpc.config.RenderEntityTypeSupportConfig;
import java.lang.reflect.Field;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import net.minecraft.class_1297;
import net.minecraft.class_1299;
import net.minecraft.class_1314;
import net.minecraft.class_1937;
import net.minecraft.class_4048;
import net.minecraft.class_7923;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public class EntityTypeManager {
    private static final Logger log = LogManager.getLogger((String)"Easy NPC: Core");
    private static final String LOG_PREFIX = "[Entity Type Manager]";
    private static final Set<class_1299<? extends class_1297>> unknownEntityTypes = new HashSet<class_1299<? extends class_1297>>();
    private static final Set<class_1299<? extends class_1297>> supportedEntityTypes = new HashSet<class_1299<? extends class_1297>>();
    private static final Set<class_1299<? extends class_1297>> unsupportedEntityTypes = new HashSet<class_1299<? extends class_1297>>();
    private static final Map<class_1299<? extends class_1297>, class_1314> pathfinderMobMap = new ConcurrentHashMap<class_1299<? extends class_1297>, class_1314>();
    private static final Map<class_1299<? extends class_1297>, Float> scaleFactorMap = new ConcurrentHashMap<class_1299<? extends class_1297>, Float>();
    private static final Map<class_1299<? extends class_1297>, String> entityTypeNameMap = new ConcurrentHashMap<class_1299<? extends class_1297>, String>();
    private static boolean isRegistered = false;

    private EntityTypeManager() {
    }

    public static void register() {
        if (isRegistered) {
            log.warn("{} Already registered, skipping.", (Object)LOG_PREFIX);
            return;
        }
        log.info("{} Registering Entity Type Manager ...", (Object)"\ud83d\udde3 Register Easy NPC: Core");
        Set<String> configuredSupportedTypes = RenderEntityTypeSupportConfig.getSupportedEntityTypes();
        Set<String> configuredUnsupportedTypes = RenderEntityTypeSupportConfig.getUnsupportedEntityTypes();
        if (configuredSupportedTypes.isEmpty() && configuredUnsupportedTypes.isEmpty()) {
            log.error("{} Config appears to be empty! This may cause autocomplete issues.", (Object)LOG_PREFIX);
        } else {
            log.info("{} Config loaded with {} supported and {} unsupported entity types.", (Object)LOG_PREFIX, (Object)configuredSupportedTypes.size(), (Object)configuredUnsupportedTypes.size());
        }
        for (class_1299 entityType : class_7923.field_41177) {
            String entityTypeLocation;
            if (entityType == null || (entityTypeLocation = class_7923.field_41177.method_10221((Object)entityType).toString()).startsWith("easy_npc") || entityTypeLocation.startsWith("mythicmounts:") || entityTypeLocation.endsWith("_arrow") || entityTypeLocation.endsWith("_ball") || entityTypeLocation.endsWith("_boat") || entityTypeLocation.endsWith("_bullet") || entityTypeLocation.endsWith("_charge") || entityTypeLocation.endsWith("_display") || entityTypeLocation.endsWith("_fireball") || entityTypeLocation.endsWith("_marker") || entityTypeLocation.endsWith("_part") || entityTypeLocation.endsWith("_projectile") || entityTypeLocation.endsWith("_spawner") || entityTypeLocation.endsWith("_thrown") || entityTypeLocation.endsWith("effect") || entityTypeLocation.contains(":projectile") || entityTypeLocation.contains("_attack") || entityTypeLocation.contains("multi_part") || entityTypeLocation.contains("effect_") || entityTypeLocation.contains("flash_") || entityTypeLocation.contains(":spell_")) continue;
            entityTypeNameMap.put((class_1299<? extends class_1297>)entityType, entityTypeLocation);
            if (configuredSupportedTypes.contains(entityTypeLocation)) {
                EntityTypeManager.addSupportedEntityType(entityType);
                continue;
            }
            if (configuredUnsupportedTypes.contains(entityTypeLocation)) {
                EntityTypeManager.addUnsupportedEntityType(entityType);
                continue;
            }
            EntityTypeManager.addUnknownEntityType(entityType);
        }
        log.info("[Entity Type Manager] Found {} supported, {} unsupported and {} unknown entity types.", (Object)supportedEntityTypes.size(), (Object)unsupportedEntityTypes.size(), (Object)unknownEntityTypes.size());
        isRegistered = true;
    }

    public static void addSupportedEntityType(class_1299<?> entityType) {
        supportedEntityTypes.add(entityType);
        unsupportedEntityTypes.remove(entityType);
        unknownEntityTypes.remove(entityType);
        scaleFactorMap.computeIfAbsent(entityType, EntityTypeManager::calculateScaleFactor);
    }

    public static void addUnsupportedEntityType(class_1299<?> entityType) {
        unsupportedEntityTypes.add(entityType);
        supportedEntityTypes.remove(entityType);
        unknownEntityTypes.remove(entityType);
        scaleFactorMap.remove(entityType);
    }

    public static void addUnknownEntityType(class_1299<?> entityType) {
        unknownEntityTypes.add(entityType);
        supportedEntityTypes.remove(entityType);
        unsupportedEntityTypes.remove(entityType);
        scaleFactorMap.computeIfAbsent(entityType, EntityTypeManager::calculateScaleFactor);
    }

    public static boolean isSupportedEntityType(class_1299<?> entityType) {
        return supportedEntityTypes.contains(entityType);
    }

    public static boolean isUnsupportedEntityType(class_1299<?> entityType) {
        return unsupportedEntityTypes.contains(entityType);
    }

    public static Set<class_1299<? extends class_1297>> getUnknownEntityTypes() {
        return unknownEntityTypes;
    }

    public static Set<class_1299<? extends class_1297>> getSupportedEntityTypes() {
        return supportedEntityTypes;
    }

    public static Set<class_1299<? extends class_1297>> getUnsupportedEntityTypes() {
        return unsupportedEntityTypes;
    }

    public static List<class_1299<? extends class_1297>> getUnknownAndSupportedEntityTypes() {
        ArrayList<class_1299<? extends class_1297>> arrayList = new ArrayList<class_1299<? extends class_1297>>();
        arrayList.addAll(supportedEntityTypes);
        arrayList.addAll(unknownEntityTypes);
        return arrayList;
    }

    public static float calculateScaleFactor(class_1299<? extends class_1297> entityType) {
        class_4048 entityDimensions = entityType.method_18386();
        float scaleFactor = 1.0f;
        float defaultWidth = 0.8f;
        float defaultHeight = 2.0f;
        float width = entityDimensions.comp_2185();
        float height = entityDimensions.comp_2186();
        if (width > defaultWidth || height > defaultHeight) {
            scaleFactor = Math.max(width / defaultWidth, height / defaultHeight);
        }
        return scaleFactor;
    }

    public static class_1314 getPathfinderMob(class_1299<?> entityType, class_1937 level) {
        if (entityType == null) {
            return null;
        }
        class_1314 pathfinderMob = pathfinderMobMap.get(entityType);
        if (pathfinderMob != null) {
            if (pathfinderMob.method_5805()) {
                if (pathfinderMob.method_37908() != level) {
                    try {
                        Field levelField = class_1297.class.getDeclaredField("level");
                        levelField.setAccessible(true);
                        levelField.set(pathfinderMob, level);
                    }
                    catch (Exception e) {
                        log.error("{} Failed to update level for PathfinderMob {}", (Object)LOG_PREFIX, (Object)pathfinderMob);
                    }
                }
                return pathfinderMob;
            }
            log.debug("{} PathfinderMob {} is removed, re-creating it.", (Object)LOG_PREFIX, (Object)pathfinderMob);
            pathfinderMobMap.remove(entityType);
        }
        if (!EntityTypeManager.isUnsupportedEntityType(entityType)) {
            class_1297 entity = entityType.method_5883(level);
            if (entity instanceof class_1314) {
                class_1314 newPathfinderMob = (class_1314)entity;
                log.debug("{} Registering PathfinderMob {} for {}", (Object)LOG_PREFIX, (Object)newPathfinderMob, entityType);
                newPathfinderMob.method_5977(true);
                newPathfinderMob.method_5803(true);
                newPathfinderMob.field_5960 = true;
                pathfinderMobMap.put(entityType, newPathfinderMob);
                if (!EntityTypeManager.isSupportedEntityType(entityType)) {
                    EntityTypeManager.addSupportedEntityType(entityType);
                }
                return newPathfinderMob;
            }
            log.error("{} Invalid Entity type {} is not extending PathfinderMob!", (Object)LOG_PREFIX, entityType);
            if (entity != null) {
                entity.method_31472();
            }
            EntityTypeManager.addUnsupportedEntityType(entityType);
        }
        return null;
    }

    public static float getScaleFactor(class_1299<? extends class_1297> entityType) {
        return scaleFactorMap.getOrDefault(entityType, Float.valueOf(1.0f)).floatValue();
    }

    public static String getEntityTypeName(class_1299<? extends class_1297> entityType) {
        return entityTypeNameMap.getOrDefault(entityType, "Unknown");
    }
}

