/*
 * Decompiled with CFR 0.152.
 */
package de.markusbordihn.easynpc.client.screen;

import de.markusbordihn.easynpc.Constants;
import de.markusbordihn.easynpc.client.screen.components.Graphics;
import de.markusbordihn.easynpc.data.action.ActionEventSet;
import de.markusbordihn.easynpc.data.dialog.DialogButtonEntry;
import de.markusbordihn.easynpc.data.dialog.DialogDataEntry;
import de.markusbordihn.easynpc.data.dialog.DialogDataSet;
import de.markusbordihn.easynpc.data.render.RenderDataEntry;
import de.markusbordihn.easynpc.data.screen.AdditionalScreenDataInterface;
import de.markusbordihn.easynpc.data.screen.ScreenData;
import de.markusbordihn.easynpc.data.skin.SkinModel;
import de.markusbordihn.easynpc.entity.easynpc.EasyNPC;
import de.markusbordihn.easynpc.entity.easynpc.data.OwnerDataCapable;
import de.markusbordihn.easynpc.entity.easynpc.data.SkinDataCapable;
import de.markusbordihn.easynpc.menu.ClientMenuManager;
import java.util.UUID;
import net.minecraft.class_1297;
import net.minecraft.class_1309;
import net.minecraft.class_2561;
import net.minecraft.class_332;
import net.minecraft.class_437;

public interface ScreenInterface<D extends AdditionalScreenDataInterface> {
    public EasyNPC<?> getEasyNPC();

    public ScreenData getScreenData();

    public D getAdditionalScreenData();

    default public UUID getEasyNPCUUID() {
        return this.getScreenData().uuid();
    }

    default public class_1297 getEasyNPCEntity() {
        return this.getEasyNPC() != null ? this.getEasyNPC().getEntity() : null;
    }

    default public class_1309 getEasyNPCLivingEntity() {
        return this.getEasyNPC() != null ? this.getEasyNPC().getLivingEntity() : null;
    }

    default public OwnerDataCapable<?> getOwnerData() {
        return this.getEasyNPC().getEasyNPCOwnerData();
    }

    default public SkinModel getSkinModel() {
        if (this.getEasyNPCEntity() == null) {
            return null;
        }
        EasyNPC<?> easyNPC = this.getEasyNPC();
        SkinDataCapable skinData = easyNPC.getEasyNPCSkinData();
        return skinData != null ? skinData.getSkinModel() : null;
    }

    default public class_2561 getDialogText() {
        return this.hasDialogData() ? this.getDialogData().getDialogText() : null;
    }

    default public UUID getDialogUUID() {
        return this.getScreenData().dialogId();
    }

    default public UUID getDialogButtonUUID() {
        return this.getScreenData().dialogButtonId();
    }

    default public UUID getActionDataEntryUUID() {
        return this.getScreenData().actionDataEntryId();
    }

    default public UUID getConditionDataEntryUUID() {
        return this.getScreenData().conditionDataEntryId();
    }

    default public int getPageIndex() {
        return this.getScreenData().pageIndex();
    }

    default public ActionEventSet getActionEventSet() {
        return this.getAdditionalScreenData().getActionEventSet();
    }

    default public DialogDataSet getDialogDataSet() {
        return this.getAdditionalScreenData().getDialogDataSet();
    }

    default public RenderDataEntry getRenderDataEntry() {
        return this.getEasyNPC().getEasyNPCRenderData().getRenderDataEntry();
    }

    default public boolean hasDialogData() {
        return this.getDialogData() != null;
    }

    default public DialogDataEntry getDialogData() {
        UUID dialogId = this.getScreenData().dialogId();
        if (dialogId == null) {
            return null;
        }
        return this.getDialogData(dialogId);
    }

    default public DialogDataEntry getDialogData(UUID dialogUUID) {
        return this.getDialogDataSet().getDialog(dialogUUID);
    }

    default public DialogButtonEntry getDialogButtonData() {
        if (!this.hasDialog() || this.getScreenData().dialogButtonId() == null) {
            return null;
        }
        DialogDataEntry dialogData = this.getDialogData();
        if (dialogData == null) {
            return null;
        }
        return dialogData.getDialogButton(this.getScreenData().dialogButtonId());
    }

    default public boolean hasDialog() {
        return this.getDialogDataSet().hasDialog();
    }

    default public boolean isSwitchingToAnotherEasyNPCScreen(class_437 newScreen) {
        if (newScreen == this) {
            return true;
        }
        if (newScreen == null) {
            return ClientMenuManager.getScreenData() != null;
        }
        return newScreen instanceof ScreenInterface;
    }

    default public void renderDefaultScreenBg(class_332 guiGraphics, int leftPos, int topPos) {
        Graphics.blit(guiGraphics, Constants.TEXTURE_DEMO_BACKGROUND, leftPos, topPos, 0, 0, 220, 160);
        Graphics.blit(guiGraphics, Constants.TEXTURE_DEMO_BACKGROUND, leftPos + 213, topPos, 132, 0, 120, 160);
        Graphics.blit(guiGraphics, Constants.TEXTURE_DEMO_BACKGROUND, leftPos, topPos + 77, 0, 5, 220, 170);
        Graphics.blit(guiGraphics, Constants.TEXTURE_DEMO_BACKGROUND, leftPos + 213, topPos + 77, 132, 5, 120, 170);
    }

    default public void renderDefaultTitleBg(class_332 guiGraphics, int leftPos, int topPos) {
        Graphics.blit(guiGraphics, Constants.TEXTURE_DEMO_BACKGROUND, leftPos, topPos - 16, 0, 0, 248, 19);
    }
}

