/*
 * Decompiled with CFR 0.152.
 */
package de.markusbordihn.easynpc.client.texture;

import de.markusbordihn.easynpc.client.texture.RemoteTextureLoader;
import de.markusbordihn.easynpc.client.texture.TextureModelKey;
import de.markusbordihn.easynpc.utils.PlayersUtils;
import java.nio.file.Path;
import java.util.Map;
import java.util.Queue;
import java.util.UUID;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentLinkedQueue;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.TimeUnit;
import net.minecraft.class_2960;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public class AsyncTextureLoader {
    protected static final Logger log = LogManager.getLogger((String)"Easy NPC: Core");
    private static final String LOG_PREFIX = "[Async Texture Loader]";
    private static final ExecutorService textureLoadExecutor = Executors.newFixedThreadPool(2, runnable -> {
        Thread thread = new Thread(runnable);
        thread.setName("EasyNPC-Texture-Loader");
        thread.setPriority(1);
        thread.setDaemon(true);
        return thread;
    });
    private static final ScheduledExecutorService rateLimitScheduler = Executors.newSingleThreadScheduledExecutor(runnable -> {
        Thread thread = new Thread(runnable);
        thread.setName("EasyNPC-Texture-RateLimiter");
        thread.setPriority(1);
        thread.setDaemon(true);
        return thread;
    });
    private static final Queue<TextureLoadRequest> downloadQueue = new ConcurrentLinkedQueue<TextureLoadRequest>();
    private static final Map<TextureModelKey, CompletableFuture<class_2960>> pendingLoads = new ConcurrentHashMap<TextureModelKey, CompletableFuture<class_2960>>();
    private static volatile long lastDownloadTime = 0L;

    private AsyncTextureLoader() {
    }

    public static CompletableFuture<class_2960> loadTextureAsync(TextureModelKey key, String url, Path targetDirectory) {
        CompletableFuture<class_2960> existing = pendingLoads.get(key);
        if (existing != null) {
            return existing;
        }
        CompletableFuture<class_2960> future = new CompletableFuture<class_2960>();
        pendingLoads.put(key, future);
        downloadQueue.offer(new TextureLoadRequest(key, url, targetDirectory, future));
        return future;
    }

    public static CompletableFuture<class_2960> loadPlayerTextureAsync(TextureModelKey key, UUID playerUUID, Path targetDirectory) {
        CompletableFuture<class_2960> existing = pendingLoads.get(key);
        if (existing != null) {
            return existing;
        }
        CompletableFuture<class_2960> future = new CompletableFuture<class_2960>();
        pendingLoads.put(key, future);
        ((CompletableFuture)CompletableFuture.supplyAsync(() -> PlayersUtils.getUserTexture(playerUUID), textureLoadExecutor).thenAccept(url -> {
            if (url == null || url.isEmpty()) {
                log.error("{} Unable to get player skin URL for UUID: {}", (Object)LOG_PREFIX, (Object)playerUUID);
                pendingLoads.remove(key);
                future.complete(null);
            } else {
                log.debug("{} Got player skin URL for {}: {}", (Object)LOG_PREFIX, (Object)playerUUID, url);
                downloadQueue.offer(new TextureLoadRequest(key, (String)url, targetDirectory, future));
            }
        })).exceptionally(throwable -> {
            log.error("{} Failed to get player texture URL for {}: {}", (Object)LOG_PREFIX, (Object)playerUUID, (Object)throwable.getMessage());
            pendingLoads.remove(key);
            future.completeExceptionally((Throwable)throwable);
            return null;
        });
        return future;
    }

    private static void processQueue() {
        try {
            long now = System.currentTimeMillis();
            if (now - lastDownloadTime < 500L) {
                return;
            }
            TextureLoadRequest request = downloadQueue.poll();
            if (request == null) {
                return;
            }
            lastDownloadTime = now;
            CompletableFuture.supplyAsync(() -> RemoteTextureLoader.loadRemoteTexture(request.key, request.url, request.targetDirectory), textureLoadExecutor).whenComplete((result, throwable) -> {
                pendingLoads.remove(request.key);
                if (throwable != null) {
                    log.error("{} Failed to load texture {}: {}", (Object)LOG_PREFIX, (Object)request.key, (Object)throwable.getMessage());
                    request.future.completeExceptionally((Throwable)throwable);
                } else {
                    request.future.complete((class_2960)result);
                }
            });
        }
        catch (Exception e) {
            log.error("{} Error processing queue: {}", (Object)LOG_PREFIX, (Object)e.getMessage());
        }
    }

    public static void shutdown() {
        rateLimitScheduler.shutdown();
        textureLoadExecutor.shutdown();
    }

    static {
        rateLimitScheduler.scheduleAtFixedRate(AsyncTextureLoader::processQueue, 0L, 100L, TimeUnit.MILLISECONDS);
        Runtime.getRuntime().addShutdownHook(new Thread(() -> {
            log.debug("{} Shutting down texture loader executor services...", (Object)LOG_PREFIX);
            AsyncTextureLoader.shutdown();
        }, "EasyNPC-Texture-Loader-Shutdown"));
    }

    private record TextureLoadRequest(TextureModelKey key, String url, Path targetDirectory, CompletableFuture<class_2960> future) {
    }
}

