/*
 * Decompiled with CFR 0.152.
 */
package de.markusbordihn.easynpc.client.texture;

import de.markusbordihn.easynpc.Constants;
import de.markusbordihn.easynpc.client.texture.AsyncTextureLoader;
import de.markusbordihn.easynpc.client.texture.TextureManager;
import de.markusbordihn.easynpc.client.texture.TextureModelKey;
import de.markusbordihn.easynpc.data.skin.SkinModel;
import de.markusbordihn.easynpc.data.skin.SkinType;
import de.markusbordihn.easynpc.entity.easynpc.data.SkinDataCapable;
import de.markusbordihn.easynpc.io.PlayerSkinDataFiles;
import java.io.File;
import java.nio.file.Path;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import java.util.UUID;
import java.util.concurrent.ConcurrentHashMap;
import net.minecraft.class_2960;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public class PlayerTextureManager {
    protected static final Logger log = LogManager.getLogger((String)"Easy NPC: Core");
    private static final Map<TextureModelKey, class_2960> textureCache = new ConcurrentHashMap<TextureModelKey, class_2960>();
    private static final Map<TextureModelKey, SkinType> textureSkinTypeCache = new ConcurrentHashMap<TextureModelKey, SkinType>();
    private static final Map<UUID, Long> textureReloadProtection = new ConcurrentHashMap<UUID, Long>();
    private static final String LOG_PREFIX = "[Player Texture Manager] ";
    private static final long RELOAD_PROTECTION_TIME = 60000L;

    private PlayerTextureManager() {
    }

    public static Set<UUID> getTextureCacheKeys(SkinModel skinModel) {
        HashSet<UUID> hashSet = new HashSet<UUID>();
        for (TextureModelKey textureModelKey : textureCache.keySet()) {
            if (!skinModel.equals((Object)textureModelKey.getSkinModel()) || !PlayerTextureManager.hasTextureSkinData(textureModelKey)) continue;
            hashSet.add(textureModelKey.getUUID());
        }
        return hashSet;
    }

    public static SkinType getTextureSkinType(TextureModelKey textureModelKey) {
        return textureSkinTypeCache.get(textureModelKey);
    }

    public static boolean hasTextureSkinData(TextureModelKey textureModelKey) {
        return textureSkinTypeCache.containsKey(textureModelKey);
    }

    public static class_2960 getOrCreateTextureWithDefault(SkinDataCapable<?> skinData, class_2960 defaultResourceLocation) {
        UUID skinUUID = skinData.getSkinUUID();
        if (skinUUID.equals(Constants.BLANK_UUID)) {
            return defaultResourceLocation;
        }
        TextureModelKey textureModelKey = new TextureModelKey(skinUUID, skinData.getSkinModel());
        class_2960 resourceLocation = textureCache.get(textureModelKey);
        if (resourceLocation != null) {
            if (!PlayerTextureManager.hasTextureSkinData(textureModelKey)) {
                textureSkinTypeCache.put(textureModelKey, skinData.getSkinType());
            }
            return resourceLocation;
        }
        class_2960 createdResourceLocation = PlayerTextureManager.createTexture(textureModelKey, skinData, skinUUID);
        return createdResourceLocation != null ? createdResourceLocation : defaultResourceLocation;
    }

    private static class_2960 createTexture(TextureModelKey textureModelKey, SkinDataCapable<?> skinData, UUID playerUUID) {
        long currentTime = System.currentTimeMillis();
        Long lastAttempt = textureReloadProtection.get(playerUUID);
        if (lastAttempt != null && currentTime - lastAttempt < 60000L) {
            return null;
        }
        Long existingAttempt = textureReloadProtection.putIfAbsent(playerUUID, currentTime);
        if (existingAttempt != null && currentTime - existingAttempt < 60000L) {
            return null;
        }
        SkinModel skinModel = skinData.getSkinModel();
        Path textureDataFolder = PlayerSkinDataFiles.getPlayerSkinDataFolder(skinModel);
        if (textureDataFolder == null) {
            return null;
        }
        class_2960 localTextureCache = TextureManager.getCachedTexture(textureModelKey, textureDataFolder);
        if (localTextureCache != null) {
            textureCache.put(textureModelKey, localTextureCache);
            textureSkinTypeCache.put(textureModelKey, skinData.getSkinType());
            return localTextureCache;
        }
        AsyncTextureLoader.loadPlayerTextureAsync(textureModelKey, playerUUID, textureDataFolder).thenAccept(resourceLocation -> {
            if (resourceLocation != null) {
                log.info("{} Successfully loaded player texture for {}: {}", (Object)LOG_PREFIX, (Object)playerUUID, resourceLocation);
                textureCache.put(textureModelKey, (class_2960)resourceLocation);
                textureSkinTypeCache.put(textureModelKey, skinData.getSkinType());
            } else {
                log.error("{} Unable to load player {} texture {} from {}!", (Object)LOG_PREFIX, (Object)playerUUID, (Object)textureModelKey, (Object)textureDataFolder);
            }
        });
        return null;
    }

    public static void registerTexture(SkinModel skinModel, File textureFile) {
        PlayerTextureManager.registerTexture(TextureManager.getTextureModelKey(skinModel, textureFile), textureFile);
    }

    public static void registerTexture(TextureModelKey textureModelKey, File textureFile) {
        class_2960 resourceLocation = TextureManager.addCustomTexture(textureModelKey, textureFile);
        if (resourceLocation != null) {
            textureCache.put(textureModelKey, resourceLocation);
        }
    }

    public static void clearTextureCache() {
        textureReloadProtection.clear();
        textureCache.clear();
        textureSkinTypeCache.clear();
    }
}

