/*
 * Decompiled with CFR 0.152.
 */
package de.markusbordihn.easynpc.client.texture;

import de.markusbordihn.easynpc.client.texture.TextureModelKey;
import java.util.HashMap;
import java.util.Map;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public class TextureErrorHandler {
    protected static final Logger log = LogManager.getLogger((String)"Easy NPC: Core");
    private static final String LOG_PREFIX = "[Texture Error Handler]";
    private static final Map<TextureModelKey, String> errorMessageMap = new HashMap<TextureModelKey, String>();
    private static String lastErrorMessage;

    private TextureErrorHandler() {
    }

    public static void processingErrorMessage(TextureModelKey textureModelKey, String remoteUrl, String reason) {
        String errorMessage = String.format("Unable to process texture from %s: %s", remoteUrl, reason);
        log.error("{} {}", (Object)LOG_PREFIX, (Object)errorMessage);
        TextureErrorHandler.addErrorMessage(textureModelKey, errorMessage);
    }

    public static void urlLoadErrorMessage(TextureModelKey textureModelKey, String remoteUrl, String reason) {
        String errorMessage = String.format("Unable to load texture from %s: %s", remoteUrl, reason);
        log.error("{} {}", (Object)LOG_PREFIX, (Object)errorMessage);
        TextureErrorHandler.addErrorMessage(textureModelKey, errorMessage);
    }

    private static void addErrorMessage(TextureModelKey textureModelKey, String errorMessage) {
        errorMessageMap.put(textureModelKey, errorMessage);
        lastErrorMessage = errorMessage;
    }

    public static boolean hasLastErrorMessage() {
        return lastErrorMessage != null && !lastErrorMessage.isEmpty();
    }

    public static String getLastErrorMessage() {
        return lastErrorMessage;
    }

    public static void clearLastErrorMessage() {
        lastErrorMessage = null;
    }
}

