/*
 * Decompiled with CFR 0.152.
 */
package de.markusbordihn.easynpc.client.texture;

import java.io.File;
import java.io.FileInputStream;
import java.io.InputStream;
import net.minecraft.class_1011;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public class TextureImageLoader {
    protected static final Logger log = LogManager.getLogger((String)"Easy NPC: Core");
    private static final String LOG_PREFIX = "[Texture Image Loader]";

    private TextureImageLoader() {
    }

    public static class_1011 getNativeImage(File file) {
        return TextureImageLoader.getNativeImage(file, false);
    }

    public static class_1011 getNativePlayerImage(File file) {
        return TextureImageLoader.getNativeImage(file, true);
    }

    public static class_1011 getNativeImage(File file, boolean legacySupport) {
        class_1011 nativeImage;
        try (FileInputStream inputStream = new FileInputStream(file);){
            nativeImage = class_1011.method_4309((InputStream)inputStream);
        }
        catch (Exception exception) {
            log.error("{} Unable to get native image for file {} because of:", (Object)LOG_PREFIX, (Object)file, (Object)exception);
            return null;
        }
        if (legacySupport && nativeImage.method_4307() == 64 && nativeImage.method_4323() == 32) {
            log.info("{} Processing legacy image {} from 64x32 to 64x64 ...", (Object)LOG_PREFIX, (Object)nativeImage);
            nativeImage = TextureImageLoader.getNativeImageFromLegacyImage(nativeImage);
        }
        return nativeImage;
    }

    public static class_1011 getNativeImageFromLegacyImage(class_1011 legacyNativeImage) {
        class_1011 nativeImage = new class_1011(64, 64, true);
        nativeImage.method_4317(legacyNativeImage);
        legacyNativeImage.close();
        nativeImage.method_4326(0, 32, 64, 32, 0);
        nativeImage.method_4304(4, 16, 16, 32, 4, 4, true, false);
        nativeImage.method_4304(8, 16, 16, 32, 4, 4, true, false);
        nativeImage.method_4304(0, 20, 24, 32, 4, 12, true, false);
        nativeImage.method_4304(4, 20, 16, 32, 4, 12, true, false);
        nativeImage.method_4304(8, 20, 8, 32, 4, 12, true, false);
        nativeImage.method_4304(12, 20, 16, 32, 4, 12, true, false);
        nativeImage.method_4304(44, 16, -8, 32, 4, 4, true, false);
        nativeImage.method_4304(48, 16, -8, 32, 4, 4, true, false);
        nativeImage.method_4304(40, 20, 0, 32, 4, 12, true, false);
        nativeImage.method_4304(44, 20, -8, 32, 4, 12, true, false);
        nativeImage.method_4304(48, 20, -16, 32, 4, 12, true, false);
        nativeImage.method_4304(52, 20, -8, 32, 4, 12, true, false);
        return nativeImage;
    }
}

