/*
 * Decompiled with CFR 0.152.
 */
package de.markusbordihn.easynpc.client.texture;

import de.markusbordihn.easynpc.client.texture.RemoteTextureLoader;
import de.markusbordihn.easynpc.client.texture.TextureCacheManager;
import de.markusbordihn.easynpc.client.texture.TextureErrorHandler;
import de.markusbordihn.easynpc.client.texture.TextureImageLoader;
import de.markusbordihn.easynpc.client.texture.TextureModelKey;
import de.markusbordihn.easynpc.client.texture.TextureNameHelper;
import de.markusbordihn.easynpc.client.texture.TextureRegistrationHelper;
import de.markusbordihn.easynpc.data.skin.SkinModel;
import de.markusbordihn.easynpc.validator.ImageValidator;
import java.io.File;
import java.nio.file.Path;
import java.util.UUID;
import net.minecraft.class_1011;
import net.minecraft.class_2960;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public class TextureManager {
    protected static final Logger log = LogManager.getLogger((String)"Easy NPC: Core");
    private static final String LOG_PREFIX = "[Texture Manager]";

    private TextureManager() {
    }

    public static class_2960 addCustomTexture(TextureModelKey textureModelKey, File file) {
        class_1011 nativeImage;
        if (textureModelKey == null) {
            log.error("{} Texture model key for {} is invalid!", (Object)LOG_PREFIX, (Object)file);
            return null;
        }
        if (file == null || !file.exists() || !file.canRead() || file.isDirectory()) {
            log.error("{} Texture file {} is invalid!", (Object)LOG_PREFIX, (Object)file);
            return null;
        }
        class_1011 class_10112 = nativeImage = textureModelKey.getSkinModel() == SkinModel.HUMANOID || textureModelKey.getSkinModel() == SkinModel.HUMANOID_SLIM ? TextureImageLoader.getNativePlayerImage(file) : TextureImageLoader.getNativeImage(file);
        if (nativeImage == null) {
            log.error("{} Unable to load Texture file {} for {} because of I/O error", (Object)LOG_PREFIX, (Object)file, (Object)textureModelKey);
            return null;
        }
        if (!ImageValidator.isValidImage(nativeImage)) {
            log.error("{} Unable to get any valid texture from file {} for {}!", (Object)LOG_PREFIX, (Object)file, (Object)textureModelKey);
            nativeImage.close();
            return null;
        }
        return TextureRegistrationHelper.registerTexture(textureModelKey, nativeImage);
    }

    public static class_2960 addRemoteTexture(TextureModelKey textureModelKey, String remoteUrl, Path targetDirectory) {
        return RemoteTextureLoader.loadRemoteTexture(textureModelKey, remoteUrl, targetDirectory);
    }

    public static String getResourceName(TextureModelKey textureModelKey) {
        return TextureNameHelper.getResourceName(textureModelKey);
    }

    public static String getResourceName(String name, String type) {
        return TextureNameHelper.getResourceName(name, type);
    }

    public static String getFileName(UUID uuid) {
        return TextureNameHelper.getFileName(uuid);
    }

    public static String getFileName(String name) {
        return TextureNameHelper.getFileName(name);
    }

    public static class_2960 getCachedTexture(TextureModelKey textureModelKey, Path targetDirectory) {
        return TextureCacheManager.getCachedTexture(textureModelKey, targetDirectory);
    }

    public static class_2960 searchCachedTexture(TextureModelKey textureModelKey, Path targetDirectory) {
        return TextureCacheManager.searchCachedTexture(textureModelKey, targetDirectory);
    }

    public static TextureModelKey getTextureModelKey(SkinModel skinModel, File textureFile) {
        return TextureCacheManager.getTextureModelKey(skinModel, textureFile);
    }

    public static UUID getUUIDFromFilename(String fileName) {
        return TextureCacheManager.getUUIDFromFilename(fileName);
    }

    public static boolean hasLastErrorMessage() {
        return TextureErrorHandler.hasLastErrorMessage();
    }

    public static String getLastErrorMessage() {
        return TextureErrorHandler.getLastErrorMessage();
    }

    public static void clearLastErrorMessage() {
        TextureErrorHandler.clearLastErrorMessage();
    }
}

