/*
 * Decompiled with CFR 0.152.
 */
package de.markusbordihn.easynpc.client.texture;

import de.markusbordihn.easynpc.Constants;
import de.markusbordihn.easynpc.data.skin.SkinModel;
import java.util.EnumMap;
import java.util.HashMap;
import java.util.Map;
import net.minecraft.class_2960;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public class VariantTextureManager {
    protected static final Logger log = LogManager.getLogger((String)"Easy NPC: Core");
    private static final EnumMap<SkinModel, Map<Enum<?>, class_2960>> textureRegistry = new EnumMap(SkinModel.class);
    private static final String LOG_PREFIX = "[Variant Texture Manager] ";

    private VariantTextureManager() {
    }

    public static void registerVariantTexture(SkinModel skinModel, Enum<?> variantType, class_2960 texture) {
        if (skinModel == null || variantType == null || texture == null) {
            log.warn("{} Invalid registration attempt: skinModel={}, variantType={}, texture={}", (Object)LOG_PREFIX, (Object)skinModel, variantType, (Object)texture);
            return;
        }
        textureRegistry.computeIfAbsent(skinModel, k -> new HashMap()).put(variantType, texture);
        log.debug("{} Registered variant texture for {} - {}: {}", (Object)LOG_PREFIX, (Object)skinModel, variantType, (Object)texture);
    }

    public static void registerVariantTextures(SkinModel skinModel, Map<? extends Enum<?>, class_2960> textures) {
        if (skinModel == null || textures == null || textures.isEmpty()) {
            log.warn("{} Invalid bulk registration attempt: skinModel={}, textures={}", (Object)LOG_PREFIX, (Object)skinModel, textures);
            return;
        }
        Map variantMap = textureRegistry.computeIfAbsent(skinModel, k -> new HashMap());
        variantMap.putAll(textures);
        log.debug("{} Registered {} variant textures for {}", (Object)LOG_PREFIX, (Object)textures.size(), (Object)skinModel);
    }

    public static class_2960 getVariantTexture(SkinModel skinModel, Enum<?> variantType) {
        if (skinModel == null || variantType == null) {
            return Constants.BLANK_ENTITY_TEXTURE;
        }
        Map<Enum<?>, class_2960> variantMap = textureRegistry.get((Object)skinModel);
        if (variantMap == null) {
            return Constants.BLANK_ENTITY_TEXTURE;
        }
        return variantMap.getOrDefault(variantType, Constants.BLANK_ENTITY_TEXTURE);
    }

    public static class_2960 getVariantTextureOrDefault(SkinModel skinModel, Enum<?> variantType, class_2960 defaultTexture) {
        class_2960 texture = VariantTextureManager.getVariantTexture(skinModel, variantType);
        return texture.equals((Object)Constants.BLANK_ENTITY_TEXTURE) ? defaultTexture : texture;
    }

    public static boolean hasVariantTexture(SkinModel skinModel, Enum<?> variantType) {
        if (skinModel == null || variantType == null) {
            return false;
        }
        Map<Enum<?>, class_2960> variantMap = textureRegistry.get((Object)skinModel);
        return variantMap != null && variantMap.containsKey(variantType);
    }

    public static Map<Enum<?>, class_2960> getVariantTextures(SkinModel skinModel) {
        return textureRegistry.get((Object)skinModel);
    }

    public static void clearVariantTextureCache() {
        textureRegistry.clear();
        log.info("{} Cleared variant texture cache", (Object)LOG_PREFIX);
    }
}

