/*
 * Decompiled with CFR 0.152.
 */
package de.markusbordihn.easynpc.data.condition;

import de.markusbordihn.easynpc.data.condition.ConditionOperationType;
import de.markusbordihn.easynpc.data.condition.ConditionType;
import java.util.UUID;
import net.minecraft.class_2487;

public record ConditionDataEntry(ConditionType conditionType, ConditionOperationType operationType, String name, int value, String text) {
    public static final ConditionDataEntry EMPTY = new ConditionDataEntry(ConditionType.NONE, ConditionOperationType.NONE);
    public static final String DATA_TYPE_TAG = "Type";
    public static final String DATA_OPERATION_TAG = "Operation";
    public static final String DATA_NAME_TAG = "Name";
    public static final String DATA_VALUE_TAG = "Value";
    public static final String DATA_TEXT_TAG = "Text";

    public ConditionDataEntry(class_2487 compoundTag) {
        this(ConditionType.get(compoundTag.method_10558(DATA_TYPE_TAG)), ConditionOperationType.get(compoundTag.method_10558(DATA_OPERATION_TAG)), compoundTag.method_10545(DATA_NAME_TAG) ? compoundTag.method_10558(DATA_NAME_TAG) : "", compoundTag.method_10545(DATA_VALUE_TAG) ? compoundTag.method_10550(DATA_VALUE_TAG) : 0, compoundTag.method_10545(DATA_TEXT_TAG) ? compoundTag.method_10558(DATA_TEXT_TAG) : "");
    }

    public ConditionDataEntry(ConditionType conditionType) {
        this(conditionType, ConditionOperationType.NONE);
    }

    public ConditionDataEntry(ConditionType conditionType, ConditionOperationType operationType) {
        this(conditionType, operationType, "", 0, "");
    }

    public ConditionDataEntry(ConditionType conditionType, ConditionOperationType operationType, String name, int value) {
        this(conditionType, operationType, name, value, "");
    }

    public UUID getId() {
        String idString = DATA_TYPE_TAG + this.hashCode();
        return UUID.nameUUIDFromBytes(idString.getBytes());
    }

    public boolean hasName() {
        return this.name != null && !this.name.isEmpty();
    }

    public boolean hasStringValue() {
        return this.text != null && !this.text.isEmpty();
    }

    public boolean isValid() {
        if (this.conditionType == ConditionType.NONE) {
            return false;
        }
        return switch (this.conditionType) {
            case ConditionType.SCOREBOARD -> {
                if (this.hasName() && this.operationType != null && this.operationType != ConditionOperationType.NONE) {
                    yield true;
                }
                yield false;
            }
            case ConditionType.EXECUTION_LIMIT -> {
                if (this.value > 0 && this.hasStringValue()) {
                    yield true;
                }
                yield false;
            }
            default -> true;
        };
    }

    public ConditionDataEntry withConditionType(ConditionType conditionType) {
        return new ConditionDataEntry(conditionType, this.operationType, this.name, this.value, this.text);
    }

    public ConditionDataEntry withOperationType(ConditionOperationType operationType) {
        return new ConditionDataEntry(this.conditionType, operationType, this.name, this.value, this.text);
    }

    public ConditionDataEntry withName(String name) {
        return new ConditionDataEntry(this.conditionType, this.operationType, name, this.value, this.text);
    }

    public ConditionDataEntry withValue(int value) {
        return new ConditionDataEntry(this.conditionType, this.operationType, this.name, value, this.text);
    }

    public ConditionDataEntry withStringValue(String stringValue) {
        return new ConditionDataEntry(this.conditionType, this.operationType, this.name, this.value, stringValue);
    }

    public ConditionDataEntry create(class_2487 compoundTag) {
        return new ConditionDataEntry(compoundTag);
    }

    public class_2487 write(class_2487 compoundTag) {
        compoundTag.method_10582(DATA_TYPE_TAG, this.conditionType.name());
        if (this.operationType != null && this.operationType != ConditionOperationType.NONE) {
            compoundTag.method_10582(DATA_OPERATION_TAG, this.operationType.name());
        }
        if (this.hasName()) {
            compoundTag.method_10582(DATA_NAME_TAG, this.name.trim());
        }
        if (this.value != 0) {
            compoundTag.method_10569(DATA_VALUE_TAG, this.value);
        }
        if (this.hasStringValue()) {
            compoundTag.method_10582(DATA_TEXT_TAG, this.text);
        }
        return compoundTag;
    }

    public class_2487 createTag() {
        return this.write(new class_2487());
    }
}

