/*
 * Decompiled with CFR 0.152.
 */
package de.markusbordihn.easynpc.data.condition;

import de.markusbordihn.easynpc.data.condition.ConditionDataEntry;
import java.util.ArrayList;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Set;
import java.util.UUID;
import net.minecraft.class_2487;
import net.minecraft.class_2499;
import net.minecraft.class_2520;

public class ConditionDataSet {
    public static final ConditionDataSet EMPTY = new ConditionDataSet();
    public static final String CONDITION_DATA_SET_TAG = "ConditionDataSet";
    private final Set<ConditionDataEntry> conditionDataEntries = new LinkedHashSet<ConditionDataEntry>();

    public ConditionDataSet() {
    }

    public ConditionDataSet(Set<ConditionDataEntry> conditionDataEntries) {
        if (conditionDataEntries != null) {
            this.conditionDataEntries.addAll(conditionDataEntries);
        }
    }

    public ConditionDataSet(class_2487 compoundTag) {
        this.load(compoundTag);
    }

    public boolean isEmpty() {
        return this.conditionDataEntries.isEmpty();
    }

    public int size() {
        return this.conditionDataEntries.size();
    }

    public Set<ConditionDataEntry> getConditions() {
        return new LinkedHashSet<ConditionDataEntry>(this.conditionDataEntries);
    }

    public List<ConditionDataEntry> getConditionsList() {
        return new ArrayList<ConditionDataEntry>(this.conditionDataEntries);
    }

    public ConditionDataEntry getCondition(UUID id) {
        for (ConditionDataEntry entry : this.conditionDataEntries) {
            if (!entry.getId().equals(id)) continue;
            return entry;
        }
        return null;
    }

    public boolean hasCondition(UUID id) {
        return this.getCondition(id) != null;
    }

    public void add(ConditionDataEntry conditionDataEntry) {
        if (conditionDataEntry != null && conditionDataEntry.isValid()) {
            this.remove(conditionDataEntry.getId());
            this.conditionDataEntries.add(conditionDataEntry);
        }
    }

    public boolean remove(UUID id) {
        return this.conditionDataEntries.removeIf(entry -> entry.getId().equals(id));
    }

    public void put(UUID conditionDataEntryId, ConditionDataEntry conditionDataEntry) {
        if (conditionDataEntryId == null || conditionDataEntry == null) {
            return;
        }
        this.remove(conditionDataEntryId);
        if (conditionDataEntry.isValid()) {
            this.conditionDataEntries.add(conditionDataEntry);
        }
    }

    public void update(ConditionDataEntry conditionDataEntry) {
        if (conditionDataEntry != null && conditionDataEntry.isValid()) {
            this.remove(conditionDataEntry.getId());
            this.conditionDataEntries.add(conditionDataEntry);
        }
    }

    public void clear() {
        this.conditionDataEntries.clear();
    }

    public void load(class_2487 compoundTag) {
        if (compoundTag == null || !compoundTag.method_10545(CONDITION_DATA_SET_TAG)) {
            return;
        }
        class_2487 conditionDataSetTag = compoundTag.method_10562(CONDITION_DATA_SET_TAG);
        this.conditionDataEntries.clear();
        class_2499 conditionDataEntriesTag = conditionDataSetTag.method_10554(CONDITION_DATA_SET_TAG, 10);
        for (int i = 0; i < conditionDataEntriesTag.size(); ++i) {
            class_2487 conditionDataEntryTag = conditionDataEntriesTag.method_10602(i);
            ConditionDataEntry conditionDataEntry = new ConditionDataEntry(conditionDataEntryTag);
            if (!conditionDataEntry.isValid()) continue;
            this.conditionDataEntries.add(conditionDataEntry);
        }
    }

    public class_2487 save(class_2487 compoundTag) {
        return this.save(compoundTag, CONDITION_DATA_SET_TAG);
    }

    public class_2487 save(class_2487 compoundTag, String tag) {
        if (this.isEmpty()) {
            return compoundTag;
        }
        class_2487 conditionDataSetTag = new class_2487();
        class_2499 conditionDataEntriesTag = new class_2499();
        for (ConditionDataEntry conditionDataEntry : this.conditionDataEntries) {
            if (conditionDataEntry == null || !conditionDataEntry.isValid()) continue;
            conditionDataEntriesTag.add((Object)conditionDataEntry.createTag());
        }
        if (!conditionDataEntriesTag.isEmpty()) {
            conditionDataSetTag.method_10566(CONDITION_DATA_SET_TAG, (class_2520)conditionDataEntriesTag);
            compoundTag.method_10566(tag, (class_2520)conditionDataSetTag);
        }
        return compoundTag;
    }

    public boolean hasConditionData() {
        return !this.isEmpty();
    }

    public boolean equals(Object object) {
        if (this == object) {
            return true;
        }
        if (object == null || this.getClass() != object.getClass()) {
            return false;
        }
        ConditionDataSet other = (ConditionDataSet)object;
        return this.conditionDataEntries.equals(other.conditionDataEntries);
    }

    public int hashCode() {
        return this.conditionDataEntries.hashCode();
    }

    public String toString() {
        return "ConditionDataSet[size=" + this.size() + ", entries=" + String.valueOf(this.conditionDataEntries) + "]";
    }
}

