/*
 * Decompiled with CFR 0.152.
 */
package de.markusbordihn.easynpc.data.dialog;

import de.markusbordihn.easynpc.data.action.ActionDataSet;
import de.markusbordihn.easynpc.data.condition.ConditionDataEntry;
import de.markusbordihn.easynpc.data.dialog.DialogButtonType;
import de.markusbordihn.easynpc.data.dialog.DialogUtils;
import de.markusbordihn.easynpc.network.components.TextComponent;
import de.markusbordihn.easynpc.utils.TextUtils;
import de.markusbordihn.easynpc.utils.UUIDUtils;
import java.util.LinkedHashSet;
import java.util.Objects;
import java.util.Set;
import java.util.UUID;
import net.minecraft.class_2487;
import net.minecraft.class_2499;
import net.minecraft.class_2520;
import net.minecraft.class_2561;
import net.minecraft.class_5250;

public record DialogButtonEntry(UUID id, String name, String label, DialogButtonType type, ActionDataSet actionDataSet, Set<ConditionDataEntry> conditions, boolean isTranslationKey) {
    public static final String DATA_ACTIONS_TAG = "Actions";
    public static final String DATA_CONDITIONS_TAG = "Conditions";
    public static final String DATA_BUTTON_NAME_TAG = "Name";
    public static final String DATA_LABEL_TAG = "Label";
    public static final String DATA_TYPE_TAG = "Type";
    public static final int MAX_BUTTON_LABEL_LENGTH = 32;

    public DialogButtonEntry(class_2487 compoundTag) {
        this(compoundTag.method_10558(DATA_BUTTON_NAME_TAG), compoundTag.method_10558(DATA_LABEL_TAG), DialogButtonType.get(compoundTag.method_10558(DATA_TYPE_TAG)), new ActionDataSet(compoundTag, DATA_ACTIONS_TAG), DialogButtonEntry.loadConditions(compoundTag));
    }

    public DialogButtonEntry(String name, String label, ActionDataSet actionDataSet) {
        this(name, label, DialogButtonType.DEFAULT, actionDataSet, new LinkedHashSet<ConditionDataEntry>());
    }

    public DialogButtonEntry(String name, DialogButtonType type) {
        this(name, null, type, new ActionDataSet(), new LinkedHashSet<ConditionDataEntry>());
    }

    public DialogButtonEntry(String name, String label, DialogButtonType type, ActionDataSet actionDataSet) {
        this(name, label, type, actionDataSet, new LinkedHashSet<ConditionDataEntry>());
    }

    public DialogButtonEntry(String name, String label, DialogButtonType type, ActionDataSet actionDataSet, Set<ConditionDataEntry> conditions) {
        this(UUIDUtils.textToUUID(label != null && !label.isEmpty() ? label : DialogUtils.generateButtonLabel(name)), name, label != null && !label.isEmpty() ? label : DialogUtils.generateButtonLabel(name), type != null ? type : DialogButtonType.DEFAULT, actionDataSet != null ? actionDataSet : new ActionDataSet(), conditions != null ? conditions : new LinkedHashSet<ConditionDataEntry>(), TextUtils.isTranslationKey(name));
    }

    private static Set<ConditionDataEntry> loadConditions(class_2487 compoundTag) {
        LinkedHashSet<ConditionDataEntry> conditions = new LinkedHashSet<ConditionDataEntry>();
        if (compoundTag.method_10545(DATA_CONDITIONS_TAG)) {
            class_2499 conditionsList = compoundTag.method_10554(DATA_CONDITIONS_TAG, 10);
            for (int i = 0; i < conditionsList.size(); ++i) {
                ConditionDataEntry condition = new ConditionDataEntry(conditionsList.method_10602(i));
                if (!condition.isValid()) continue;
                conditions.add(condition);
            }
        }
        return conditions;
    }

    public class_2561 getButtonName(int maxLength) {
        class_5250 buttonName = TextComponent.getTextComponentRaw(this.name, this.isTranslationKey);
        if (buttonName.getString().length() > maxLength) {
            buttonName = TextComponent.getText(buttonName.getString().substring(0, maxLength - 1) + "\u2026");
        }
        return buttonName;
    }

    public boolean hasActionData() {
        return this.actionDataSet != null && this.actionDataSet.hasActionData();
    }

    public boolean hasConditions() {
        return this.conditions != null && !this.conditions.isEmpty();
    }

    public DialogButtonEntry withName(String name) {
        return new DialogButtonEntry(this.id, name, this.label, this.type, this.actionDataSet, this.conditions, TextUtils.isTranslationKey(name));
    }

    public DialogButtonEntry withLabel(String label) {
        return new DialogButtonEntry(UUIDUtils.textToUUID(label != null && !label.isEmpty() ? label : this.name), this.name, label, this.type, this.actionDataSet, this.conditions, this.isTranslationKey);
    }

    public DialogButtonEntry withActionDataSet(ActionDataSet actionDataSet) {
        return new DialogButtonEntry(this.id, this.name, this.label, this.type, actionDataSet != null ? actionDataSet : new ActionDataSet(), this.conditions, this.isTranslationKey);
    }

    public DialogButtonEntry withConditions(Set<ConditionDataEntry> conditions) {
        return new DialogButtonEntry(this.id, this.name, this.label, this.type, this.actionDataSet, conditions != null ? conditions : new LinkedHashSet<ConditionDataEntry>(), this.isTranslationKey);
    }

    public class_2487 write(class_2487 compoundTag) {
        compoundTag.method_10582(DATA_BUTTON_NAME_TAG, this.name.trim());
        if (this.type != DialogButtonType.DEFAULT) {
            compoundTag.method_10582(DATA_TYPE_TAG, this.type.name());
        }
        if (this.label != null && !Objects.equals(DialogUtils.generateButtonLabel(this.name), this.label)) {
            compoundTag.method_10582(DATA_LABEL_TAG, this.label);
        }
        this.actionDataSet.save(compoundTag, DATA_ACTIONS_TAG);
        if (this.conditions != null && !this.conditions.isEmpty()) {
            class_2499 conditionsList = new class_2499();
            for (ConditionDataEntry condition : this.conditions) {
                if (!condition.isValid()) continue;
                conditionsList.add((Object)condition.createTag());
            }
            if (!conditionsList.isEmpty()) {
                compoundTag.method_10566(DATA_CONDITIONS_TAG, (class_2520)conditionsList);
            }
        }
        return compoundTag;
    }

    public class_2487 createTag() {
        return this.write(new class_2487());
    }

    @Override
    public String toString() {
        return "DialogButtonData [id=" + String.valueOf(this.id) + ", name=" + this.name + ", label=" + this.label + ", type=" + String.valueOf((Object)this.type) + ", isTranslationKey=" + this.isTranslationKey + ", actionDataSet=" + String.valueOf(this.actionDataSet) + ", conditions=" + String.valueOf(this.conditions) + "]";
    }
}

