/*
 * Decompiled with CFR 0.152.
 */
package de.markusbordihn.easynpc.data.dialog;

import de.markusbordihn.easynpc.data.condition.ConditionDataEntry;
import de.markusbordihn.easynpc.data.dialog.DialogButtonEntry;
import de.markusbordihn.easynpc.data.dialog.DialogMetaData;
import de.markusbordihn.easynpc.data.dialog.DialogPriority;
import de.markusbordihn.easynpc.data.dialog.DialogTextData;
import de.markusbordihn.easynpc.data.dialog.DialogUtils;
import java.util.LinkedHashSet;
import java.util.Objects;
import java.util.Set;
import java.util.UUID;
import java.util.concurrent.ThreadLocalRandom;
import net.minecraft.class_2487;
import net.minecraft.class_2499;
import net.minecraft.class_2520;
import net.minecraft.class_2561;

public final class DialogDataEntry {
    public static final String DATA_BUTTONS_TAG = "Buttons";
    public static final String DATA_CONDITIONS_TAG = "Conditions";
    public static final String DATA_DIALOG_NAME = "Name";
    public static final String DATA_LABEL_TAG = "Label";
    public static final String DATA_PRIORITY_TAG = "Priority";
    public static final String DATA_TEXTS_TAG = "Texts";
    public static final String DATA_TEXT_TAG = "Text";
    public static final int MAX_DIALOG_LABEL_LENGTH = 32;
    private Set<DialogButtonEntry> dialogButtons = new LinkedHashSet<DialogButtonEntry>();
    private Set<DialogTextData> dialogTexts = new LinkedHashSet<DialogTextData>();
    private Set<ConditionDataEntry> conditions = new LinkedHashSet<ConditionDataEntry>();
    private UUID id;
    private String label = "";
    private String name;
    private int priority;

    public DialogDataEntry(class_2487 compoundTag) {
        this.load(compoundTag);
    }

    public DialogDataEntry(String name) {
        this(null, name, "Dialog text", null);
    }

    public DialogDataEntry(String name, String text) {
        this("default", name, text, null);
    }

    public DialogDataEntry(String label, String name, String text) {
        this(label, name, text, null);
    }

    public DialogDataEntry(String label, String name, String text, Set<DialogButtonEntry> dialogButtons) {
        this.label = DialogUtils.generateButtonLabel(label != null && !label.isEmpty() ? label : name);
        this.id = UUID.nameUUIDFromBytes(this.label.getBytes());
        this.name = name != null ? name.trim() : this.label;
        this.dialogButtons = dialogButtons != null ? dialogButtons : new LinkedHashSet();
        this.dialogTexts.add(new DialogTextData(text));
        this.priority = DialogPriority.calculateDefaultPriority(this.label);
    }

    public UUID getId() {
        return this.id;
    }

    public String getLabel() {
        return this.label;
    }

    public void setLabel(String label) {
        this.label = DialogUtils.generateButtonLabel(label != null && !label.isEmpty() ? label : this.name);
        this.id = UUID.nameUUIDFromBytes(this.label.getBytes());
    }

    public String getLabel(int maxLength) {
        return this.label.length() > maxLength ? this.label.substring(0, maxLength - 1) + "\u2026" : this.label;
    }

    public String getName() {
        return this.name;
    }

    public void setName(String name) {
        this.name = name != null ? name.trim() : "";
    }

    public String getName(int maxLength) {
        return this.name.length() > maxLength ? this.name.substring(0, maxLength - 1) + "\u2026" : this.name;
    }

    public String getText() {
        return this.dialogTexts.iterator().next().text();
    }

    public class_2561 getDialogText() {
        if (this.dialogTexts == null || this.dialogTexts.isEmpty()) {
            return class_2561.method_43473();
        }
        DialogTextData dialogTextData = this.dialogTexts.size() == 1 ? this.dialogTexts.iterator().next() : (DialogTextData)this.dialogTexts.stream().skip(ThreadLocalRandom.current().nextInt(this.dialogTexts.size())).findFirst().orElse(null);
        return dialogTextData != null ? dialogTextData.getDialogText() : class_2561.method_43473();
    }

    public String getText(int maxLength) {
        return this.dialogTexts.iterator().next().getText(maxLength);
    }

    public String getDialogText(DialogMetaData dialogMetaData) {
        return DialogUtils.parseDialogText(this.getDialogText(), dialogMetaData);
    }

    public Set<DialogTextData> getDialogTexts() {
        return this.dialogTexts;
    }

    public void setDialogTexts(Set<DialogTextData> dialogTexts) {
        this.dialogTexts = dialogTexts != null ? dialogTexts : new LinkedHashSet();
    }

    public Set<DialogButtonEntry> getDialogButtons() {
        return this.dialogButtons;
    }

    public void setDialogButtons(Set<DialogButtonEntry> buttons) {
        this.dialogButtons = buttons != null ? buttons : new LinkedHashSet();
    }

    public Set<ConditionDataEntry> getConditions() {
        return this.conditions;
    }

    public void setConditions(Set<ConditionDataEntry> conditions) {
        this.conditions = conditions != null ? conditions : new LinkedHashSet();
    }

    public boolean hasConditions() {
        return this.conditions != null && !this.conditions.isEmpty();
    }

    public int getPriority() {
        return this.priority;
    }

    public void setPriority(int priority) {
        this.priority = priority < -1 ? -1 : priority;
    }

    public DialogButtonEntry getDialogButton(UUID dialogButtonId) {
        for (DialogButtonEntry button : this.dialogButtons) {
            if (!button.id().equals(dialogButtonId)) continue;
            return button;
        }
        return null;
    }

    public DialogButtonEntry getDialogButton(String label) {
        for (DialogButtonEntry button : this.dialogButtons) {
            if (!button.label().equals(label)) continue;
            return button;
        }
        return null;
    }

    public void setDialogButton(DialogButtonEntry dialogButtonEntry) {
        this.setDialogButton(dialogButtonEntry.id(), dialogButtonEntry);
    }

    public void setDialogButton(UUID dialogButtonId, DialogButtonEntry dialogButtonEntry) {
        if (dialogButtonId != null) {
            for (DialogButtonEntry button : this.dialogButtons) {
                if (!button.id().equals(dialogButtonId)) continue;
                this.dialogButtons.remove(button);
                this.dialogButtons.add(dialogButtonEntry);
                return;
            }
        }
        this.dialogButtons.add(dialogButtonEntry);
    }

    public boolean hasDialogButton(String label) {
        for (DialogButtonEntry button : this.dialogButtons) {
            if (!button.label().equals(label)) continue;
            return true;
        }
        return false;
    }

    public boolean hasDialogButton(UUID dialogButtonId) {
        for (DialogButtonEntry button : this.dialogButtons) {
            if (!button.id().equals(dialogButtonId)) continue;
            return true;
        }
        return false;
    }

    public boolean removeDialogButton(UUID dialogButtonId) {
        for (DialogButtonEntry button : this.dialogButtons) {
            if (!button.id().equals(dialogButtonId)) continue;
            this.dialogButtons.remove(button);
            return true;
        }
        return false;
    }

    public int getNumberOfDialogButtons() {
        return this.dialogButtons.size();
    }

    public void load(class_2487 compoundTag) {
        int i;
        this.name = compoundTag.method_10558(DATA_DIALOG_NAME);
        this.setLabel(compoundTag.method_10545(DATA_LABEL_TAG) ? compoundTag.method_10558(DATA_LABEL_TAG) : this.name);
        if (compoundTag.method_10545(DATA_TEXTS_TAG)) {
            this.dialogTexts.clear();
            class_2499 dialogTextsList = compoundTag.method_10554(DATA_TEXTS_TAG, 10);
            if (!dialogTextsList.isEmpty()) {
                for (i = 0; i < dialogTextsList.size(); ++i) {
                    this.dialogTexts.add(new DialogTextData(dialogTextsList.method_10602(i)));
                }
            }
        } else if (compoundTag.method_10545(DATA_TEXT_TAG)) {
            this.dialogTexts.clear();
            this.dialogTexts.add(new DialogTextData(compoundTag.method_10558(DATA_TEXT_TAG)));
        }
        if (compoundTag.method_10545(DATA_BUTTONS_TAG)) {
            this.dialogButtons.clear();
            class_2499 buttonsList = compoundTag.method_10554(DATA_BUTTONS_TAG, 10);
            if (!buttonsList.isEmpty()) {
                for (i = 0; i < buttonsList.size(); ++i) {
                    this.dialogButtons.add(new DialogButtonEntry(buttonsList.method_10602(i)));
                }
            }
        }
        if (compoundTag.method_10545(DATA_CONDITIONS_TAG)) {
            this.conditions.clear();
            class_2499 conditionsList = compoundTag.method_10554(DATA_CONDITIONS_TAG, 10);
            if (!conditionsList.isEmpty()) {
                for (i = 0; i < conditionsList.size(); ++i) {
                    ConditionDataEntry conditionEntry = new ConditionDataEntry(conditionsList.method_10602(i));
                    if (!conditionEntry.isValid()) continue;
                    this.conditions.add(conditionEntry);
                }
            }
        }
        this.priority = compoundTag.method_10545(DATA_PRIORITY_TAG) ? compoundTag.method_10550(DATA_PRIORITY_TAG) : DialogPriority.calculateDefaultPriority(this.label);
    }

    public class_2487 save(class_2487 compoundTag) {
        int defaultPriority;
        compoundTag.method_10582(DATA_DIALOG_NAME, this.name.trim());
        if (!Objects.equals(DialogUtils.generateDialogLabel(this.name), this.label)) {
            compoundTag.method_10582(DATA_LABEL_TAG, this.label);
        }
        if (this.dialogTexts != null && !this.dialogTexts.isEmpty()) {
            class_2499 dialogTextsList = new class_2499();
            for (DialogTextData dialogText : this.dialogTexts) {
                dialogTextsList.add((Object)dialogText.write(new class_2487()));
            }
            compoundTag.method_10566(DATA_TEXTS_TAG, (class_2520)dialogTextsList);
        }
        if (this.dialogButtons != null && !this.dialogButtons.isEmpty()) {
            class_2499 buttonsList = new class_2499();
            for (DialogButtonEntry button : this.dialogButtons) {
                buttonsList.add((Object)button.write(new class_2487()));
            }
            compoundTag.method_10566(DATA_BUTTONS_TAG, (class_2520)buttonsList);
        }
        if (this.conditions != null && !this.conditions.isEmpty()) {
            class_2499 conditionsList = new class_2499();
            for (ConditionDataEntry condition : this.conditions) {
                if (!condition.isValid()) continue;
                conditionsList.add((Object)condition.createTag());
            }
            if (!conditionsList.isEmpty()) {
                compoundTag.method_10566(DATA_CONDITIONS_TAG, (class_2520)conditionsList);
            }
        }
        if (this.priority != (defaultPriority = DialogPriority.calculateDefaultPriority(this.label))) {
            compoundTag.method_10569(DATA_PRIORITY_TAG, this.priority);
        }
        return compoundTag;
    }

    public class_2487 createTag() {
        return this.save(new class_2487());
    }

    public String toString() {
        return "DialogData [id=" + String.valueOf(this.id) + ", name=" + this.name + ", label=" + this.label + ", texts=" + String.valueOf(this.dialogTexts) + ", buttons=" + String.valueOf(this.dialogButtons) + ", conditions=" + String.valueOf(this.conditions) + "]";
    }
}

