/*
 * Decompiled with CFR 0.152.
 */
package de.markusbordihn.easynpc.data.dialog;

import de.markusbordihn.easynpc.data.condition.ConditionDataEntry;
import de.markusbordihn.easynpc.data.condition.ConditionType;
import de.markusbordihn.easynpc.data.condition.ConditionUtils;
import de.markusbordihn.easynpc.data.dialog.DialogButtonEntry;
import de.markusbordihn.easynpc.data.dialog.DialogDataEntry;
import de.markusbordihn.easynpc.data.dialog.DialogType;
import de.markusbordihn.easynpc.network.syncher.EntityDataSerializersManager;
import java.util.Comparator;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.UUID;
import net.minecraft.class_2487;
import net.minecraft.class_2499;
import net.minecraft.class_2520;
import net.minecraft.class_266;
import net.minecraft.class_269;
import net.minecraft.class_3222;
import net.minecraft.class_9015;
import net.minecraft.class_9129;
import net.minecraft.class_9139;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public class DialogDataSet {
    public static final String DATA_DIALOG_DATA_SET_TAG = "DialogDataSet";
    public static final String DATA_TYPE_TAG = "Type";
    public static final class_9139<class_9129, DialogDataSet> STREAM_CODEC = new class_9139<class_9129, DialogDataSet>(){

        public DialogDataSet decode(class_9129 registryFriendlyByteBuf) {
            return new DialogDataSet(registryFriendlyByteBuf.method_10798());
        }

        public void encode(class_9129 registryFriendlyByteBuf, DialogDataSet dialogDataSet) {
            registryFriendlyByteBuf.method_10794((class_2520)EntityDataSerializersManager.validateAndGetNbt(dialogDataSet.createTag(), DialogDataSet.DATA_DIALOG_DATA_SET_TAG));
        }
    };
    private static final Logger log = LogManager.getLogger((String)"Easy NPC: Core");
    private final HashMap<String, DialogDataEntry> dialogByLabelMap = new HashMap();
    private final HashMap<UUID, DialogDataEntry> dialogByIdMap = new HashMap();
    private DialogType dialogType = DialogType.STANDARD;

    public DialogDataSet() {
    }

    public DialogDataSet(DialogType dialogType) {
        this.dialogType = dialogType;
    }

    public DialogDataSet(class_2487 compoundTag) {
        this.load(compoundTag);
    }

    public void setDialog(UUID dialogId, DialogDataEntry dialogData) {
        if (dialogData == null) {
            log.error("Dialog data is null, please check your dialog data!");
            return;
        }
        if (this.hasDialog(dialogId)) {
            this.removeDialog(dialogId);
        }
        this.addDialog(dialogData);
    }

    public boolean addDialog(DialogDataEntry dialogData) {
        if (dialogData == null) {
            log.error("Dialog data is null, please check your dialog data!");
            return false;
        }
        if (dialogData.getId() == null) {
            log.error("Dialog id is null, please check your dialog data!");
            return false;
        }
        if (dialogData.getLabel() == null) {
            log.error("Dialog label is null, please check your dialog data!");
            return false;
        }
        if (dialogData.getText() == null || dialogData.getText().isEmpty()) {
            log.error("Dialog text is null or empty, please check your dialog data!");
            return false;
        }
        String dialogLabel = dialogData.getLabel();
        UUID dialogId = dialogData.getId();
        DialogDataEntry existingDialogData = this.dialogByIdMap.getOrDefault(dialogId, null);
        if (existingDialogData != null && !existingDialogData.equals(dialogData)) {
            log.warn("Duplicated dialog with id {} found, will overwrite existing dialog {} with {}!", (Object)dialogId, (Object)dialogData, (Object)existingDialogData);
        }
        this.dialogByLabelMap.put(dialogLabel, dialogData);
        this.dialogByIdMap.put(dialogId, dialogData);
        return true;
    }

    public boolean removeDialog(UUID dialogId) {
        DialogDataEntry dialogData = this.dialogByIdMap.getOrDefault(dialogId, null);
        if (dialogData != null) {
            DialogDataEntry formerDialogData = this.dialogByIdMap.remove(dialogData.getId());
            if (formerDialogData != null) {
                this.dialogByLabelMap.remove(formerDialogData.getLabel());
            }
            return true;
        }
        return false;
    }

    public boolean removeDialogButton(UUID dialogId, UUID dialogButtonId) {
        DialogDataEntry dialogData = this.dialogByIdMap.getOrDefault(dialogId, null);
        if (dialogData != null) {
            return dialogData.removeDialogButton(dialogButtonId);
        }
        return false;
    }

    public List<DialogDataEntry> getDialogsByLabel() {
        return this.dialogByLabelMap.values().stream().sorted(Comparator.comparing(DialogDataEntry::getLabel)).toList();
    }

    public Map<String, DialogDataEntry> getDialogByLabelMap() {
        return this.dialogByLabelMap;
    }

    public DialogDataEntry getDialog(String label) {
        return this.dialogByLabelMap.getOrDefault(label, null);
    }

    public DialogDataEntry getDialog(UUID id) {
        return this.dialogByIdMap.getOrDefault(id, null);
    }

    public UUID getDialogId(String dialogLabel) {
        DialogDataEntry dialogData = this.dialogByLabelMap.getOrDefault(dialogLabel, null);
        if (dialogData != null) {
            return dialogData.getId();
        }
        return null;
    }

    public boolean hasDialog() {
        return !this.dialogByLabelMap.isEmpty();
    }

    public boolean hasDialog(String label) {
        return this.dialogByLabelMap.containsKey(label);
    }

    public boolean hasDialog(UUID id) {
        return this.dialogByIdMap.containsKey(id);
    }

    public boolean hasDialogButton(UUID dialogId, UUID dialogButtonId) {
        return this.dialogByIdMap.containsKey(dialogId) && this.dialogByIdMap.get(dialogId).hasDialogButton(dialogButtonId);
    }

    public DialogButtonEntry getDialogButton(UUID dialogId, UUID dialogButtonId) {
        DialogDataEntry dialogData = this.dialogByIdMap.getOrDefault(dialogId, null);
        if (dialogData != null) {
            return dialogData.getDialogButton(dialogButtonId);
        }
        return null;
    }

    public DialogDataEntry getNextAvailableDialog(class_3222 serverPlayer) {
        return this.dialogByIdMap.values().stream().filter(dialog -> dialog.getPriority() >= 0).filter(dialog -> this.checkConditions((DialogDataEntry)dialog, serverPlayer)).sorted(Comparator.comparingInt(DialogDataEntry::getPriority).reversed().thenComparing(Comparator.comparing(DialogDataEntry::getLabel))).findFirst().orElse(null);
    }

    private boolean checkConditions(DialogDataEntry dialog, class_3222 serverPlayer) {
        if (!dialog.hasConditions()) {
            log.debug("Dialog {} has no conditions, allowing", (Object)dialog.getLabel());
            return true;
        }
        if (serverPlayer == null) {
            log.debug("Cannot check conditions for dialog {} without player context, allowing dialog by default", (Object)dialog.getLabel());
            return true;
        }
        for (ConditionDataEntry condition : dialog.getConditions()) {
            if (!condition.isValid()) {
                log.debug("Skipping invalid condition {} for dialog {}", (Object)condition, (Object)dialog.getLabel());
                continue;
            }
            boolean conditionResult = this.evaluateCondition(condition, serverPlayer, dialog.getId());
            log.debug("Condition check for dialog {}: {} {} {} = {} (result: {})", (Object)dialog.getLabel(), (Object)condition.conditionType(), (Object)condition.name(), (Object)(condition.operationType().getSymbol() + " " + condition.value()), (Object)(conditionResult ? "PASS" : "FAIL"), (Object)conditionResult);
            if (conditionResult) continue;
            log.debug("Dialog {} rejected: condition not met ({} {} {} {})", (Object)dialog.getLabel(), (Object)condition.conditionType(), (Object)condition.name(), (Object)condition.operationType().getSymbol(), (Object)condition.value());
            return false;
        }
        log.debug("Dialog {} accepted: all conditions passed", (Object)dialog.getLabel());
        return true;
    }

    public void recordDialogExecution(DialogDataEntry dialog, class_3222 serverPlayer) {
        if (dialog == null || serverPlayer == null || !dialog.hasConditions()) {
            return;
        }
        for (ConditionDataEntry condition : dialog.getConditions()) {
            if (condition.conditionType() != ConditionType.EXECUTION_LIMIT || !condition.isValid()) continue;
            ConditionUtils.recordActionExecution(condition, serverPlayer, dialog.getId());
        }
    }

    private boolean evaluateCondition(ConditionDataEntry condition, class_3222 serverPlayer, UUID dialogId) {
        return switch (condition.conditionType()) {
            default -> throw new MatchException(null, null);
            case ConditionType.SCOREBOARD -> this.evaluateScoreboardCondition(condition, serverPlayer);
            case ConditionType.EXECUTION_LIMIT -> ConditionUtils.evaluateCondition(condition, serverPlayer, dialogId);
            case ConditionType.NONE -> {
                log.warn("Encountered NONE condition type, skipping");
                yield true;
            }
        };
    }

    private boolean evaluateScoreboardCondition(ConditionDataEntry condition, class_3222 serverPlayer) {
        if (!condition.hasName()) {
            log.warn("Scoreboard condition missing objective name!");
            return false;
        }
        int actualValue = -1;
        try {
            class_269 scoreboard = serverPlayer.method_7327();
            class_266 objective = scoreboard.method_1170(condition.name());
            if (objective == null) {
                log.debug("Scoreboard objective '{}' not found for player {}, using default value -1", (Object)condition.name(), (Object)serverPlayer.method_5477().getString());
            } else {
                actualValue = scoreboard.method_1180((class_9015)serverPlayer, objective).method_55409();
            }
            int expectedValue = condition.value();
            boolean result = condition.operationType().evaluate(actualValue, expectedValue);
            log.debug("Scoreboard check: {} (actual: {}) {} {} (expected: {}) = {}", (Object)condition.name(), (Object)actualValue, (Object)condition.operationType().getSymbol(), (Object)expectedValue, (Object)expectedValue, (Object)result);
            return result;
        }
        catch (Exception e) {
            log.error("Error evaluating scoreboard condition for dialog: {}", (Object)condition, (Object)e);
            return false;
        }
    }

    public DialogType getType() {
        return this.dialogType;
    }

    public void load(class_2487 compoundTag) {
        if (compoundTag == null || !compoundTag.method_10545(DATA_DIALOG_DATA_SET_TAG)) {
            return;
        }
        if (compoundTag.method_10545(DATA_TYPE_TAG)) {
            this.dialogType = DialogType.valueOf(compoundTag.method_10558(DATA_TYPE_TAG));
        }
        this.dialogByLabelMap.clear();
        this.dialogByIdMap.clear();
        class_2499 dialogListTag = compoundTag.method_10554(DATA_DIALOG_DATA_SET_TAG, 10);
        for (int i = 0; i < dialogListTag.size(); ++i) {
            class_2487 dialogCompoundTag = dialogListTag.method_10602(i);
            DialogDataEntry dialogData = new DialogDataEntry(dialogCompoundTag);
            this.addDialog(dialogData);
        }
    }

    public class_2487 save(class_2487 compoundTag) {
        class_2499 dialogListTag = new class_2499();
        for (DialogDataEntry dialogData : this.dialogByLabelMap.values()) {
            if (dialogData == null || dialogData.getId() == null || dialogData.getLabel() == null || dialogData.getText().isEmpty()) continue;
            dialogListTag.add((Object)dialogData.createTag());
        }
        compoundTag.method_10566(DATA_DIALOG_DATA_SET_TAG, (class_2520)dialogListTag);
        if (this.dialogType == DialogType.BASIC && this.dialogByIdMap.size() > 1 || this.dialogType == DialogType.YES_NO && this.dialogByIdMap.size() > 3) {
            this.dialogType = DialogType.STANDARD;
        } else if (this.dialogByIdMap.isEmpty()) {
            this.dialogType = DialogType.NONE;
        } else if (this.dialogType != DialogType.BASIC && this.dialogType != DialogType.YES_NO && this.dialogType != DialogType.STANDARD) {
            this.dialogType = DialogType.CUSTOM;
        }
        compoundTag.method_10582(DATA_TYPE_TAG, this.dialogType.name());
        return compoundTag;
    }

    public class_2487 createTag() {
        return this.save(new class_2487());
    }

    public String toString() {
        return "DialogDataSet [type=" + String.valueOf((Object)this.dialogType) + ", " + String.valueOf(this.dialogByLabelMap) + "]";
    }
}

