/*
 * Decompiled with CFR 0.152.
 */
package de.markusbordihn.easynpc.data.display;

import de.markusbordihn.easynpc.data.display.DisplayAttributeEntry;
import de.markusbordihn.easynpc.data.display.DisplayAttributeType;
import de.markusbordihn.easynpc.data.display.NameVisibilityType;
import java.util.EnumMap;
import java.util.Map;
import net.minecraft.class_2487;
import net.minecraft.class_2499;
import net.minecraft.class_2520;
import net.minecraft.class_9129;
import net.minecraft.class_9139;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public record DisplayAttributeDataSet(EnumMap<DisplayAttributeType, DisplayAttributeEntry> attributes) {
    public static final class_9139<class_9129, DisplayAttributeDataSet> STREAM_CODEC = new class_9139<class_9129, DisplayAttributeDataSet>(){

        public DisplayAttributeDataSet decode(class_9129 registryFriendlyByteBuf) {
            return DisplayAttributeDataSet.decode(registryFriendlyByteBuf);
        }

        public void encode(class_9129 registryFriendlyByteBuf, DisplayAttributeDataSet displayAttributeDataSet) {
            displayAttributeDataSet.encode(registryFriendlyByteBuf);
        }
    };
    private static final Logger log = LogManager.getLogger((String)"Easy NPC: Core");

    public DisplayAttributeDataSet() {
        this(DisplayAttributeDataSet.createDefaultAttributes());
    }

    public DisplayAttributeDataSet(class_2499 listTag) {
        this(DisplayAttributeDataSet.readAttributesFromList(listTag));
    }

    public static DisplayAttributeDataSet createDefault() {
        return new DisplayAttributeDataSet();
    }

    private static EnumMap<DisplayAttributeType, DisplayAttributeEntry> createDefaultAttributes() {
        EnumMap<DisplayAttributeType, DisplayAttributeEntry> map = new EnumMap<DisplayAttributeType, DisplayAttributeEntry>(DisplayAttributeType.class);
        map.put(DisplayAttributeType.LIGHT_LEVEL, new DisplayAttributeEntry(7));
        map.put(DisplayAttributeType.VISIBLE, new DisplayAttributeEntry(true));
        map.put(DisplayAttributeType.VISIBLE_AT_DAY, new DisplayAttributeEntry(true));
        map.put(DisplayAttributeType.VISIBLE_AT_NIGHT, new DisplayAttributeEntry(true));
        map.put(DisplayAttributeType.VISIBLE_IN_CREATIVE, new DisplayAttributeEntry(true));
        map.put(DisplayAttributeType.VISIBLE_IN_SPECTATOR, new DisplayAttributeEntry(true));
        map.put(DisplayAttributeType.VISIBLE_IN_STANDARD, new DisplayAttributeEntry(true));
        map.put(DisplayAttributeType.VISIBLE_TO_OWNER, new DisplayAttributeEntry(true));
        map.put(DisplayAttributeType.VISIBLE_TO_TEAM, new DisplayAttributeEntry(true));
        map.put(DisplayAttributeType.NAME_VISIBILITY, new DisplayAttributeEntry(NameVisibilityType.ALWAYS.toString()));
        return map;
    }

    private static EnumMap<DisplayAttributeType, DisplayAttributeEntry> readAttributesFromList(class_2499 listTag) {
        if (listTag == null || listTag.isEmpty()) {
            log.warn("Received null or empty ListTag for DisplayAttributeDataSet, using defaults");
            return DisplayAttributeDataSet.createDefaultAttributes();
        }
        EnumMap<DisplayAttributeType, DisplayAttributeEntry> map = new EnumMap<DisplayAttributeType, DisplayAttributeEntry>(DisplayAttributeType.class);
        for (class_2520 entry : listTag) {
            class_2487 entryCompoundTag;
            if (!(entry instanceof class_2487) || !(entryCompoundTag = (class_2487)entry).method_10545("Type")) {
                log.warn("Invalid entry in DisplayAttributeDataSet ListTag: {}", (Object)entry);
                continue;
            }
            DisplayAttributeType displayAttributeType = DisplayAttributeType.get(entryCompoundTag.method_10558("Type"));
            if (displayAttributeType == DisplayAttributeType.NONE) continue;
            map.put(displayAttributeType, new DisplayAttributeEntry(entryCompoundTag));
        }
        return map;
    }

    public static DisplayAttributeDataSet decode(class_9129 buffer) {
        int size = buffer.method_10816();
        EnumMap<DisplayAttributeType, DisplayAttributeEntry> map = new EnumMap<DisplayAttributeType, DisplayAttributeEntry>(DisplayAttributeType.class);
        for (int i = 0; i < size; ++i) {
            DisplayAttributeType type = (DisplayAttributeType)buffer.method_10818(DisplayAttributeType.class);
            boolean boolValue = buffer.readBoolean();
            int intValue = buffer.method_10816();
            String stringValue = buffer.method_19772();
            if (type == DisplayAttributeType.NONE) continue;
            map.put(type, new DisplayAttributeEntry(boolValue, intValue, stringValue));
        }
        return new DisplayAttributeDataSet(map);
    }

    public boolean hasAttribute(DisplayAttributeType attributeType) {
        return this.attributes.containsKey((Object)attributeType);
    }

    public DisplayAttributeEntry getAttribute(DisplayAttributeType attributeType) {
        return this.attributes.get((Object)attributeType);
    }

    public DisplayAttributeDataSet withAttribute(DisplayAttributeType attributeType, DisplayAttributeEntry entry) {
        if (attributeType == null || entry == null) {
            return this;
        }
        EnumMap<DisplayAttributeType, DisplayAttributeEntry> newAttributes = new EnumMap<DisplayAttributeType, DisplayAttributeEntry>(this.attributes);
        newAttributes.put(attributeType, entry);
        return new DisplayAttributeDataSet(newAttributes);
    }

    public class_2499 save() {
        class_2499 listTag = new class_2499();
        if (this.attributes == null || this.attributes.isEmpty()) {
            return listTag;
        }
        for (Map.Entry<DisplayAttributeType, DisplayAttributeEntry> entry : this.attributes.entrySet()) {
            if (entry.getKey() == DisplayAttributeType.NONE) continue;
            class_2487 entryTag = new class_2487();
            entryTag.method_10582("Type", entry.getKey().name());
            entry.getValue().write(entryTag);
            listTag.add((Object)entryTag);
        }
        return listTag;
    }

    public void encode(class_9129 buffer) {
        buffer.method_10804((int)this.attributes.keySet().stream().filter(key -> key != DisplayAttributeType.NONE).count());
        for (Map.Entry<DisplayAttributeType, DisplayAttributeEntry> entry : this.attributes.entrySet()) {
            if (entry.getKey() == DisplayAttributeType.NONE) continue;
            buffer.method_10817((Enum)entry.getKey());
            buffer.method_52964(entry.getValue().booleanValue());
            buffer.method_10804(entry.getValue().intValue());
            buffer.method_10814(entry.getValue().stringValue());
        }
    }
}

