/*
 * Decompiled with CFR 0.152.
 */
package de.markusbordihn.easynpc.data.execution;

import de.markusbordihn.easynpc.data.execution.ExecutionData;
import java.util.HashMap;
import java.util.Map;
import java.util.UUID;
import net.minecraft.class_2487;
import net.minecraft.class_2499;
import net.minecraft.class_2520;

public record ExecutionTrackerData(Map<UUID, Map<UUID, ExecutionData>> trackingData) {
    public static final String DATA_PLAYERS_TAG = "Players";
    public static final String DATA_PLAYER_UUID_TAG = "PlayerUUID";
    public static final String DATA_TARGETS_TAG = "Targets";
    public static final String DATA_TARGET_UUID_TAG = "TargetUUID";

    public ExecutionTrackerData() {
        this(new HashMap<UUID, Map<UUID, ExecutionData>>());
    }

    public ExecutionTrackerData(class_2487 tag) {
        this(ExecutionTrackerData.loadFromTag(tag));
    }

    private static Map<UUID, Map<UUID, ExecutionData>> loadFromTag(class_2487 compoundTag) {
        HashMap<UUID, Map<UUID, ExecutionData>> data = new HashMap<UUID, Map<UUID, ExecutionData>>();
        class_2499 playersTag = compoundTag.method_10554(DATA_PLAYERS_TAG, 10);
        for (int i = 0; i < playersTag.size(); ++i) {
            class_2487 playerTag = playersTag.method_10602(i);
            UUID playerUUID = playerTag.method_25926(DATA_PLAYER_UUID_TAG);
            HashMap<UUID, ExecutionData> playerData = new HashMap<UUID, ExecutionData>();
            class_2499 targetsTag = playerTag.method_10554(DATA_TARGETS_TAG, 10);
            for (int j = 0; j < targetsTag.size(); ++j) {
                class_2487 targetTag = targetsTag.method_10602(j);
                playerData.put(targetTag.method_25926(DATA_TARGET_UUID_TAG), new ExecutionData(targetTag));
            }
            data.put(playerUUID, playerData);
        }
        return data;
    }

    public class_2487 save(class_2487 compoundTag) {
        class_2499 playersTag = new class_2499();
        for (Map.Entry<UUID, Map<UUID, ExecutionData>> playerEntry : this.trackingData.entrySet()) {
            class_2487 playerTag = new class_2487();
            playerTag.method_25927(DATA_PLAYER_UUID_TAG, playerEntry.getKey());
            class_2499 targetsTag = new class_2499();
            for (Map.Entry<UUID, ExecutionData> targetEntry : playerEntry.getValue().entrySet()) {
                class_2487 targetTag = new class_2487();
                targetTag.method_25927(DATA_TARGET_UUID_TAG, targetEntry.getKey());
                targetEntry.getValue().save(targetTag);
                targetsTag.add((Object)targetTag);
            }
            playerTag.method_10566(DATA_TARGETS_TAG, (class_2520)targetsTag);
            playersTag.add((Object)playerTag);
        }
        compoundTag.method_10566(DATA_PLAYERS_TAG, (class_2520)playersTag);
        return compoundTag;
    }

    public class_2487 save() {
        return this.save(new class_2487());
    }
}

