/*
 * Decompiled with CFR 0.152.
 */
package de.markusbordihn.easynpc.data.npc;

import de.markusbordihn.easynpc.entity.easynpc.EasyNPC;
import java.util.UUID;
import net.minecraft.class_1308;
import net.minecraft.class_2487;
import net.minecraft.class_2960;

public record NPCEntityMetadata(UUID ownerUUID, String entityType, String dimension, UUID presetUUID, class_2960 customIdentifier) {
    public static final String TAG_DIMENSION = "Dimension";
    public static final String TAG_OWNER = "Owner";
    public static final String TAG_ENTITY_TYPE = "EntityType";
    public static final String TAG_PRESET_UUID = "PresetUUID";
    public static final String TAG_CUSTOM_IDENTIFIER = "CustomIdentifier";

    public static <T extends class_1308> NPCEntityMetadata fromEasyNPC(EasyNPC<T> easyNPC) {
        if (easyNPC == null || easyNPC.getEntity() == null) {
            return new NPCEntityMetadata(null, null, null, null, null);
        }
        UUID ownerUUID = null;
        if (easyNPC.getEasyNPCOwnerData() != null) {
            ownerUUID = easyNPC.getEasyNPCOwnerData().method_6139();
        }
        String entityType = easyNPC.getEntityTypeId();
        String dimension = null;
        if (easyNPC.getEntity().method_37908() != null) {
            dimension = easyNPC.getEntity().method_37908().method_27983().method_29177().toString();
        }
        UUID presetUUID = null;
        if (easyNPC.getEasyNPCPresetData() != null && easyNPC.getEasyNPCPresetData().hasPresetUUID()) {
            presetUUID = easyNPC.getEasyNPCPresetData().getPresetUUID();
        }
        class_2960 customIdentifier = easyNPC.getCustomNPCIdentifier();
        return new NPCEntityMetadata(ownerUUID, entityType, dimension, presetUUID, customIdentifier);
    }

    public static NPCEntityMetadata fromCompoundTag(class_2487 tag) {
        if (tag == null || tag.method_33133()) {
            return new NPCEntityMetadata(null, null, null, null, null);
        }
        UUID ownerUUID = tag.method_10545(TAG_OWNER) ? tag.method_25926(TAG_OWNER) : null;
        String entityType = tag.method_10545(TAG_ENTITY_TYPE) ? tag.method_10558(TAG_ENTITY_TYPE) : null;
        String dimension = tag.method_10545(TAG_DIMENSION) ? tag.method_10558(TAG_DIMENSION) : null;
        UUID presetUUID = tag.method_10545(TAG_PRESET_UUID) ? tag.method_25926(TAG_PRESET_UUID) : null;
        class_2960 customIdentifier = null;
        if (tag.method_10545(TAG_CUSTOM_IDENTIFIER)) {
            try {
                customIdentifier = class_2960.method_60654((String)tag.method_10558(TAG_CUSTOM_IDENTIFIER));
            }
            catch (IllegalArgumentException illegalArgumentException) {
                // empty catch block
            }
        }
        return new NPCEntityMetadata(ownerUUID, entityType, dimension, presetUUID, customIdentifier);
    }

    public class_2487 toCompoundTag() {
        class_2487 tag = new class_2487();
        if (this.ownerUUID != null) {
            tag.method_25927(TAG_OWNER, this.ownerUUID);
        }
        if (this.entityType != null && !this.entityType.isEmpty()) {
            tag.method_10582(TAG_ENTITY_TYPE, this.entityType);
        }
        if (this.dimension != null && !this.dimension.isEmpty()) {
            tag.method_10582(TAG_DIMENSION, this.dimension);
        }
        if (this.presetUUID != null) {
            tag.method_25927(TAG_PRESET_UUID, this.presetUUID);
        }
        if (this.customIdentifier != null) {
            tag.method_10582(TAG_CUSTOM_IDENTIFIER, this.customIdentifier.toString());
        }
        return tag;
    }

    public boolean hasOwner() {
        return this.ownerUUID != null;
    }

    public boolean hasEntityType() {
        return this.entityType != null && !this.entityType.isEmpty();
    }

    public boolean hasDimension() {
        return this.dimension != null && !this.dimension.isEmpty();
    }

    public boolean hasPreset() {
        return this.presetUUID != null;
    }

    public boolean hasCustomIdentifier() {
        return this.customIdentifier != null;
    }
}

