/*
 * Decompiled with CFR 0.152.
 */
package de.markusbordihn.easynpc.data.npc;

import de.markusbordihn.easynpc.data.npc.NPCEntityMetadata;
import de.markusbordihn.easynpc.entity.easynpc.EasyNPC;
import de.markusbordihn.easynpc.entity.easynpc.data.PresetDataCapable;
import java.util.UUID;
import net.minecraft.class_1308;
import net.minecraft.class_2487;
import net.minecraft.class_2520;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public record SavedNPCEntityEntry(UUID entityUUID, class_2487 npcData, NPCEntityMetadata metadata) {
    private static final Logger log = LogManager.getLogger((String)"Easy NPC: Core");
    private static final String DATA_ENTITY_UUID_TAG = "EntityUUID";
    private static final String DATA_NPC_DATA_TAG = "NPCData";
    private static final String DATA_METADATA_TAG = "Metadata";

    public static <T extends class_1308> SavedNPCEntityEntry fromEasyNPC(EasyNPC<T> easyNPC) {
        if (easyNPC == null || easyNPC.getEntity() == null) {
            log.error("Cannot create SavedNPCEntityEntry from null EasyNPC or null entity");
            return null;
        }
        PresetDataCapable presetData = easyNPC.getEasyNPCPresetData();
        if (presetData == null) {
            log.error("Cannot serialize NPC {} - missing PresetDataCapable", (Object)easyNPC.getEntityUUID());
            return null;
        }
        NPCEntityMetadata metadata = NPCEntityMetadata.fromEasyNPC(easyNPC);
        return new SavedNPCEntityEntry(easyNPC.getEntityUUID(), presetData.serializePresetData(), metadata);
    }

    public static SavedNPCEntityEntry load(class_2487 compoundTag) {
        if (!compoundTag.method_10545(DATA_ENTITY_UUID_TAG)) {
            log.error("Cannot load SavedNPCEntityEntry - missing UUID");
            return null;
        }
        return new SavedNPCEntityEntry(compoundTag.method_25926(DATA_ENTITY_UUID_TAG), compoundTag.method_10545(DATA_NPC_DATA_TAG) ? compoundTag.method_10562(DATA_NPC_DATA_TAG) : new class_2487(), compoundTag.method_10545(DATA_METADATA_TAG) ? NPCEntityMetadata.fromCompoundTag(compoundTag.method_10562(DATA_METADATA_TAG)) : new NPCEntityMetadata(null, null, null, null, null));
    }

    public class_2487 save(class_2487 compoundTag) {
        compoundTag.method_25927(DATA_ENTITY_UUID_TAG, this.entityUUID);
        if (this.npcData != null && !this.npcData.method_33133()) {
            compoundTag.method_10566(DATA_NPC_DATA_TAG, (class_2520)this.npcData);
        }
        if (this.metadata != null) {
            compoundTag.method_10566(DATA_METADATA_TAG, (class_2520)this.metadata.toCompoundTag());
        }
        return compoundTag;
    }
}

